/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.npm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.npm.Messages;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public class NpmLaunchDelegate
implements ILaunchConfigurationDelegate {
    static final String ID = "org.eclipse.wildwebdeveloper.launchConfiguration.NPMLaunch";
    private MessageConsole console = new MessageConsole("NPM output", null);

    public NpmLaunchDelegate() {
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        File packageJSONDirectory = new File(configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", "No package.json directory path set").trim());
        File packageJSON = new File(configuration.getAttribute("program", "No package.json path set").trim());
        String argumentString = configuration.getAttribute("runtimeArgs", "No NPM argument set").trim();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(NodeJSManager.getNpmLocation().getAbsolutePath());
        arguments.addAll(Arrays.asList(argumentString.split(" ")));
        monitor.beginTask(String.valueOf(argumentString) + ' ' + packageJSON.getAbsolutePath(), 2);
        monitor.worked(1);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(packageJSONDirectory.getName());
        try {
            Process npmProcess = new ProcessBuilder(arguments).directory(packageJSONDirectory).start();
            DebugPlugin.newProcess((ILaunch)launch, (Process)npmProcess, (String)argumentString);
            CompletableFuture.runAsync(() -> {
                try {
                    npmProcess.waitFor();
                }
                catch (InterruptedException e) {
                    Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)errorStatus);
                    Display.getDefault().asyncExec(() -> NpmLaunchDelegate.lambda$1(e, (IStatus)errorStatus));
                }
            }).whenComplete((ok, ko) -> {
                if (project != null) {
                    try {
                        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)errorStatus);
                        Display.getDefault().asyncExec(() -> NpmLaunchDelegate.lambda$3(e, (IStatus)errorStatus));
                    }
                }
                monitor.done();
            });
        }
        catch (IOException e) {
            Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)errorStatus);
            Display.getDefault().asyncExec(() -> NpmLaunchDelegate.lambda$4(e, (IStatus)errorStatus));
        }
    }

    private static /* synthetic */ void lambda$4(IOException iOException, IStatus iStatus) {
        int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.NpmLaunchDelegate_npmError, (String)iOException.getMessage(), (IStatus)iStatus);
    }

    private static /* synthetic */ void lambda$1(InterruptedException interruptedException, IStatus iStatus) {
        int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.NpmLaunchDelegate_npmError, (String)interruptedException.getMessage(), (IStatus)iStatus);
    }

    private static /* synthetic */ void lambda$3(CoreException coreException, IStatus iStatus) {
        int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.NpmLaunchDelegate_npmError, (String)coreException.getMessage(), (IStatus)iStatus);
    }
}

