/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.NullPersistentAttributeFlavor;
import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.core.PersistentAttributeFlavor;
import org.eclipse.dali.core.adapters.IPersistentAttributeModelAdapter;
import org.eclipse.dali.core.adapters.java.Attribute;
import org.eclipse.dali.core.adapters.java.IJavaDefaultPersistentAttributeFlavorModelAdapter;
import org.eclipse.dali.core.adapters.java.IJavaPersistentAttributeFlavorModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaNullPersistentAttributeFlavorModelAdapter;
import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaPersistentAttributeModelAdapter
implements IPersistentAttributeModelAdapter {
    private Attribute attribute;
    private PersistentAttribute persistentAttribute;

    public JavaPersistentAttributeModelAdapter(Attribute attribute) {
        this.attribute = attribute;
    }

    public void engage(PersistentAttribute pa, CompilationUnit astRoot) {
        this.persistentAttribute = pa;
        this.updatePersModel(astRoot);
    }

    public boolean isPersistentAttributeFor(IMember member) {
        return this.attribute.isPersistentAttributeFor(member);
    }

    private void updatePersModel(CompilationUnit astRoot) {
        this.updatePersPersistentAttributeFlavor(astRoot);
    }

    private void updatePersPersistentAttributeFlavor(CompilationUnit astRoot) {
        IJavaPersistentAttributeFlavorModelAdapter adapter;
        IConfigurationElement javaFlavor = this.javaConfigurationElement(astRoot);
        PersistentAttributeFlavor persFlavor = this.persistentAttribute.getFlavor();
        if (javaFlavor == null) {
            this.updatePersFlavorFromJavaDefault(astRoot);
            return;
        }
        if (persFlavor != null && !persFlavor.isDefault() && javaFlavor.getAttribute(this.flavorNameExtensionAttribute()).equals(persFlavor.flavorName())) {
            IJavaPersistentAttributeFlavorModelAdapter adapter2 = (IJavaPersistentAttributeFlavorModelAdapter)persFlavor.getModelAdapter();
            adapter2.updatePersModel(astRoot);
            return;
        }
        try {
            adapter = (IJavaPersistentAttributeFlavorModelAdapter)javaFlavor.createExecutableExtension(this.flavorModelAdapterExtensionAttribute());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        PersistentAttributeFlavor persistentAttributeType = adapter.createFlavor(false);
        this.persistentAttribute.setFlavor(persistentAttributeType);
        adapter.engage(this.attribute, astRoot);
    }

    private void updatePersFlavorFromJavaDefault(CompilationUnit astRoot) {
        IJavaPersistentAttributeFlavorModelAdapter adapter;
        IConfigurationElement javaFlavor = this.javaDefaultConfigurationElement();
        PersistentAttributeFlavor persFlavor = this.persistentAttribute.getFlavor();
        if (javaFlavor == null) {
            if (persFlavor instanceof NullPersistentAttributeFlavor) {
                return;
            }
            JavaNullPersistentAttributeFlavorModelAdapter adapter2 = new JavaNullPersistentAttributeFlavorModelAdapter();
            this.persistentAttribute.setFlavor(adapter2.createFlavor(false));
            return;
        }
        if (persFlavor != null && persFlavor.isDefault() && javaFlavor.getAttribute(this.flavorNameExtensionAttribute()).equals(persFlavor.flavorName())) {
            IJavaPersistentAttributeFlavorModelAdapter adapter3 = (IJavaPersistentAttributeFlavorModelAdapter)persFlavor.getModelAdapter();
            adapter3.updatePersModel(astRoot);
            return;
        }
        try {
            adapter = (IJavaPersistentAttributeFlavorModelAdapter)javaFlavor.createExecutableExtension("javaDefaultModelAdapter");
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        PersistentAttributeFlavor persistentAttributeType = adapter.createFlavor(true);
        this.persistentAttribute.setFlavor(persistentAttributeType);
        adapter.engage(this.attribute, astRoot);
    }

    private IConfigurationElement configurationElementFor(String key) {
        IConfigurationElement[] mappingChoices = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dali.core.mappings");
        int i = 0;
        while (i < mappingChoices.length) {
            if (key.equals(mappingChoices[i].getAttribute("key"))) {
                return mappingChoices[i];
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    public void setFlavorKey(String flavorKey, boolean isDefault) {
        IJavaPersistentAttributeFlavorModelAdapter modelAdapter;
        IConfigurationElement element = this.configurationElementFor(flavorKey);
        try {
            modelAdapter = (IJavaPersistentAttributeFlavorModelAdapter)element.createExecutableExtension(this.flavorModelAdapterExtensionAttribute());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        PersistentAttributeFlavor flavor = modelAdapter.createFlavor(isDefault);
        this.persistentAttribute.setFlavor(flavor);
        modelAdapter.engage(this.attribute, this.attribute.createASTRoot());
        this.updateJavaPersistentAttributeFlavor();
    }

    private void updateJavaPersistentAttributeFlavor() {
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        IConfigurationElement javaConfigurationElement = this.javaConfigurationElement(astRoot);
        String javaPersistentAttributeFlavor = null;
        if (javaConfigurationElement != null) {
            javaPersistentAttributeFlavor = javaConfigurationElement.getAttribute(this.flavorNameExtensionAttribute());
        }
        PersistentAttributeFlavor persPersistentAttributeFlavor = this.persistentAttribute.getFlavor();
        if (javaPersistentAttributeFlavor != null && persPersistentAttributeFlavor.flavorName().equals(javaPersistentAttributeFlavor)) {
            return;
        }
        if (!this.containsAnnotation(persPersistentAttributeFlavor.flavorName(), astRoot)) {
            this.removeExistingMappingAnnotation(astRoot);
            ((IJavaPersistentAttributeFlavorModelAdapter)persPersistentAttributeFlavor.getModelAdapter()).addMappingAnnotation();
        }
    }

    private IConfigurationElement javaConfigurationElement(CompilationUnit astRoot) {
        Iterator i = DaliPlugin.getPlugin().annotationMappingConfigurationElements();
        while (i.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)i.next();
            String annotationName = element.getAttribute(this.flavorNameExtensionAttribute());
            if (!this.containsAnnotation(annotationName, astRoot)) continue;
            return element;
        }
        return null;
    }

    private IConfigurationElement javaDefaultConfigurationElement() {
        Iterator i = DaliPlugin.getPlugin().defaultAnnotationMappingConfigurationElements();
        while (i.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)i.next();
            try {
                IJavaDefaultPersistentAttributeFlavorModelAdapter adapter = (IJavaDefaultPersistentAttributeFlavorModelAdapter)element.createExecutableExtension("javaDefaultModelAdapter");
                if (!adapter.defaultApplies(this.attribute)) continue;
                return element;
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    void synchWithJava(CompilationUnit astRoot) {
        this.updatePersModel(astRoot);
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public String getName() {
        return this.attribute.getName();
    }

    private void removeExistingMappingAnnotation(CompilationUnit astRoot) {
        Iterator i = DaliPlugin.getPlugin().possibleAnnotationsMappings();
        while (i.hasNext()) {
            String annotationName = (String)i.next();
            if (!this.containsAnnotation(annotationName, astRoot)) continue;
            this.removeAnnotation(annotationName);
        }
    }

    public void removeAnnotation(final String annotationName) {
        this.attribute.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                ASTTools.removeAnnotation(bodyDeclaration, annotationName);
            }
        });
    }

    public Annotation getAnnotation(String annotationName, CompilationUnit astRoot) {
        return ASTTools.getAnnotation(this.attribute.bodyDeclaration(astRoot), annotationName);
    }

    public boolean containsAnnotation(String annotationName, CompilationUnit astRoot) {
        return this.getAnnotation(annotationName, astRoot) != null;
    }

    public boolean containsAnnotationElement(String annotationName, String elementName, CompilationUnit astRoot) {
        BodyDeclaration bodyDeclaration = this.attribute.bodyDeclaration(astRoot);
        if (bodyDeclaration != null) {
            return ASTTools.containsAnnotationElement(bodyDeclaration, annotationName, elementName);
        }
        return false;
    }

    public ITextRange getTextRange() {
        ISourceRange sourceRange;
        try {
            sourceRange = this.attribute.getJDTMember().getNameRange();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        return new ITextRange(){

            public int getOffset() {
                return sourceRange.getOffset();
            }

            public int getLength() {
                return sourceRange.getLength();
            }

            public int getLineNumber() {
                return 0;
            }
        };
    }

    public String flavorModelAdapterExtensionAttribute() {
        return "javaModelAdapter";
    }

    public String flavorNameExtensionAttribute() {
        return "annotationName";
    }
}

