/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.xpath.XPathExpression;
import org.eclipse.vjet.dsf.common.DsfVerifierConfig;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.binding.IValueBinding;
import org.eclipse.vjet.dsf.common.binding.SimpleValueBinding;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.event.AbortDsfEventProcessingException;
import org.eclipse.vjet.dsf.common.event.DsfEvent;
import org.eclipse.vjet.dsf.common.event.IDsfEventListener;
import org.eclipse.vjet.dsf.common.event.IDsfEventStrategy;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.naming.IDsfName;
import org.eclipse.vjet.dsf.common.naming.IDsfNamingFamily;
import org.eclipse.vjet.dsf.common.naming.NameChecker;
import org.eclipse.vjet.dsf.common.node.DNodeId;
import org.eclipse.vjet.dsf.common.node.DNodeName;
import org.eclipse.vjet.dsf.common.node.IAttributeMap;
import org.eclipse.vjet.dsf.common.node.IDNodeList;
import org.eclipse.vjet.dsf.common.node.IDNodeRelationshipVerifier;
import org.eclipse.vjet.dsf.common.node.IDsfEventListeners;
import org.eclipse.vjet.dsf.common.node.IDsfNode;
import org.eclipse.vjet.dsf.common.node.IDsfStrategies;
import org.eclipse.vjet.dsf.common.node.IFacetsMap;
import org.eclipse.vjet.dsf.common.node.Initializer;
import org.eclipse.vjet.dsf.common.node.visitor.AbortDNodeTraversalException;
import org.eclipse.vjet.dsf.common.node.visitor.DNodeVisitStatus;
import org.eclipse.vjet.dsf.common.node.visitor.DefaultDNodeHandlingStrategy;
import org.eclipse.vjet.dsf.common.node.visitor.DefaultDNodeVisitor;
import org.eclipse.vjet.dsf.common.node.visitor.DepthFirstDNodeTraversal;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeHandlingStrategy;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeVisitor;
import org.eclipse.vjet.dsf.common.phase.PhaseDriver;
import org.eclipse.vjet.dsf.common.phase.PhaseId;
import org.eclipse.vjet.dsf.common.trace.TraceCtx;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DComment;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DDocumentFragment;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNodeList;
import org.eclipse.vjet.dsf.dom.DProcessingInstruction;
import org.eclipse.vjet.dsf.dom.DRawString;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.dom.DsfEventListeners;
import org.eclipse.vjet.dsf.dom.DsfStrategies;
import org.eclipse.vjet.dsf.dom.FacetsMap;
import org.eclipse.vjet.dsf.dom.IgnoreAsNativeProperty;
import org.eclipse.vjet.dsf.dom.XPathResult;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.eclipse.vjet.dsf.dom.support.DsfDomLevelNotSupportedException;
import org.eclipse.vjet.dsf.dom.support.DsfDomNotSupportedRuntimeException;
import org.eclipse.vjet.dsf.dom.support.Jif;
import org.eclipse.vjet.kernel.stage.IStage;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class DNode
implements Node,
NodeList,
IDsfNode {
    protected String m_nodeName;
    protected String m_nodeValue;
    private DNode m_parentNode;
    protected String m_prefix;
    protected String m_localName;
    protected DNamespace m_dsfNamespace;
    protected DNodeList m_childNodes;
    protected transient DDocument m_ownerDocument;
    protected FacetsMap m_facets;
    private transient TraceCtx m_traceCtx;
    private DNodeId m_nodeId;
    private boolean m_exportingLocalNames = true;
    private IDNodeRelationshipVerifier m_dsfRelationshipVerifier;
    private IDsfNamingFamily m_dsfNamingFamily;
    private IDsfName m_dsfName;
    protected transient Map<String, Object> m_userData;
    private transient IDsfStrategies m_strategies;
    protected transient IDsfEventListeners m_listeners;
    private transient PropertyDescriptorMap m_propertyDescriptors;
    private transient Map<String, Field> m_valueBindingMap;
    private static WeakHashMap<Class<?>, Map<String, Field>> s_valueBindings = new WeakHashMap();
    private static WeakHashMap<Class<?>, PropertyDescriptorMap> s_descriptors = new WeakHashMap();
    public static final Iterator<DNode> EMPTY_ITERATOR = new Iterator<DNode>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public DNode next() {
            throw new DsfRuntimeException("no elements left");
        }

        @Override
        public void remove() {
            throw new DsfRuntimeException("not implemented");
        }
    };

    static {
        Initializer.init();
    }

    DNode() {
        this(null, null);
    }

    DNode(DDocument document) {
        this(document, null);
    }

    DNode(DDocument document, String nodeName) {
        DsfCtx.ctx().getContainer().checkNodeInstantiation(this);
        this.m_nodeName = nodeName;
        this.m_ownerDocument = document;
    }

    @Override
    public String getNodeName() {
        return this.m_nodeName;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.m_nodeValue;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.m_nodeValue = nodeValue;
    }

    @Override
    public abstract short getNodeType();

    @Override
    public Node getParentNode() {
        return this.m_parentNode;
    }

    @Override
    public NodeList getChildNodes() {
        if (this.m_childNodes == null) {
            this.m_childNodes = this.createChildNodes();
        }
        return this.m_childNodes;
    }

    public NodeList getChildNodes(int initialSize) {
        if (this.m_childNodes == null) {
            if (initialSize < 0) {
                DNode.chuck("The initialSize must not be negative");
            }
            this.createChildNodes(this, initialSize);
        }
        return this.m_childNodes;
    }

    @Override
    public Iterator<DNode> getChildNodesIterator() {
        if (this.hasChildNodes()) {
            return this.m_childNodes.iterator();
        }
        return EMPTY_ITERATOR;
    }

    @Override
    public Iterator<DNode> getChildrenAndFacetsItr() {
        Iterator<DNode> itr = this.getItrIfFacetOrChildIsEmpty();
        if (itr != null) {
            return itr;
        }
        ArrayList<DNode> combined = new ArrayList<DNode>(this.m_facets.size() + this.m_childNodes.size());
        combined.addAll(this.m_childNodes);
        combined.addAll(this.m_facets.values());
        return combined.iterator();
    }

    @Override
    public Iterator<DNode> getFacetsAndChildrenItr() {
        Iterator<DNode> itr = this.getItrIfFacetOrChildIsEmpty();
        if (itr != null) {
            return itr;
        }
        ArrayList<DNode> combined = new ArrayList<DNode>(this.m_facets.size() + this.m_childNodes.size());
        combined.addAll(this.m_facets.values());
        combined.addAll(this.m_childNodes);
        return combined.iterator();
    }

    private Iterator<DNode> getItrIfFacetOrChildIsEmpty() {
        if (!this.hasDsfFacets()) {
            if (this.hasChildNodes()) {
                return this.m_childNodes.iterator();
            }
            return EMPTY_ITERATOR;
        }
        if (!this.hasChildNodes()) {
            return this.m_facets.values().iterator();
        }
        return null;
    }

    @Override
    public Node getFirstChild() {
        if (this.m_childNodes == null) {
            return null;
        }
        if (this.m_childNodes.isEmpty()) {
            return null;
        }
        return (Node)this.m_childNodes.get(0);
    }

    @Override
    public Node getLastChild() {
        if (this.m_childNodes == null) {
            return null;
        }
        if (this.m_childNodes.isEmpty()) {
            return null;
        }
        return (Node)this.m_childNodes.get(this.m_childNodes.getLength() - 1);
    }

    @Override
    public Node getPreviousSibling() {
        if (this.m_parentNode == null) {
            return null;
        }
        if (this.m_parentNode.m_childNodes == null) {
            return null;
        }
        int index = this.m_parentNode.m_childNodes.indexOf(this);
        if (index <= 0) {
            return null;
        }
        DNode node = (DNode)this.m_parentNode.m_childNodes.get(index - 1);
        return node;
    }

    @Override
    public Node getNextSibling() {
        if (this.m_parentNode == null) {
            return null;
        }
        if (this.m_parentNode.m_childNodes == null) {
            return null;
        }
        int index = this.m_parentNode.m_childNodes.indexOf(this);
        if (index < 0 || index + 1 >= this.m_parentNode.m_childNodes.size()) {
            return null;
        }
        DNode node = (DNode)this.m_parentNode.m_childNodes.get(index + 1);
        return node;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return this.getDsfOwnerDocument();
    }

    public DDocument getDsfOwnerDocument() {
        return this.m_ownerDocument;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild instanceof DocumentFragment) {
            DDocumentFragment fragment = (DDocumentFragment)newChild;
            while (fragment.getLength() > 0) {
                DNode node = fragment.m_childNodes == null ? null : (DNode)fragment.m_childNodes.get(0);
                this.insertBeforeInternal(node, refChild);
            }
        } else {
            this.insertBeforeInternal(newChild, refChild);
        }
        return newChild;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertBeforeInternal(Node newChild, Node refChild) throws DOMException {
        if (refChild == null) {
            this.appendChild(newChild);
        }
        if (newChild == refChild) {
            return;
        }
        if (newChild.getParentNode() == this) {
            int alreadyInIndex;
            int n = alreadyInIndex = this.m_childNodes == null ? -1 : this.m_childNodes.indexOf(newChild);
            if (alreadyInIndex < 0) throw new DOMException(16, "child has this parent, but cannot find it as a child");
            this.m_childNodes.remove(alreadyInIndex);
        } else {
            this.checkChildForAdd(newChild);
            if (newChild.getParentNode() != null) {
                newChild.getParentNode().removeChild(newChild);
            }
        }
        this.getChildNodes();
        if (refChild == null) {
            this.m_childNodes.privateAdd((DNode)newChild);
        } else {
            int index = this.m_childNodes.indexOf(refChild);
            if (index < 0) {
                throw new DOMException(8, "reference node not found");
            }
            this.m_childNodes.add(index, (DNode)newChild);
        }
        this.postChildAdd((DNode)newChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        int index;
        if (newChild == null) {
            throw new DOMException(16, "new child cannot be null");
        }
        int n = index = this.m_childNodes == null ? -1 : this.m_childNodes.indexOf(oldChild);
        if (index < 0) {
            throw new DOMException(8, "reference node not found");
        }
        this.removeChild(oldChild);
        this.getChildNodes();
        if (index >= this.m_childNodes.size()) {
            this.appendChild(newChild);
        } else {
            this.insertBefore(newChild, (Node)this.m_childNodes.get(index));
        }
        return oldChild;
    }

    public Node dsfReplaceChild(DNode newChild, DNode oldChild) throws DOMException {
        DNode result = (DNode)this.replaceChild(newChild, oldChild);
        result.dsfDetachFromOwnerDocument();
        return result;
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild == null) {
            throw new DOMException(8, "null node is not a child of this node");
        }
        DNode childx = (DNode)oldChild;
        if (childx.m_parentNode != this) {
            throw new DOMException(8, "node is not a child of this node");
        }
        this.getChildNodes();
        this.m_childNodes.privateRemove(childx);
        childx.m_parentNode = null;
        if (this.m_ownerDocument != null) {
            this.m_ownerDocument.removeIdentifiedElement((DNode)oldChild);
        }
        return childx;
    }

    public Node dsfRemoveChild(DNode oldChild) throws DOMException {
        this.removeChild(oldChild);
        oldChild.dsfDetachFromOwnerDocument();
        return oldChild;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild == null) {
            throw new DOMException(16, "Child is null");
        }
        if (this.getTraceCtx().haveInstrumenter()) {
            this.m_traceCtx.getInstrumenter().runAppendInstrumenters(this, newChild);
        }
        if (newChild instanceof DocumentFragment) {
            DDocumentFragment fragment = (DDocumentFragment)newChild;
            while (fragment.getLength() > 0) {
                DNode node = (DNode)fragment.getDsfChildNodes().get(0);
                this.appendChildNonDocFragment(node);
            }
        } else {
            this.appendChildNonDocFragment(newChild);
        }
        return newChild;
    }

    @Override
    public DNode add(DNode newChild) throws DOMException {
        this.appendChild(newChild);
        return this;
    }

    public DNode add(String value) throws DOMException {
        DText text = new DText(value);
        return this.add(text);
    }

    public DNode addRaw(String value) throws DOMException {
        DRawString raw = new DRawString(value);
        return this.add(raw);
    }

    protected Node appendChildNonDocFragment(Node newChild) throws DOMException {
        this.checkChildForAdd(newChild);
        DNode child = (DNode)newChild;
        this.eraseParent(child, (DNode)newChild.getParentNode());
        ((DNodeList)this.getChildNodes()).privateAdd(child);
        this.postChildAdd(child);
        return newChild;
    }

    @Override
    public boolean hasChildNodes() {
        return this.m_childNodes == null ? false : this.m_childNodes.size() > 0;
    }

    @Override
    public Node cloneNode(boolean deep) {
        try {
            return this.cloneInternal(deep);
        }
        catch (CloneNotSupportedException e) {
            throw new DsfRuntimeException("unable to clone " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void normalize() {
        throw new DsfDomLevelNotSupportedException(3);
    }

    @Override
    public boolean isSupported(String feature, String version) {
        throw new DsfDomNotSupportedRuntimeException("isSupported(feature, version)");
    }

    @Override
    public String getNamespaceURI() {
        return this.m_dsfNamespace != null ? this.m_dsfNamespace.getNamespaceKey() : null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        throw new DOMException(14, "Error in namespace, namespaceURI = null.");
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    public DNamespace getDsfBaseURI() {
        return null;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw new DsfDomLevelNotSupportedException(3);
    }

    @Override
    public String getTextContent() throws DOMException {
        if (!this.hasChildNodes()) {
            return "";
        }
        String answer = "";
        IDNodeList kids = this.getDsfChildNodes();
        int len = kids.getLength();
        int i = 0;
        while (i < len) {
            Node node = kids.item(i);
            if (!(node instanceof DComment) && !(node instanceof DProcessingInstruction)) {
                answer = String.valueOf(answer) + node.getTextContent();
            }
            ++i;
        }
        return answer;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        if (textContent == null) {
            return;
        }
        if (this.m_childNodes != null) {
            this.m_childNodes.clear();
        }
        if (textContent.length() == 0) {
            return;
        }
        this.add(textContent);
    }

    @Override
    public boolean isSameNode(Node other) {
        return this == other;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        DNamespace ns = this.dsfLookupPrefix(namespaceURI);
        return ns == null ? null : ns.getPrefix();
    }

    public DNamespace dsfLookupPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        short type = this.getNodeType();
        switch (type) {
            case 1: {
                this.getNamespaceURI();
                return this.getNamespaceByNamespaceURI(namespaceURI, (DElement)this);
            }
            case 9: {
                DElement rootEle = (DElement)((DDocument)this).getDocumentElement();
                return rootEle != null ? rootEle.dsfLookupPrefix(namespaceURI) : null;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                if (this.m_parentNode.getNodeType() == 1) {
                    return this.m_parentNode.dsfLookupPrefix(namespaceURI);
                }
                return null;
            }
        }
        DNode ancestor = this.getElementAncestor(this);
        if (ancestor != null) {
            return ancestor.dsfLookupPrefix(namespaceURI);
        }
        return null;
    }

    private DNamespace getNamespaceByNamespaceURI(String namespaceURI, DElement el) {
        String foundNamespace;
        if (this.m_dsfNamespace != null && this.m_dsfNamespace.getNamespaceKey().equals(namespaceURI) && this.m_prefix != null && (foundNamespace = el.lookupNamespaceURI(this.m_prefix)) != null && foundNamespace.equals(namespaceURI)) {
            return this.m_dsfNamespace;
        }
        DNode ancestor = this.getElementAncestor(this);
        if (ancestor != null) {
            return ancestor.getNamespaceByNamespaceURI(namespaceURI, el);
        }
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        if (namespaceURI == null) {
            return false;
        }
        DNamespace ns = this.dsfLookupPrefix(namespaceURI);
        return ns == null ? namespaceURI == null : this.isDsfDefaultNamespace(ns);
    }

    public boolean isDsfDefaultNamespace(DNamespace namespace) {
        short type = this.getNodeType();
        switch (type) {
            case 1: {
                return namespace == this.getNamespaceFromAncestor((DElement)this);
            }
            case 9: {
                DElement rootEle = (DElement)((DDocument)this).getDocumentElement();
                return rootEle != null ? rootEle.isDsfDefaultNamespace(namespace) : false;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
            case 2: {
                return false;
            }
        }
        DNode ancestor = this.getElementAncestor(this);
        if (ancestor != null) {
            return ancestor.isDsfDefaultNamespace(namespace);
        }
        return false;
    }

    @Override
    public String lookupNamespaceURI(String specifiedPrefix) {
        DNamespace ns = this.dsfLookupNamespaceURI(specifiedPrefix);
        return ns == null ? null : ns.getNamespaceKey();
    }

    public DNamespace dsfLookupNamespaceURI(String specifiedPrefix) {
        short type = this.getNodeType();
        switch (type) {
            case 1: {
                DNode ancestor;
                String namespace = this.getNamespaceURI();
                if (namespace != null) {
                    if (specifiedPrefix == null && this.m_prefix == specifiedPrefix) {
                        return this.m_dsfNamespace;
                    }
                    if (this.m_prefix != null && this.m_prefix.equals(specifiedPrefix)) {
                        return this.m_dsfNamespace;
                    }
                }
                if ((ancestor = this.getElementAncestor(this)) != null) {
                    return ancestor.dsfLookupNamespaceURI(specifiedPrefix);
                }
                return null;
            }
            case 9: {
                ((DDocument)this).dsfLookupNamespaceURI(specifiedPrefix);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                return null;
            }
        }
        DNode ancestor = this.getElementAncestor(this);
        if (ancestor != null) {
            return ancestor.dsfLookupNamespaceURI(specifiedPrefix);
        }
        return null;
    }

    protected DNamespace getNamespaceFromAncestor(DElement ele) {
        DNode ancestor = this.getElementAncestor(ele);
        DNamespace ns = null;
        while (ancestor != null) {
            ns = ancestor.getDsfNamespace();
            if (ns != null) {
                return ns;
            }
            ancestor = this.getElementAncestor(ancestor);
        }
        if (ele.getOwnerDocument() != null) {
            return ((DDocument)ele.getOwnerDocument()).getDsfDocumentURI();
        }
        return null;
    }

    protected String getDefaultNSURIFromAncestor(DElement ele) {
        DNamespace ns = this.getNamespaceFromAncestor(ele);
        return ns != null ? ns.getNamespaceKey() : null;
    }

    DNode getElementAncestor(DNode currentNode) {
        DNode parent = (DNode)currentNode.getParentNode();
        if (parent != null) {
            short type = parent.getNodeType();
            if (type == 1 || type == 9) {
                return parent;
            }
            return this.getElementAncestor(parent);
        }
        return null;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        if (arg == this) {
            return true;
        }
        if (arg.getNodeType() != this.getNodeType()) {
            return false;
        }
        if (!(this.isEqualString(this.getNodeName(), arg.getNodeName()) && this.isEqualString(this.getLocalName(), arg.getLocalName()) && this.isEqualString(this.getNamespaceURI(), arg.getNamespaceURI()) && this.isEqualString(this.getPrefix(), arg.getPrefix()) && this.isEqualString(this.getNodeValue(), arg.getNodeValue()))) {
            return false;
        }
        return this.isEqualChildrenNodes(arg);
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new DsfDomLevelNotSupportedException(3);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if (this.m_userData == null) {
            this.m_userData = new LinkedHashMap<String, Object>(3);
        }
        return this.m_userData.put(key, data);
    }

    public boolean hasUserData() {
        return this.m_userData == null ? false : this.m_userData.size() > 0;
    }

    @Override
    public Object getUserData(String key) {
        if (this.m_userData == null) {
            return null;
        }
        return this.m_userData.get(key);
    }

    public <T extends DNode> T dsfFindByAttrNameValue(String attrName, String attrValue) {
        FindByAttrNameValueVisitor visitor = new FindByAttrNameValueVisitor(attrName, attrValue);
        DepthFirstDNodeTraversal traversal = new DepthFirstDNodeTraversal();
        visitor.setStrategy(traversal);
        this.dsfAccept(visitor);
        return (T)visitor.getMatch();
    }

    public DNode jif(String jif) {
        Jif.jif(this, jif, true, "Dsf");
        return this;
    }

    public <T extends DNode> T nav(T element) {
        return element;
    }

    public DNode nav(String nav) {
        if ((nav = nav.trim()).startsWith(".")) {
            return this.getKid(nav);
        }
        if (nav.startsWith("<")) {
            return this.getPrev(nav);
        }
        throw new DsfRuntimeException("Unknown nav: " + nav);
    }

    private DNode getPrev(String nav) {
        if ("<".equals(nav)) {
            return this;
        }
        String num = nav.substring(1);
        int moveBy = 0;
        try {
            moveBy = Integer.parseInt(num);
            int len = this.parentChainLength(this);
            if (moveBy > len) {
                throw new DsfRuntimeException("There are less parents (" + len + ") than the nav requested: " + moveBy);
            }
            DNode answer = this;
            int i = 0;
            while (i < moveBy) {
                answer = answer.getDsfParentNode();
                ++i;
            }
            return answer;
        }
        catch (NumberFormatException numberFormatException) {
            throw new DsfRuntimeException("expected nav format: nav# where # is a positive integer");
        }
    }

    private int parentChainLength(Node node) {
        if (node.getParentNode() == null) {
            return 0;
        }
        return 1 + this.parentChainLength(node.getParentNode());
    }

    private DNode getKid(String nav) {
        if (".".equals(nav)) {
            int len = this.getLength();
            if (len == 0) {
                throw new DsfRuntimeException("No child to nav to");
            }
            return (DNode)this.getDsfChildNodes().get(0);
        }
        String num = nav.substring(1);
        int moveBy = 0;
        try {
            moveBy = Integer.parseInt(num);
            int len = this.getLength();
            if (moveBy > len) {
                throw new DsfRuntimeException("There are less children (" + len + ") than the nav requested: " + moveBy);
            }
            return (DNode)this.getDsfChildNodes().get(moveBy - 1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DsfRuntimeException("expected nav format: nav# where # is a positive integer");
        }
    }

    public <T extends DNode> T nav(String nav, Class<T> clz) {
        if ((nav = nav.trim()).startsWith(".")) {
            if (".".equals(nav)) {
                int len = this.getLength();
                int i = 0;
                while (i < len) {
                    Node child = this.getChildNodes().item(i);
                    if (clz.isAssignableFrom(child.getClass())) {
                        return (T)((DNode)child);
                    }
                    ++i;
                }
                throw new DsfRuntimeException("Did find nav for: " + clz.getName());
            }
            String num = nav.substring(1);
            int moveBy = -1;
            try {
                moveBy = Integer.parseInt(num);
                return (T)((DNode)this.getChildNodes().item(moveBy));
            }
            catch (NumberFormatException numberFormatException) {
                throw new DsfRuntimeException("expected nav format: nav# where # is a positive integer");
            }
        }
        if (nav.startsWith("<")) {
            return (T)this.getPrev(nav);
        }
        throw new DsfRuntimeException("Unknown nav: " + nav);
    }

    public String toString() {
        Z z = new Z();
        z.format("node parent", this.m_parentNode == null ? null : this.m_parentNode.getNodeName());
        z.format("node name", (Object)this.m_nodeName);
        z.format("node value", (Object)this.m_nodeValue);
        z.format("node type", (int)this.getNodeType());
        z.format("node id", (Object)this.m_nodeId);
        z.format("node prefix", (Object)this.m_prefix);
        z.format("node dsf name", (Object)this.m_dsfName);
        z.format("node exports local names", this.m_exportingLocalNames);
        z.format("node naming family", (Object)this.m_dsfNamingFamily);
        if (this.m_dsfNamespace != null) {
            z.format("node namespace", (Object)this.m_dsfNamespace.toString());
        }
        if (this.m_facets == null) {
            z.format("node facet names", (Object)"{ }");
        } else {
            z.format("node facet names", this.m_facets.keySet());
        }
        if (this.m_strategies != null) {
            z.format("node phase ids with strategy", this.m_strategies.keySet());
        }
        if (this.m_listeners == null) {
            z.format("node listeners", 0);
        } else {
            z.format("node listeners", this.m_listeners.size());
        }
        z.format("node children", this.getLength());
        return z.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.cloneInternal(true);
    }

    public DNode cloneInternal(boolean deep) throws CloneNotSupportedException {
        DNode copy = this.abstractsClone();
        DsfCtx.ctx().getContainer().checkNodeInstantiation(copy);
        copy.m_ownerDocument = null;
        copy.m_parentNode = null;
        if (copy.m_facets != null) {
            this.cloneFacets(copy);
        }
        if (deep) {
            if (this.m_childNodes != null) {
                copy.m_childNodes = this.createChildNodes(this, this.m_childNodes.size());
                for (DNode kid : this.m_childNodes) {
                    DNode kidCopy = (DNode)kid.clone();
                    copy.add(kidCopy);
                }
            }
        } else {
            copy.m_childNodes = null;
        }
        return copy;
    }

    @Override
    public int getLength() {
        if (this.m_childNodes == null) {
            return 0;
        }
        return this.m_childNodes.size();
    }

    @Override
    public Node item(int index) {
        if (index < 0 || index >= this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.m_childNodes == null) {
            return null;
        }
        return (Node)this.m_childNodes.get(index);
    }

    protected void checkChildForAdd(Node child) {
        if (child == null) {
            throw new DOMException(16, "Child is null");
        }
        Document childsDoc = child.getOwnerDocument();
        if ((this.m_ownerDocument != null || childsDoc == null) && childsDoc != null && childsDoc != this.m_ownerDocument) {
            throw new DOMException(4, "node belongs to a different document");
        }
        DNode dsfChild = (DNode)child;
        boolean verifyRelationship = DsfVerifierConfig.getInstance().isVerifyRelationship();
        if (verifyRelationship) {
            this.checkChildForCyclesAndLimits(dsfChild);
        }
        if (DsfVerifierConfig.getInstance().isVerifyNaming()) {
            NameChecker.assertNamesUnique(this, dsfChild);
            NameChecker.assertChildrenNamesUnique(this, dsfChild);
        }
        if (verifyRelationship) {
            DNode.assertParentChildRelationship(this, dsfChild);
        }
    }

    protected void checkChildForCyclesAndLimits(DNode child) {
        if (child.hasChildNodes()) {
            NodeCounter sz = new NodeCounter();
            sz.countDepth(child);
            int cfr_ignored_0 = sz.m_depth;
            int cfr_ignored_1 = sz.m_nodeCounts;
        }
        DNode ancestor = this;
        while (ancestor != null) {
            if (ancestor == child) {
                throw new DOMException(3, "this node cannot be an ancestor of itself");
            }
            if (ancestor.hasChildNodes()) {
                ancestor.getChildNodes().getLength();
            }
            if (ancestor.hasChildNodes()) {
                // empty if block
            }
            ancestor = ancestor.m_parentNode;
        }
    }

    protected void postChildAdd(DNode nodex) {
        nodex.m_parentNode = this;
        if (nodex.m_ownerDocument == null && this.m_ownerDocument != null) {
            nodex.setDsfOwnerDocument(this.m_ownerDocument);
        } else if ((this.m_ownerDocument != null || nodex.m_ownerDocument == null) && nodex.m_ownerDocument != this.m_ownerDocument) {
            throw new DOMException(4, "node belongs to a different document");
        }
    }

    @Override
    public boolean hasDsfFacets() {
        return this.m_facets == null ? false : this.m_facets.size() > 0;
    }

    @Override
    public IFacetsMap getDsfFacets() {
        if (this.m_facets == null) {
            this.m_facets = this.createFacetsMap(this, 3);
        }
        return this.m_facets;
    }

    private FacetsMap createFacetsMap(DNode owner, int initialSize) {
        return new FacetsMap(owner, initialSize);
    }

    private void cloneFacets(DNode newParent) throws CloneNotSupportedException {
        if (this.m_facets == null) {
            return;
        }
        newParent.m_facets = this.createFacetsMap(newParent, this.m_facets.size());
        for (Map.Entry<String, DNode> entry : this.m_facets.entrySet()) {
            String name = entry.getKey();
            DNode copy = (DNode)entry.getValue().clone();
            newParent.getDsfFacets().put(name, copy);
        }
    }

    @Override
    public DNode dsfDiscard() {
        if (this.m_facets != null) {
            for (DNode facet : this.m_facets.values()) {
                facet.dsfDiscard();
            }
            this.m_facets.clear();
        }
        this.m_facets = null;
        if (this.m_childNodes != null) {
            for (DNode child : this.m_childNodes) {
                child.dsfDiscard();
                child.m_parentNode = null;
            }
            this.m_childNodes.privateClear();
        }
        this.m_childNodes = null;
        return this.abstractsDsfDiscard();
    }

    @Override
    public Object cloned() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DsfRuntimeException(e.getMessage());
        }
    }

    @Override
    public DNode getDsfParentNode() {
        return this.m_parentNode;
    }

    public DNode getDsfParentNode(int back) {
        if (back < 1) {
            throw new DsfRuntimeException("back must be a positive integer");
        }
        DNode answer = this;
        int i = 1;
        while (i <= back) {
            if ((answer = answer.getDsfParentNode()) == null && i < back) {
                throw new DsfRuntimeException("Could not go back " + back + " parents, max would be: " + i);
            }
            ++i;
        }
        return answer;
    }

    public XPathResult dsfXpath(String xpathExpression) {
        return new XPathResult(this, xpathExpression);
    }

    public XPathResult dsfXpath(XPathExpression xpathExpression) {
        return new XPathResult(this, xpathExpression);
    }

    void deparent() {
        this.setParent(null);
    }

    DNode setParent(DNode parent) {
        DNode oldParent;
        if (parent == this) {
            DNode.chuck("Attempted to parent to self.");
        }
        if ((oldParent = this.m_parentNode) != null) {
            this.eraseParent(this, oldParent);
        }
        this.m_parentNode = parent;
        if (this.m_parentNode == null) {
            return oldParent;
        }
        DNode component = this.m_parentNode.getDsfParentNode();
        while (component != null) {
            if (component == this.m_parentNode) {
                this.m_parentNode = null;
                DNode.chuck("Circular parent/child relationship formed.");
            }
            component = component.getDsfParentNode();
        }
        return oldParent;
    }

    private void eraseParent(DNode child, DNode parent) {
        if (parent == null) {
            return;
        }
        parent.getDsfChildNodes().remove(child);
        if (!parent.hasDsfFacets()) {
            return;
        }
        IFacetsMap facets = parent.getDsfFacets();
        Iterator entries = facets.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (entry.getValue() != child) continue;
            entries.remove();
            return;
        }
    }

    public boolean hasDsfChildWithLocalName(String localName) {
        if (localName == null) {
            return false;
        }
        if (this.m_childNodes == null) {
            return false;
        }
        for (DNode kid : this.m_childNodes) {
            String kidsLocalName;
            if (!kid.hasDsfName() || (kidsLocalName = kid.getDsfName().getLocalName()) == null || !kidsLocalName.equals(localName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IAttributeMap getDsfAttributes() {
        return null;
    }

    @Override
    public IDNodeList getDsfChildNodes() {
        this.getChildNodes();
        return this.m_childNodes;
    }

    public IDNodeList getDsfChildNodes(int initialSize) {
        this.getChildNodes(initialSize);
        return this.m_childNodes;
    }

    void setDsfOwnerDocument(DDocument doc) {
        if (this.m_ownerDocument == doc) {
            return;
        }
        if (this.m_ownerDocument != null) {
            this.m_ownerDocument.removeIdentifiedElement(this);
        }
        this.m_ownerDocument = doc;
        if (this.m_childNodes != null) {
            int len = this.m_childNodes.getLength();
            int i = 0;
            while (i < len) {
                this.m_childNodes.item(i).setDsfOwnerDocument(doc);
                ++i;
            }
        }
    }

    public void dsfDetachFromOwnerDocument() {
        if (this.m_parentNode != null) {
            throw new RuntimeException("This node still has a parent");
        }
        this.setDsfOwnerDocument(null);
    }

    @Override
    public DNodeId getNodeId() {
        if (this.m_nodeId == null) {
            this.m_nodeId = new DNodeId();
        }
        return this.m_nodeId;
    }

    protected void setNodeId(DNodeId id) {
        this.m_nodeId = id;
    }

    private DNode abstractsClone() throws CloneNotSupportedException {
        DNode copy = (DNode)super.clone();
        copy.m_dsfName = null;
        copy.m_listeners = null;
        IDsfName copiesDsfName = copy.getDsfName();
        if (copiesDsfName.getLocalName() != null) {
            copiesDsfName.setLocalName(this.m_dsfName.getLocalName());
        }
        if (copiesDsfName.getScopeName() != null) {
            copiesDsfName.setScopeName(this.m_dsfName.getScopeName());
        }
        if (this.m_dsfRelationshipVerifier != null) {
            copy.m_dsfRelationshipVerifier = (IDNodeRelationshipVerifier)this.m_dsfRelationshipVerifier.clone();
        }
        this.cloneStrategies(copy);
        copy.m_propertyDescriptors = this.m_propertyDescriptors;
        copy.m_valueBindingMap = this.m_valueBindingMap;
        return copy;
    }

    protected void cloneStrategies(DNode copy) throws CloneNotSupportedException {
        if (this.m_strategies == null) {
            return;
        }
        copy.m_strategies = new DsfStrategies(2);
        if (this.m_strategies.size() <= 0) {
            return;
        }
        for (Map.Entry entry : this.m_strategies.entrySet()) {
            PhaseId phaseId = (PhaseId)((Object)entry.getKey());
            IDNodeHandlingStrategy strategy = (IDNodeHandlingStrategy)((IDNodeHandlingStrategy)entry.getValue()).clone();
            copy.getDsfStrategies().put(phaseId, strategy);
        }
    }

    private DNode abstractsDsfDiscard() {
        if (this.m_strategies != null) {
            this.m_strategies.clear();
        }
        if (this.m_listeners != null) {
            this.m_listeners.clear();
        }
        this.m_facets = null;
        this.m_strategies = null;
        this.m_listeners = null;
        this.m_dsfName = null;
        this.m_dsfRelationshipVerifier = null;
        this.m_propertyDescriptors = null;
        this.m_valueBindingMap = null;
        return this;
    }

    public DNode dsfBroadcast(DsfEvent event) throws AbortDsfEventProcessingException {
        if (event == null) {
            DNode.chuck("ComponentEvent must not be null");
        }
        if (this.m_listeners == null) {
            return this;
        }
        for (IDsfEventListener listener : this.m_listeners) {
            if (!event.isAppropriateListener(listener)) continue;
            event.dispatch(listener);
        }
        return this;
    }

    public DNode dsfBroadcast(DsfEvent event, IDsfEventStrategy strategy) throws AbortDsfEventProcessingException {
        if (event == null) {
            DNode.chuck("ComponentEvent must not be null");
        }
        if (strategy == null) {
            DNode.chuck("Broadcast event strategy must not be null");
        }
        strategy.handle(this, (DsfEvent<DNode, IDsfEventListener>)event);
        return this;
    }

    @Override
    public boolean hasDsfStrategies() {
        if (this.m_strategies == null) {
            return false;
        }
        return this.m_strategies.size() > 0;
    }

    @Override
    public IDsfStrategies getDsfStrategies() {
        if (this.m_strategies == null) {
            this.m_strategies = new DsfStrategies(2);
        }
        return this.m_strategies;
    }

    @Override
    public IDsfName getDsfName() {
        if (this.m_dsfName == null) {
            this.m_dsfName = new DNodeName(this);
        }
        return this.m_dsfName;
    }

    @Override
    public boolean hasDsfName() {
        return this.m_dsfName != null;
    }

    @Override
    public boolean isDsfExportingLocalNames() {
        return this.m_exportingLocalNames;
    }

    @Override
    public DNode setDsfExportingLocalNames(boolean shouldExport) {
        if (!this.m_exportingLocalNames && shouldExport) {
            NameChecker.assertChildrenNamesUnique(this, this);
        }
        this.m_exportingLocalNames = shouldExport;
        return this;
    }

    @Override
    public IDsfNamingFamily getDsfNamingFamily() {
        if (this.m_dsfNamingFamily == null) {
            this.m_dsfNamingFamily = DsfCtx.ctx().getContainer().getDsfNamingFamily();
        }
        return this.m_dsfNamingFamily;
    }

    @Override
    public DNode setDsfNamingFamily(IDsfNamingFamily namingFamily) {
        this.m_dsfNamingFamily = namingFamily;
        return this;
    }

    @Override
    public DNode setDsfRelationshipVerifier(IDNodeRelationshipVerifier relationshipVerifier) {
        this.m_dsfRelationshipVerifier = relationshipVerifier;
        return this;
    }

    @Override
    public IDNodeRelationshipVerifier getDsfRelationshipVerifier() {
        if (this.m_dsfRelationshipVerifier == null) {
            this.m_dsfRelationshipVerifier = DsfCtx.ctx().getContainer().getNodeRelationshipVerifier();
        }
        return this.m_dsfRelationshipVerifier;
    }

    protected IDNodeHandlingStrategy getStrategy(IDNodeVisitor visitor, IStage<PhaseId> phase) {
        if (visitor == null) {
            DNode.chuck("null visitor not allowed");
        }
        IDNodeHandlingStrategy strategy = null;
        if (this.hasDsfStrategies()) {
            if (phase != null) {
                strategy = (IDNodeHandlingStrategy)this.getDsfStrategies().get(phase.getId());
            }
            if (strategy == null) {
                strategy = (IDNodeHandlingStrategy)this.getDsfStrategies().get((Object)PhaseId.ANY_PHASE);
            }
        }
        if (strategy == null) {
            strategy = visitor.getStrategy();
        }
        if (strategy == null) {
            strategy = DefaultDNodeHandlingStrategy.getInstance();
        }
        return strategy;
    }

    @Override
    public IDsfEventListeners getDsfEventListeners() {
        if (this.m_listeners == null) {
            this.m_listeners = new DsfEventListeners(2);
        }
        return this.m_listeners;
    }

    @Override
    public boolean hasDsfListeners() {
        return this.m_listeners == null ? false : this.m_listeners.size() > 0;
    }

    @Override
    public DNode dsfAccept(IDNodeVisitor visitor) {
        PhaseDriver cycle = DsfCtx.ctx().getPhaseDriver();
        if (cycle != null) {
            this.getStrategy(visitor, (IStage<PhaseId>)cycle.getManager().getCurrent()).handle(this, visitor);
        } else {
            this.getStrategy(visitor, null).handle(this, visitor);
        }
        return this;
    }

    protected static void chuck(String message) {
        throw new DsfRuntimeException(message);
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        PropertyDescriptorMap pds = this.getPropertyDescriptors();
        return (PropertyDescriptor)pds.get(propertyName);
    }

    private DNodeList createChildNodes() {
        return this.createChildNodes(this, 3);
    }

    private DNodeList createChildNodes(DNode me, int initialSize) {
        return new DNodeList(me, initialSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyDescriptorMap getPropertyDescriptors() {
        if (this.m_propertyDescriptors != null) {
            return this.m_propertyDescriptors;
        }
        WeakHashMap<Class<?>, PropertyDescriptorMap> weakHashMap = s_descriptors;
        synchronized (weakHashMap) {
            if (this.m_propertyDescriptors != null) {
                return this.m_propertyDescriptors;
            }
            PropertyDescriptorMap map = s_descriptors.get(this.getClass());
            if (map == null) {
                Class<?> type = this.getClass();
                try {
                    PropertyDescriptor[] pds = Introspector.getBeanInfo(type, Object.class).getPropertyDescriptors();
                    map = new PropertyDescriptorMap();
                    PropertyDescriptor[] propertyDescriptorArray = pds;
                    int n = pds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PropertyDescriptor pd = propertyDescriptorArray[n2];
                        if (!this.ignoreAsNativeProperty(pd)) {
                            map.put(pd.getName(), pd);
                        }
                        ++n2;
                    }
                }
                catch (IntrospectionException e) {
                    DNode.chuck(e.getMessage());
                }
                s_descriptors.put(this.getClass(), map);
            }
            this.m_propertyDescriptors = map;
            return map;
        }
    }

    private boolean ignoreAsNativeProperty(PropertyDescriptor pd) {
        IgnoreAsNativeProperty ignoreWrite;
        IgnoreAsNativeProperty ignoreRead;
        Method readMethod = pd.getReadMethod();
        if (readMethod != null && (ignoreRead = readMethod.getAnnotation(IgnoreAsNativeProperty.class)) != null) {
            return true;
        }
        Method writeMethod = pd.getWriteMethod();
        return writeMethod != null && (ignoreWrite = writeMethod.getAnnotation(IgnoreAsNativeProperty.class)) != null;
    }

    public IValueBinding<?> getIntrinsicPropertyValueBinding(String propertyName) {
        Map<String, Field> fields = this.getIntrinsicValueBindingFields();
        Field field = fields.get(propertyName.toLowerCase());
        if (field == null) {
            return null;
        }
        try {
            SimpleValueBinding<Object> binding = (SimpleValueBinding<Object>)field.get(this);
            if (binding == null) {
                binding = new SimpleValueBinding<Object>(Object.class);
                field.set(this, binding);
            }
            return binding;
        }
        catch (Exception e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    public DNode setDsfIntrinsicPropertyValueBinding(String propertyName, IValueBinding<?> binding) {
        Map<String, Field> fields = this.getIntrinsicValueBindingFields();
        Field field = fields.get(propertyName.toLowerCase());
        if (field == null) {
            DNode.chuck("The intrinsic property " + propertyName + " is not bindable.");
        }
        try {
            field.set(this, binding);
        }
        catch (Exception e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Field> getIntrinsicValueBindingFields() {
        if (this.m_valueBindingMap != null) {
            return this.m_valueBindingMap;
        }
        WeakHashMap<Class<?>, Map<String, Field>> weakHashMap = s_valueBindings;
        synchronized (weakHashMap) {
            Map<String, Field> valueBindingsPerClz = s_valueBindings.get(this.getClass());
            if (valueBindingsPerClz == null) {
                valueBindingsPerClz = new HashMap<String, Field>();
                try {
                    Class<?> clz = this.getClass();
                    while (clz != null && clz != DNode.class) {
                        this.collectValueBindingFields(clz, valueBindingsPerClz);
                        clz = clz.getSuperclass();
                    }
                }
                catch (Exception e) {
                    DNode.chuck(e.getMessage());
                }
                s_valueBindings.put(this.getClass(), valueBindingsPerClz);
            }
            this.m_valueBindingMap = valueBindingsPerClz;
            return valueBindingsPerClz;
        }
    }

    private void collectValueBindingFields(Class<?> theClz, Map<String, Field> valueBindingsPerClz) {
        Field[] fields = theClz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            field.setAccessible(true);
            if (IValueBinding.class.isAssignableFrom(field.getType())) {
                String propertyName = field.getName();
                if (propertyName.startsWith("m_")) {
                    propertyName = propertyName.substring(2);
                }
                valueBindingsPerClz.put(propertyName.toLowerCase(), field);
            }
            ++i;
        }
    }

    protected static void assertParentChildRelationship(DNode parent, DNode child) {
        IDNodeRelationshipVerifier.Status status = parent.getDsfRelationshipVerifier().acceptableAsChild(parent, child);
        DNode.assertRelationship(status);
        status = child.getDsfRelationshipVerifier().acceptableAsParent(child, parent);
        DNode.assertRelationship(status);
    }

    void assertAttributeRelationship(DNode parent, String attributeName, Object attribute) {
        if (!DsfVerifierConfig.getInstance().isVerifyRelationship()) {
            return;
        }
        DNode parentNode = parent;
        IDNodeRelationshipVerifier.Status status = parentNode.getDsfRelationshipVerifier().acceptableAsAttribute(parentNode, attributeName, attribute);
        DNode.assertRelationship(status);
    }

    private TraceCtx getTraceCtx() {
        if (this.m_traceCtx == null) {
            this.m_traceCtx = TraceCtx.ctx();
        }
        return this.m_traceCtx;
    }

    protected static void assertRelationship(IDNodeRelationshipVerifier.Status status) {
        if (!status.isOk()) {
            throw new DOMException(3, status.getErrorMessage());
        }
    }

    public Object readResolve() {
        DsfCtx.ctx().getContainer().checkNodeInstantiation(this);
        return this;
    }

    protected boolean isEqualString(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    protected boolean isEqualChildrenNodes(Node node) {
        Node child1 = this.getFirstChild();
        Node child2 = node.getFirstChild();
        while (child1 != null && child2 != null) {
            if (!child1.isEqualNode(child2)) {
                return false;
            }
            child1 = child1.getNextSibling();
            child2 = child2.getNextSibling();
        }
        if (child1 != child2) {
            return false;
        }
        return this.isEqualAttrs(node);
    }

    protected boolean isEqualAttrs(Node node) {
        return true;
    }

    public void callUserDataHandlers(Node n, Node c, short operation) {
        if (this.m_userData == null || this.m_userData.isEmpty()) {
            return;
        }
    }

    public DNamespace getDsfNamespace() {
        return null;
    }

    public DNode setDsfNamespace(DNamespace namespace) {
        Class<?> clz = this.getClass();
        String msg = DDocument.class.isAssignableFrom(clz) ? "Use getDsfNamespaceDeclarations() to manage document namespaces" : String.valueOf(clz.getSimpleName()) + " doesn't allow adding a namespace";
        throw new DOMException(9, msg);
    }

    DNode getRootElement() {
        DNode rootN = this;
        while (rootN != null && rootN.getNodeType() == 1 && rootN.m_parentNode != null && rootN.m_parentNode.getNodeType() == 1) {
            rootN = rootN.m_parentNode;
        }
        return rootN;
    }

    protected boolean isDsfXml11Version() {
        return this.m_ownerDocument != null ? this.m_ownerDocument.isDsfXml11Version() : false;
    }

    private static class FindByAttrNameValueVisitor
    extends DefaultDNodeVisitor {
        private DNode m_nodeMatch = null;
        private String m_attrName;
        private String m_attrValue;

        FindByAttrNameValueVisitor(String attrName, String attrValue) {
            this.m_attrName = attrName;
            this.m_attrValue = attrValue;
        }

        @Override
        public DNodeVisitStatus visit(DNode node) throws AbortDNodeTraversalException {
            if (node.hasAttributes()) {
                DAttr attr = node.getDsfAttributes().getAttr(this.m_attrName);
                if (attr != null && attr.getValue().equals(this.m_attrValue)) {
                    this.m_nodeMatch = node;
                }
                return DNodeVisitStatus.STOP_SUBTREE_TRAVERSAL;
            }
            return DNodeVisitStatus.CONTINUE;
        }

        public DNode getMatch() {
            return this.m_nodeMatch;
        }
    }

    private static class NodeCounter {
        int m_nodeCounts;
        int m_depth;

        private NodeCounter() {
        }

        void countDepth(Node node) {
            if (!node.hasChildNodes()) {
                return;
            }
            ++this.m_depth;
            this.m_nodeCounts += node.getChildNodes().getLength();
            int i = 0;
            while (i < node.getChildNodes().getLength()) {
                this.countDepth(node.getChildNodes().item(i));
                ++i;
            }
        }
    }

    private static class PropertyDescriptorMap
    extends HashMap<String, PropertyDescriptor> {
        private static final long serialVersionUID = 1L;

        private PropertyDescriptorMap() {
        }
    }
}

