/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom.util;

import java.util.Set;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.eclipse.vjet.dsf.dom.util.BaseDomWriter;
import org.eclipse.vjet.dsf.dom.util.DomWriterCtx;
import org.eclipse.vjet.dsf.dom.util.ILineLocateIndenter;
import org.eclipse.vjet.dsf.html.HtmlWriterCtx;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.util.IHtmlStreamWriter;
import org.eclipse.vjet.dsf.html.schemas.IContentModel;
import org.eclipse.vjet.dsf.html.schemas.IElementInfo;
import org.eclipse.vjet.dsf.html.schemas.ISchema;

public class HtmlWriter
extends BaseDomWriter {
    private final IHtmlStreamWriter m_writer;
    private ISchema m_schema;
    private final HtmlWriterCtx m_writerCtx;

    public HtmlWriter(IHtmlStreamWriter writer) {
        this(writer, new HtmlWriterCtx());
    }

    public HtmlWriter(ISchema schema, IHtmlStreamWriter writer) {
        this(writer, new HtmlWriterCtx(schema));
    }

    public HtmlWriter(IHtmlStreamWriter writer, HtmlWriterCtx ctx) {
        super((IXmlStreamWriter)writer, (DomWriterCtx)ctx);
        this.m_writer = writer;
        this.m_schema = ctx.getSchema();
        this.m_writerCtx = ctx;
        this.m_lineLocator = ctx.getIndenter() instanceof ILineLocateIndenter ? (ILineLocateIndenter)ctx.getIndenter() : null;
        if (ctx.isAddLineNumber() && this.m_lineLocator == null) {
            throw new DsfRuntimeException("lineLocation is null.");
        }
    }

    public HtmlWriter setSchema(ISchema schema) {
        this.m_schema = schema;
        return this;
    }

    public ISchema getSchema() {
        return this.m_schema;
    }

    public void startElement(DElement element) {
        this.addLine((DNode)element, true, false);
        String tagName = this.m_writerCtx.isRenderNS() ? element.getTagName() : (element instanceof BaseHtmlElement ? ((BaseHtmlElement)element).htmlType().getName() : element.getTagName());
        this.m_writer.writeStartElement(tagName);
        if (element.getOwnerDocument() != null && element.getOwnerDocument().getDocumentElement() == element) {
            if (element.getOwnerDocument().getBaseURI() != null) {
                this.m_writer.writeAttribute("xmlns:base", element.getOwnerDocument().getBaseURI());
            }
            Set nsDecls = ((DDocument)element.getOwnerDocument()).getDsfNamespaceDeclarations();
            for (DNamespace nsObj : nsDecls) {
                this.writeNSAttr(nsObj.getPrefix(), nsObj.getNamespaceKey());
            }
        }
        this.writeAttributes(element);
    }

    public void endElement(DElement element) {
        IElementInfo elementInfo = this.getElementInfo(element);
        if (this.shouldEndTag(elementInfo)) {
            this.addLine((DNode)element, false, true);
            try {
                this.m_writer.writeEndElement();
            }
            catch (Exception e) {
                throw new DsfRuntimeException("error writing end tag for '" + element.getTagName() + "'", (Throwable)e);
            }
        } else {
            this.addLine((DNode)element, false, false);
            this.m_writer.ignoreCurrentEndTag();
        }
    }

    public IElementInfo getElementInfo(DElement element) {
        if (this.m_schema == null) {
            return null;
        }
        if (element instanceof BaseHtmlElement) {
            return this.m_schema.getElementInfo(((BaseHtmlElement)element).htmlType());
        }
        return null;
    }

    private boolean shouldEndTag(IElementInfo elementInfo) {
        return elementInfo == null || elementInfo.requireEndTag() || elementInfo.getContentModel() != IContentModel.EMPTY;
    }
}

