/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.spec.collector;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.vjet.dsf.spec.resource.IResourceSpec;
import org.eclipse.vjet.dsf.spec.resource.IResourceSpecs;

public class ResourceSpecCollector
implements IResourceSpecs<IResourceSpec> {
    private final Set<IResourceSpec> m_componentSpecs = new LinkedHashSet<IResourceSpec>();
    private final Set<IResourceSpec> m_dupSpecExclusionSet = new LinkedHashSet<IResourceSpec>();
    private final ResourceSpecVisitor m_visitor = new ResourceSpecVisitor(){

        @Override
        public void visit(IResourceSpec resourceSpec) {
            ResourceSpecCollector.this.m_componentSpecs.add(resourceSpec);
        }
    };

    @Override
    public Iterator<IResourceSpec> iterator() {
        return this.m_componentSpecs.iterator();
    }

    @Override
    public int size() {
        return this.m_componentSpecs.size();
    }

    public void aggregate(IResourceSpec resourceSpec) {
        this.depthFirstTraversal(resourceSpec, this.m_visitor);
    }

    public void aggregate(IResourceSpecs<? extends IResourceSpec> resourceSpecs) {
        this.depthFirstTraversal(resourceSpecs, this.m_visitor);
    }

    public void depthFirstTraversal(IResourceSpec resourceSpec, ResourceSpecVisitor visitor) {
        if (this.m_dupSpecExclusionSet.contains(resourceSpec)) {
            return;
        }
        this.m_dupSpecExclusionSet.add(resourceSpec);
        this.depthFirstTraversal(resourceSpec.getDependentSpecs(), visitor);
        visitor.visit(resourceSpec);
    }

    public void depthFirstTraversal(IResourceSpecs<? extends IResourceSpec> resourceSpecs, ResourceSpecVisitor visitor) {
        for (IResourceSpec iResourceSpec : resourceSpecs) {
            this.depthFirstTraversal(iResourceSpec, visitor);
        }
    }

    public static interface ResourceSpecVisitor {
        public void visit(IResourceSpec var1);
    }
}

