/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import java.beans.IntrospectionException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.Logger;
import org.eclipse.vjet.dsf.serializer.AVjoSerializable;
import org.eclipse.vjet.dsf.serializer.AVjoUnSerializable;
import org.eclipse.vjet.dsf.serializer.VjoAbstractSerializer;
import org.eclipse.vjet.dsf.serializer.VjoSerializationCtx;
import org.eclipse.vjet.dsf.serializer.VjoSerializedCache;
import org.eclipse.vjet.dsf.serializer.VjoSerializedResult;
import org.eclipse.vjet.dsf.serializers.ISerializableForVjo;

public class VjoSerializableSerializer
extends VjoAbstractSerializer {
    private static Logger s_logger = Logger.getInstance(VjoSerializableSerializer.class);

    @Override
    public boolean canSerialize(Object obj) {
        Class<?> type = obj.getClass();
        return ISerializableForVjo.class.isAssignableFrom(type) || type.getAnnotation(AVjoSerializable.class) != null;
    }

    private Method lookUpMethod(Class<?> clz, String methName) {
        if (clz == null || Object.class.equals(clz)) {
            return null;
        }
        try {
            Method toReturn = clz.getMethod(methName, new Class[0]);
            if (toReturn != null) {
                toReturn.setAccessible(true);
                return toReturn;
            }
        }
        catch (SecurityException e) {
            s_logger.log(LogLevel.WARN, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            s_logger.log(LogLevel.WARN, (Throwable)e);
        }
        return this.lookUpMethod(clz.getSuperclass(), methName);
    }

    private boolean isInvalid(String id) {
        return id == null || id.length() <= 0;
    }

    private String normalizeTypeName(Class<?> type) {
        if (type.isMemberClass() || type.isLocalClass()) {
            return type.getName().replace('$', '.');
        }
        return type.getName();
    }

    @Override
    public Object doSerialize(Object obj) throws SerializationException {
        Class<?> type = obj.getClass();
        VjoSerializedResult vjo = new VjoSerializedResult();
        AVjoSerializable anno = type.getAnnotation(AVjoSerializable.class);
        String vjoId = null;
        String vjoType = null;
        if (anno != null) {
            String vjoIdGetter = anno.vjoIdGetter();
            if (vjoIdGetter.length() > 0) {
                try {
                    Method meth = this.lookUpMethod(type, vjoIdGetter);
                    if (meth != null) {
                        vjoId = String.valueOf(meth.invoke(obj, new Object[0]));
                    }
                }
                catch (SecurityException e) {
                    s_logger.log((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    s_logger.log((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    s_logger.log((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    s_logger.log((Throwable)e);
                }
            }
            vjoType = anno.vjoType();
        }
        if (this.isInvalid(vjoId)) {
            vjoId = DsfCtx.ctx().ids().nextHtmlId();
        }
        if (this.isInvalid(vjoType)) {
            vjoType = this.normalizeTypeName(type);
        }
        vjo.setVjoId(vjoId).setVjoType(vjoType);
        try {
            this.objectStateTransfer(obj, obj.getClass(), vjo);
        }
        catch (IntrospectionException e) {
            s_logger.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            s_logger.log((Throwable)e);
        }
        catch (IllegalAccessException e) {
            s_logger.log((Throwable)e);
        }
        catch (InvocationTargetException e) {
            s_logger.log((Throwable)e);
        }
        return vjo;
    }

    public void objectStateTransfer(Object obj, Class<?> clz, VjoSerializedResult vjo) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SerializationException {
        this.objectStateTransfer(obj, clz, vjo, new HashSet<String>());
    }

    private void objectStateTransfer(Object obj, Class<?> clz, VjoSerializedResult vjo, Set<String> fieldsSet) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SerializationException {
        if (clz == null) {
            return;
        }
        if (clz.getAnnotation(AVjoUnSerializable.class) != null || Object.class.equals(clz)) {
            if (clz.getAnnotation(AVjoSerializable.class) != null) {
                throw new SerializationException("class can't be both AVjoSerializable and AVjoUnSerializable");
            }
            return;
        }
        Field[] fields = clz.getDeclaredFields();
        if (fields != null && fields.length > 0) {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (!Modifier.isStatic(f.getModifiers()) && !fieldsSet.contains(f.getName())) {
                    fieldsSet.add(f.getName());
                    this.propertyStateTransfer(obj, vjo, f);
                }
                ++n2;
            }
        }
        Class<?> superClz = clz.getSuperclass();
        this.objectStateTransfer(obj, superClz, vjo, fieldsSet);
    }

    private void propertyStateTransfer(Object obj, VjoSerializedResult vjo, Field property) throws IllegalAccessException, SerializationException {
        property.setAccessible(true);
        String propertyName = property.getName();
        Object result = property.get(obj);
        if (VjoSerializationCtx.ctx().inStack(result)) {
            VjoSerializationCtx.ctx().addBrokenReference(result, obj, propertyName);
            vjo.put(propertyName, JsonObject.NULL);
        } else {
            vjo.put(propertyName, this.getOwner().serialize(result));
        }
    }

    @Override
    protected Object toCache(Object toSerialize, Object result) {
        if (VjoSerializedResult.class.isAssignableFrom(result.getClass())) {
            VjoSerializedCache cache = new VjoSerializedCache().setCacheId(((VjoSerializedResult)((Object)result)).getVjoId());
            return cache;
        }
        return result;
    }

    @Override
    protected boolean canCache(Object toSerialize) {
        return true;
    }

    @Override
    protected Object restoreBrokenReference(Object toSerialize, Object result) {
        if (VjoSerializationCtx.ctx().hasBrokenReference(toSerialize) && VjoSerializedResult.class.isAssignableFrom(result.getClass())) {
            for (Map.Entry<Object, String> entry : VjoSerializationCtx.ctx().getBrokenReference(toSerialize).entrySet()) {
                Object broken = entry.getKey();
                VjoSerializedCache brokenCache = (VjoSerializedCache)((Object)VjoSerializationCtx.ctx().getCached(broken));
                String propertyName = entry.getValue();
                if (brokenCache != null) {
                    ((VjoSerializedResult)((Object)result)).addBrokenReference(brokenCache, propertyName);
                    continue;
                }
                s_logger.log(LogLevel.ERROR, "broken reference couldn't be restored as the broken residence hasn't bee cached! [broken: " + broken.toString() + "]");
            }
        }
        return result;
    }
}

