/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.serializer.VjoAbstractSerializer;

public class VjoPrimitiveSerializer
extends VjoAbstractSerializer {
    protected static final List<Class<?>> s_primitiveTypes = new ArrayList(10);

    static {
        s_primitiveTypes.add(Byte.class);
        s_primitiveTypes.add(Character.class);
        s_primitiveTypes.add(String.class);
        s_primitiveTypes.add(Boolean.class);
        s_primitiveTypes.add(Short.class);
        s_primitiveTypes.add(Integer.class);
        s_primitiveTypes.add(Long.class);
        s_primitiveTypes.add(Float.class);
        s_primitiveTypes.add(Double.class);
    }

    @Override
    public boolean canSerialize(Object obj) {
        Class<?> type = obj.getClass();
        return this.isPrimitive(type);
    }

    @Override
    public Object doSerialize(Object obj) throws SerializationException {
        String val;
        Class<?> type = obj.getClass();
        String string = val = type == String.class ? (String)obj : obj.toString();
        if (Character.TYPE.isAssignableFrom(type) || Character.class.isAssignableFrom(type)) {
            return val.substring(0, 1);
        }
        if (type == byte[].class) {
            try {
                return val.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SerializationException("UnsupportedEncodingException");
            }
        }
        return obj;
    }

    protected boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || s_primitiveTypes.contains(type);
    }

    @Override
    protected Object toCache(Object toSerialize, Object result) {
        return result;
    }

    @Override
    protected boolean canCache(Object toSerialize) {
        return false;
    }

    @Override
    protected Object restoreBrokenReference(Object toSerialize, Object result) {
        return result;
    }
}

