/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.serializer.VjoSerializationCtx;
import org.eclipse.vjet.dsf.serializers.IVjoSerializer;

public abstract class VjoAbstractSerializer
implements IVjoSerializer {
    private IVjoSerializer m_owner;

    protected IVjoSerializer getOwner() {
        return this.m_owner;
    }

    protected void setOwner(IVjoSerializer owner) {
        this.m_owner = owner;
    }

    public boolean canSerialize(Object toSerialize) {
        return false;
    }

    public Object serialize(Object toSerialize) throws SerializationException {
        if (toSerialize == null) {
            return JsonObject.NULL;
        }
        VjoSerializationCtx ctx = VjoSerializationCtx.ctx();
        Object result = ctx.getCached(toSerialize);
        if (result == null && this.canSerialize(toSerialize)) {
            this.preSerialize(toSerialize);
            result = this.doSerialize(toSerialize);
            if (this.canCache(toSerialize)) {
                Object toCache = this.toCache(toSerialize, result);
                ctx.cache(toSerialize, toCache);
            }
            result = this.restoreBrokenReference(toSerialize, result);
            this.postSerialize(toSerialize);
        }
        return result;
    }

    protected void preSerialize(Object toSerialize) {
        VjoSerializationCtx.ctx().push(toSerialize);
    }

    protected void postSerialize(Object toSerialize) {
        VjoSerializationCtx.ctx().pop(toSerialize);
    }

    protected abstract Object restoreBrokenReference(Object var1, Object var2);

    protected abstract Object doSerialize(Object var1) throws SerializationException;

    protected abstract boolean canCache(Object var1);

    protected abstract Object toCache(Object var1, Object var2);
}

