/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.converter.registry;

import java.util.HashMap;
import java.util.List;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.converter.IConverter;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;

public abstract class BaseConverterRegistry {
    private boolean m_failOnOverride = false;
    private boolean m_failOnNotFound = false;
    private boolean m_sealed = false;
    private ConverterMapMgr m_mappings = new ConverterMapMgr(10);

    protected BaseConverterRegistry(boolean failOnOverride, boolean failOnNotFound) {
        this.m_failOnOverride = failOnOverride;
        this.m_failOnNotFound = failOnNotFound;
    }

    public boolean willFailOnOverride() {
        return this.m_failOnOverride;
    }

    public boolean willFailOnNotFound() {
        return this.m_failOnNotFound;
    }

    public boolean isSealed() {
        return this.m_sealed;
    }

    public <T> void put(IConverter<T> converter) {
        Class<?> converterClass = converter.getClass();
        Class<T> toType = converter.getTargetType();
        List<Class> fromTypes = converter.getValidConversionTypes();
        for (Class fromType : fromTypes) {
            if (this.get(fromType, toType) != null) {
                this.chuck("Stomping existing " + fromType + " to " + toType + " mapping");
            }
            this.put(fromType, toType, converterClass);
        }
    }

    public <T> void put(Class<?> from, Class<T> to, Class<? extends IConverter<T>> converterClass) {
        ConverterMap toMap;
        if (this.m_sealed) {
            this.chuck("This registry is sealed and no changes are allowed");
        }
        if (from == null || to == null || converterClass == null) {
            this.chuck("From type, to type and converter must not be null.");
        }
        if ((toMap = (ConverterMap)this.m_mappings.get(from)) == null) {
            toMap = new ConverterMap(3);
            this.m_mappings.put(from, toMap);
        }
        if (this.m_failOnOverride && toMap.containsKey(to)) {
            this.chuck("Stomping existing from value type: " + from + " to value type: " + to);
        }
        toMap.put(to, converterClass);
    }

    public <T> IConverter<T> get(Class<?> from, Class<T> to) {
        ConverterMap toMap = (ConverterMap)this.m_mappings.get(from);
        if (toMap == null) {
            if (this.m_failOnNotFound) {
                this.chuck("No mapping found for: " + from);
            }
            return null;
        }
        Class converterClass = (Class)toMap.get(to);
        if (converterClass == null) {
            if (this.m_failOnNotFound) {
                this.chuck("No mapping found from value type: " + from + " to value type: " + to);
            }
            return null;
        }
        try {
            return (IConverter)converterClass.newInstance();
        }
        catch (Exception exception) {
            throw new DsfRuntimeException("Unable to create an IConverter instance from class: " + converterClass);
        }
    }

    public String toString() {
        Z z = new Z();
        z.format("sealed", this.m_sealed);
        z.format("willFailOnOverride", this.m_failOnOverride);
        z.format("willFailOnNotFound", this.m_failOnNotFound);
        return String.valueOf(z.toString()) + this.m_mappings;
    }

    protected void setSealed(boolean sealed) {
        this.m_sealed = sealed;
    }

    protected ConverterMapMgr getMappingClone() {
        ConverterMapMgr answer = new ConverterMapMgr(this.m_mappings.size());
        for (Class key : this.m_mappings.keySet()) {
            answer.put(key, (ConverterMap)((ConverterMap)this.m_mappings.get(key)).clone());
        }
        return answer;
    }

    protected void setMapping(ConverterMapMgr map) {
        this.m_mappings = map;
    }

    private void chuck(String message) {
        throw new DsfRuntimeException(message);
    }

    private static class ConverterMap
    extends HashMap<Class<?>, Class<? extends IConverter<?>>> {
        private static final long serialVersionUID = 1L;

        ConverterMap() {
        }

        ConverterMap(int initSize) {
            super(initSize);
        }
    }

    private static class ConverterMapMgr
    extends HashMap<Class<?>, ConverterMap> {
        private static final long serialVersionUID = 1L;

        ConverterMapMgr() {
        }

        ConverterMapMgr(int initSize) {
            super(initSize);
        }
    }
}

