/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.converter;

import java.util.Date;
import java.util.List;
import org.eclipse.vjet.dsf.common.converter.BaseConverter;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;

public class StringConverter
extends BaseConverter<String> {
    private static final List<Class> VALID_CONVERSION_TYPES;

    static {
        Class[] types = new Class[]{Integer.class, Long.class, Boolean.class, Float.class, Double.class, Date.class, java.sql.Date.class, Enum.class, String.class};
        VALID_CONVERSION_TYPES = StringConverter.immutableTypeList(types);
    }

    @Override
    public Class<String> getTargetType() {
        return String.class;
    }

    @Override
    public List<Class> getValidConversionTypes() {
        return VALID_CONVERSION_TYPES;
    }

    @Override
    public IConversionResult<String> convert(Object preValue) {
        if (preValue == null) {
            return this.setResult(preValue, null);
        }
        try {
            if (this.canConvertFromType(preValue.getClass())) {
                if (preValue instanceof Enum) {
                    return this.setResult(preValue, ((Enum)preValue).name());
                }
                return this.setResult(preValue, preValue.toString());
            }
            return this.setResult(preValue, IConverter.IncompatibleTypeConversionError);
        }
        catch (Exception exception) {
            return this.setResult(preValue, IConverter.UnconvertableValueConversionError);
        }
    }
}

