/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdebugger.gui;

import java.io.File;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import org.eclipse.vjet.dsf.jsdebugger.gui.BreakpointCache;
import org.eclipse.vjet.dsf.jsdebugger.gui.MessageDialogWrapper;
import org.eclipse.vjet.dsf.jsdebugger.gui.SwingGui;
import org.eclipse.vjet.dsf.jsdi.ISourceInfo;
import org.eclipse.vjet.dsf.jsdi.StackFrameInfo;
import org.eclipse.vjet.dsf.jsdi.agent.remote.LocalSourceInfo;

class RunProxy
implements Runnable {
    static final int OPEN_FILE = 1;
    static final int LOAD_FILE = 2;
    static final int UPDATE_SOURCE_TEXT = 3;
    static final int ENTER_INTERRUPT = 4;
    private SwingGui m_debugGui;
    private int m_type;
    String m_fileName;
    String m_text;
    ISourceInfo m_sourceInfo;
    StackFrameInfo m_lastFrame;
    String m_threadTitle;
    String m_alertMessage;

    public RunProxy(SwingGui debugGui, int type) {
        this.m_debugGui = debugGui;
        this.m_type = type;
    }

    @Override
    public void run() {
        switch (this.m_type) {
            case 1: {
                int[] breakPoints;
                if (this.m_debugGui.m_debuggerControl != null) {
                    try {
                        this.m_debugGui.m_debuggerControl.compileScript(this.m_fileName, this.m_text);
                    }
                    catch (RuntimeException ex) {
                        MessageDialogWrapper.showMessageDialog(this.m_debugGui, ex.getMessage(), "Error Compiling " + this.m_fileName, 0);
                    }
                    catch (RemoteException re) {
                        re.printStackTrace();
                    }
                    break;
                }
                try {
                    this.m_fileName = new File(this.m_fileName).toURL().toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {}
                LocalSourceInfo sourceInfo = new LocalSourceInfo(this.m_fileName, this.m_text);
                BreakpointCache.Breakpoints bpCache = BreakpointCache.getBreakpoints(this.m_fileName);
                if (bpCache != null && (breakPoints = bpCache.getBreakpoints()) != null) {
                    int[] nArray = breakPoints;
                    int n = breakPoints.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int line = nArray[n2];
                        try {
                            sourceInfo.setBreakpoint(line, true);
                        }
                        catch (RemoteException remoteException) {}
                        ++n2;
                    }
                }
                try {
                    if (this.m_debugGui.updateFileWindow((ISourceInfo)sourceInfo) || this.m_fileName.equals("<stdin>")) break;
                    this.m_debugGui.createFileWindow((ISourceInfo)sourceInfo, -1);
                    break;
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
            case 2: {
                try {
                    this.m_debugGui.m_debuggerControl.evalScript(this.m_fileName, this.m_text);
                }
                catch (RuntimeException ex) {
                    MessageDialogWrapper.showMessageDialog(this.m_debugGui, ex.getMessage(), "Run error for " + this.m_fileName, 0);
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
                break;
            }
            case 3: {
                try {
                    String fileName = this.m_sourceInfo.getUri();
                    if (this.m_debugGui.updateFileWindow(this.m_sourceInfo) || fileName.equals("<stdin>")) break;
                    this.m_debugGui.createFileWindow(this.m_sourceInfo, -1);
                }
                catch (RemoteException remoteException) {}
                break;
            }
            case 4: {
                try {
                    this.m_debugGui.enterInterruptImpl(this.m_lastFrame, this.m_threadTitle, this.m_alertMessage);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(this.m_type));
            }
        }
    }
}

