/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.util.Map;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugFrame;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugger;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.VMBridge;
import org.mozilla.mod.javascript.debug.Debugger;

final class PropertyGetCommand
extends DBGPDebugger.Command {
    private final DBGPDebugger m_debugger;

    PropertyGetCommand(DBGPDebugger debugger) {
        this.m_debugger = debugger;
    }

    @Override
    void parseAndExecute(String command, Map<String, String> options) {
        String longName = options.get("-n");
        int level = 0;
        String depth = options.get("-d");
        if (depth != null) {
            level = Integer.parseInt(depth);
        }
        Object value = null;
        int shName = longName.indexOf(46);
        if (shName == -1) {
            shName = longName.length();
        }
        String shortName = longName.substring(0, shName);
        StringBuffer properties = new StringBuffer();
        DBGPDebugFrame stackFrame = this.m_debugger.m_stackmanager.getStackFrame(level);
        if (stackFrame != null) {
            if (Context.getCurrentContext() == null) {
                Object helper = VMBridge.instance.getThreadContextHelper();
                VMBridge.instance.setContext(helper, stackFrame.getContext());
            }
            Context currentContext = Context.getCurrentContext();
            Debugger debugger = currentContext.getDebugger();
            Object contextData = currentContext.getDebuggerContextData();
            currentContext.setDebugger(null, null);
            this.m_debugger.setCurrentScope(stackFrame.getThis());
            value = stackFrame.getValue(longName);
            this.m_debugger.printProperty(shortName, longName, value, properties, 0, true);
            currentContext.setDebugger(debugger, contextData);
        }
        this.m_debugger.printResponse("<response command=\"property_get\"\r\n transaction_id=\"" + options.get("-i") + "\">\r\n" + properties + "</response>\r\n");
    }
}

