/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.util.ArrayList;
import java.util.List;
import java.util.Observer;
import java.util.WeakHashMap;
import org.eclipse.vjet.dsf.js.dbgp.BreakPoint;
import org.eclipse.vjet.dsf.js.dbgp.BreakPointManager;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugFrame;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugger;
import org.mozilla.mod.javascript.Context;

public class DBGPStackManager {
    protected static final WeakHashMap<Context, DBGPStackManager> s_map = new WeakHashMap();
    private static boolean s_breakpointsThreadLocal;
    private static BreakPointManager s_gmanager;
    private List<DBGPDebugFrame> m_stack = new ArrayList<DBGPDebugFrame>();
    private boolean m_needSuspend;
    private DBGPDebugger m_observer;
    private BreakPointManager m_manager = null;
    private boolean m_suspendOnExit;
    private boolean m_suspendOnEntry;
    private boolean m_suspenOnChangeLine;

    static {
        s_gmanager = null;
    }

    public BreakPointManager getManager() {
        return this.m_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DBGPStackManager() {
        if (DBGPStackManager.isBreakpointsThreadLocal()) {
            this.m_manager = new BreakPointManager();
            return;
        }
        Class<DBGPStackManager> clazz = DBGPStackManager.class;
        synchronized (DBGPStackManager.class) {
            if (s_gmanager == null) {
                s_gmanager = new BreakPointManager();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.m_manager = s_gmanager;
            return;
        }
    }

    public static DBGPStackManager getManager(Context cx) {
        DBGPStackManager object = s_map.get(cx);
        if (object == null) {
            object = new DBGPStackManager();
            s_map.put(cx, object);
        }
        return object;
    }

    public static void removeManager(Context cx) {
        s_map.remove(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(DBGPDebugFrame debugFrame) {
        BreakPoint hit;
        this.m_stack.add(debugFrame);
        String sn = debugFrame.getWhere();
        if (sn != null && (hit = this.m_manager.hitEnter(sn)) != null) {
            this.checkBreakpoint(debugFrame, hit);
        }
        if (this.m_suspendOnEntry) {
            if (debugFrame.getWhere().equals("module")) {
                this.m_observer.update(null, this);
                DBGPStackManager dBGPStackManager = this;
                synchronized (dBGPStackManager) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.m_suspenOnChangeLine = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(DBGPDebugFrame debugFrame) {
        BreakPoint hit;
        String sn;
        if (this.m_needSuspend || this.m_suspendOnExit) {
            this.m_observer.update(null, this);
            DBGPStackManager dBGPStackManager = this;
            synchronized (dBGPStackManager) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if ((sn = debugFrame.getWhere()) != null && (hit = this.m_manager.hitExit(sn)) != null) {
            this.checkBreakpoint(debugFrame, hit);
        }
        this.m_stack.remove(debugFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeLine(DBGPDebugFrame frame, int lineNumber) {
        if (this.m_suspenOnChangeLine) {
            this.m_suspenOnChangeLine = false;
            this.m_observer.update(null, this);
            DBGPStackManager dBGPStackManager = this;
            synchronized (dBGPStackManager) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (frame.isSuspend()) {
            this.m_needSuspend = true;
        }
        BreakPoint hit = this.m_manager.hit(frame.getSourceName(), lineNumber);
        this.checkBreakpoint(frame, hit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBreakpoint(DBGPDebugFrame frame, BreakPoint hit) {
        if (hit != null && hit.isEnabled()) {
            Object eval;
            this.m_needSuspend = hit.m_expression != null ? ((eval = frame.eval(hit.m_expression)) != null ? eval.equals(Boolean.TRUE) : false) : true;
        }
        if (this.m_needSuspend) {
            this.m_observer.update(null, this);
            DBGPStackManager dBGPStackManager = this;
            synchronized (dBGPStackManager) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void exceptionThrown(Throwable ex) {
    }

    public void suspend() {
        this.m_needSuspend = true;
    }

    public int getStackDepth() {
        return this.m_stack.size();
    }

    public DBGPDebugFrame getStackFrame(int parseInt) {
        int stackCounter = this.m_stack.size() - parseInt - 1;
        if (stackCounter >= 0) {
            return this.m_stack.get(stackCounter);
        }
        return null;
    }

    public int getLineNumber(String level) {
        return this.getStackFrame(0).getLineNumber();
    }

    public void registerBreakPoint(BreakPoint p) {
        this.m_manager.addBreakPoint(p);
    }

    public void setDebugger(DBGPDebugger debugger) {
        this.m_observer = debugger;
    }

    public synchronized void resume() {
        this.m_needSuspend = false;
        int a = 0;
        while (a < this.getStackDepth()) {
            this.getStackFrame(a).setSuspend(false);
            ++a;
        }
        this.notify();
    }

    public synchronized void stepOver() {
        this.getStackFrame(0).setSuspend(true);
        if (this.getStackDepth() > 1) {
            this.getStackFrame(1).setSuspend(true);
        }
        this.m_needSuspend = false;
        this.notify();
    }

    public synchronized void stepIn() {
        this.m_needSuspend = true;
        this.notify();
    }

    public synchronized void stepOut() {
        this.getStackFrame(0).setSuspend(false);
        this.m_needSuspend = false;
        if (this.getStackDepth() > 1) {
            this.getStackFrame(1).setSuspend(true);
        }
        this.notify();
    }

    public synchronized void waitForNotify() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    public void removeBreakpoint(String id) {
        this.m_manager.removeBreakPoint(id);
    }

    public void updateBreakpoint(String id, String newState, String newLine, String hitValue, String hitCondition, String condExpr) {
        this.m_manager.updateBreakpoint(id, newState, newLine, hitValue, hitCondition, condExpr);
    }

    public Observer getObserver() {
        return this.m_observer;
    }

    public BreakPoint getBreakpoint(String id) {
        return this.m_manager.getBreakpoint(id);
    }

    public void setSuspendOnExit(boolean parseBoolean) {
        this.m_suspendOnExit = parseBoolean;
    }

    public void setSuspendOnEntry(boolean parseBoolean) {
        this.m_suspendOnEntry = parseBoolean;
    }

    public static boolean isBreakpointsThreadLocal() {
        return s_breakpointsThreadLocal;
    }

    public static void setBreakpointsThreadLocal(boolean breakpointsThreadLocal) {
        s_breakpointsThreadLocal = breakpointsThreadLocal;
    }
}

