/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.util;

import java.io.StringReader;
import java.net.URL;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.html.js.JSHTMLBuilder;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.eclipse.vjet.dsf.html.js.JSWindowFactory;
import org.xml.sax.InputSource;

public class HtmlBuilderHelper {
    public static final String REGX_TAG_SKIP = "(<[a-zA-Z_0-9:]+)/([ a-zA-Z_0-9:]+)";

    public static JSWindow parse(String src, URL baseUrl, JSWindow window) {
        return HtmlBuilderHelper.parse(src, baseUrl, 1, window);
    }

    public static JSWindow parse(String src, URL baseUrl) {
        return HtmlBuilderHelper.parse(src, baseUrl, 1);
    }

    public static JSWindow parse(String src, URL baseUrl, int encoding) {
        JSWindow window = JSWindowFactory.createJSWindow();
        return HtmlBuilderHelper.parse(src, baseUrl, encoding, window);
    }

    public static JSWindow parse(String src, URL baseUrl, int encoding, JSWindow window) {
        StringReader sr = new StringReader(src);
        try {
            JSHTMLBuilder.doParse(window, new InputSource(sr), baseUrl, encoding);
        }
        catch (Exception e) {
            throw new DsfRuntimeException(e.getMessage(), (Throwable)e);
        }
        return window;
    }

    public static JSWindow parse(URL url) {
        return HtmlBuilderHelper.parse(url, 1);
    }

    public static JSWindow parse(URL url, int encoding) {
        JSWindow window = JSWindowFactory.createJSWindow();
        try {
            JSHTMLBuilder.doParse(window, url, encoding);
        }
        catch (Exception e) {
            throw new DsfRuntimeException(e.getMessage(), (Throwable)e);
        }
        return window;
    }
}

