/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DIFrame;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.HtmlIFrame;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;

public class AHtmlIFrame
extends AHtmlElement
implements HtmlIFrame {
    private static final long serialVersionUID = 1L;
    private AHtmlDocument m_contentDocument = null;

    protected AHtmlIFrame(AHtmlDocument doc, DIFrame node) {
        super(doc, (BaseHtmlElement)node);
        this.populateScriptable(AHtmlIFrame.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    public HtmlDocument getDocument() {
        return this.m_contentDocument;
    }

    public HtmlDocument getContentDocument() {
        return this.m_contentDocument;
    }

    public String getAlign() {
        return this.getDIFrame().getHtmlAlign();
    }

    public String getFrameBorder() {
        return this.getDIFrame().getHtmlFrameBorder();
    }

    public String getHeight() {
        return this.getDIFrame().getHtmlHeight();
    }

    public String getLongDesc() {
        return this.getDIFrame().getHtmlLongDesc();
    }

    public String getMarginHeight() {
        return this.getDIFrame().getHtmlMarginHeight();
    }

    public String getMarginWidth() {
        return this.getDIFrame().getHtmlMarginWidth();
    }

    public String getName() {
        return this.getDIFrame().getHtmlName();
    }

    public String getScrolling() {
        return this.getDIFrame().getHtmlScrolling();
    }

    public String getSrc() {
        return this.getDIFrame().getHtmlSrc();
    }

    public String getWidth() {
        return this.getDIFrame().getHtmlWidth();
    }

    public void setAlign(String align) {
        this.getDIFrame().setHtmlAlign(align);
        this.onAttrChange(EHtmlAttr.align, align);
    }

    public void setFrameBorder(Object on) {
        if (on instanceof String) {
            this.getDIFrame().setHtmlFrameBorder((String)on);
            this.onAttrChange(EHtmlAttr.frameborder, (String)on);
        }
        if (on instanceof Integer) {
            this.getDIFrame().setHtmlFrameBorder(((Integer)on).toString());
            this.onAttrChange(EHtmlAttr.frameborder, (Integer)on);
        }
    }

    public void setHeight(String height) {
        this.getDIFrame().setHtmlHeight(height);
        this.onAttrChange(EHtmlAttr.height, height);
    }

    public void setLongDesc(String longDesc) {
        this.getDIFrame().setHtmlLongDesc(longDesc);
        this.onAttrChange(EHtmlAttr.longdesc, longDesc);
    }

    public void setMarginHeight(String marginHeight) {
        this.getDIFrame().setHtmlMarginHeight(marginHeight);
        this.onAttrChange(EHtmlAttr.marginheight, marginHeight);
    }

    public void setMarginWidth(String marginWidth) {
        this.getDIFrame().setHtmlMarginWidth(marginWidth);
        this.onAttrChange(EHtmlAttr.marginwidth, marginWidth);
    }

    public void setName(String name) {
        this.getDIFrame().setHtmlName(name);
        this.onAttrChange(EHtmlAttr.name, name);
    }

    public void setScrolling(String scrolling) {
        this.getDIFrame().setHtmlScrolling(scrolling);
        this.onAttrChange(EHtmlAttr.scrolling, scrolling);
    }

    public void setSrc(String src) {
        this.getDIFrame().setHtmlSrc(src);
        this.setContentDocument(AHtmlHelper.getContentDocument(this, src));
        this.onAttrChange(EHtmlAttr.src, src);
    }

    public void setWidth(String width) {
        this.getDIFrame().setHtmlWidth(width);
        this.onAttrChange(EHtmlAttr.width, width);
    }

    public Object getOnblur() {
        return this.getOnBlur();
    }

    public Object getOnfocus() {
        return this.getOnFocus();
    }

    public void setOnblur(Object functionRef) {
        this.setOnBlur(functionRef);
    }

    public void setOnfocus(Object functionRef) {
        this.setOnFocus(functionRef);
    }

    public Object getOnload() {
        return this.getOnLoad();
    }

    public void setOnload(Object functionRef) {
        this.setOnLoad(functionRef);
    }

    public Object getOnunload() {
        return this.getOnLoad();
    }

    public void setOnunload(Object functionRef) {
        this.setOnLoad(functionRef);
    }

    private DIFrame getDIFrame() {
        return (DIFrame)this.getDNode();
    }

    void setContentDocument(AHtmlDocument frameDoc) {
        this.m_contentDocument = frameDoc;
    }
}

