/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.client;

import java.text.MessageFormat;
import org.eclipse.vjet.dsf.active.client.ActiveObject;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.jsnative.Opera;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.jsnative.global.Function;

public class AOpera
extends ActiveObject
implements Opera {
    private static final long serialVersionUID = -2031523986573037809L;
    private static final String SET_OVERRIDE_HISTORY_MODE = "window.opera.setOverrideHistoryNavigationMode({0})";
    private static final String SET_PREFERENCE = "window.opera.setPreference({0}, {1}, {2})";
    private static final String REMOVE_EVENT_LISTENER = "window.opera.removeEventListener({0}, {1}, {2})";
    private static final String ADD_EVENT_LISTENER = "window.opera.addEventListener({0}, {1}, {2})";
    private static final String DEFINE_MAGIC_FUNCTION = "window.opera.defineMagicFunction({0}, {1})";
    private static final String DEFINE_MAGIC_VARIABLE = "window.opera.defineMagicVariable({0}, {1}, {2})";
    private static final String GET_PREFERENCE = "window.opera.getPreference({0}, {1})";
    private static final String GET_PREFERENCE_DEFAULT = "window.opera.getPreferenceDefault({0}, {1})";
    private IBrowserBinding m_browserBinding;

    public AOpera(BrowserType browserType, IBrowserBinding bowserBinding) {
        this.m_browserBinding = bowserBinding;
        this.populateScriptable(AOpera.class, browserType);
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return ((Object)((Object)this)).getClass().getName();
        }
        return null;
    }

    public void addEventListener(String type, Function handler, boolean phase) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs(MessageFormat.format(ADD_EVENT_LISTENER, type, handler, phase));
        }
    }

    public void collect() {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs("window.opera.collect");
        }
    }

    public void defineMagicFunction(String funcName, Function replacementFunction) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs(MessageFormat.format(DEFINE_MAGIC_FUNCTION, funcName, replacementFunction));
        }
    }

    public void defineMagicVariable(String VarName, Function getter, Function setter) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs(MessageFormat.format(DEFINE_MAGIC_VARIABLE, VarName, getter, setter));
        }
    }

    public String buildNumber() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.executeJs("window.opera.buildNumber()");
        }
        return "";
    }

    public String getOverrideHistoryNavigationMode() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.executeJs("window.opera.overrideHistoryNavigationMode()");
        }
        return "";
    }

    public String getPreference(String section, String preference) {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.executeJs(MessageFormat.format(GET_PREFERENCE, section, preference));
        }
        return "";
    }

    public String getPreferenceDefault(String section, String preference) {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.executeJs(MessageFormat.format(GET_PREFERENCE_DEFAULT, section, preference));
        }
        return "";
    }

    public String version() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.executeJs("window.opera.version()");
        }
        return "";
    }

    public void removeEventListener(String type, Function handler, boolean phase) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs(MessageFormat.format(REMOVE_EVENT_LISTENER, type, handler, phase));
        }
    }

    public void setOverrideHistoryNavigationMode(String mode) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs(MessageFormat.format(SET_OVERRIDE_HISTORY_MODE, mode));
        }
    }

    public void setPreference(String section, String preference, String value) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs(MessageFormat.format(SET_PREFERENCE, section, preference, value));
        }
    }
}

