/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IArrayInitializer;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;

public class ArrayInitializer
extends Expression
implements IArrayInitializer {
    public Expression[] expressions;
    public ArrayBinding binding;

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('[');
        if (this.expressions != null) {
            int j = 20;
            int i = 0;
            while (i < this.expressions.length) {
                if (i > 0) {
                    output.append(", ");
                }
                if (this.expressions[i] != null) {
                    this.expressions[i].printExpression(0, output);
                }
                if (--j == 0) {
                    output.append('\n');
                    ArrayInitializer.printIndent(indent + 1, output);
                    j = 20;
                }
                ++i;
            }
        }
        return output.append(']');
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.expressions != null) {
            int expressionsLength = this.expressions.length;
            int i = 0;
            while (i < expressionsLength) {
                if (this.expressions[i] != null) {
                    this.expressions[i].traverse(visitor, scope);
                }
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public int getASTType() {
        return 9;
    }
}

