/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.wizards;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.ScriptModelUtil;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.mod.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.mod.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.mod.ui.DLTKUILanguageManager;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.mod.ui.ModelElementLabelProvider;
import org.eclipse.dltk.mod.ui.wizards.Messages;
import org.eclipse.dltk.mod.ui.wizards.NewContainerWizardPage;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.TableTextCellEditor;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.CompletionContextRequestor;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contentassist.ContentAssistHandler;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoSemanticRule;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblem;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.ClassBetterStartWithCapitalLetterRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.InvalidIdentifierNameRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.InvalidIdentifierNameWithKeywordRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.TypeNameShouldNotBeEmptyRuleCtx;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.eclipse.internal.core.util.Util;
import org.eclipse.vjet.eclipse.internal.ui.dialogs.VjoOpenTypeSelectionDialog;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VjetWizardMessages;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VjoClassCreationPage;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VjoNameValidator;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VjoPackageCompletionProcessor;

public abstract class VjoSourceModulePage
extends NewContainerWizardPage {
    private static final String PACKAGE = "NewPackageWizardPage.package";
    protected static final String FILE = "NewSourceModulePage.file";
    private SelectionButtonDialogField fAddCommentButton;
    private boolean fUseAddCommentButtonValue;
    protected IStatus sourceMoudleStatus;
    protected IScriptFolder currentScriptFolder;
    protected StringDialogField fileDialogField;
    final char DOT = (char)46;
    private ListDialogField fSuperInterfacesDialogField;
    private IStatus packageStatus;
    private StringButtonDialogField packageDialogField;
    private IScriptFolder currPackageRoot;
    ContentProposalAdapter packageAdapter;
    private VjoPackageCompletionProcessor fCurrPackageCompletionProcessor;
    private final int PUBLIC_INDEX = 0;
    private final int DEFAULT_INDEX = 1;
    private final int PRIVATE_INDEX = 2;
    private final int PROTECTED_INDEX = 3;
    private final int ABSTRACT_INDEX = 0;
    private final int FINAL_INDEX = 1;
    private final int STATIC_INDEX = 2;
    private SelectionButtonDialogFieldGroup fAccMdfButtons;
    private SelectionButtonDialogFieldGroup fOtherMdfButtons;

    public boolean addSuperInterface(IJstType superInterface) {
        return this.fSuperInterfacesDialogField.addElement((Object)new InterfaceWrapper(superInterface));
    }

    protected void createSuperInterfacesControls(Composite composite, int nColumns) {
        this.fSuperInterfacesDialogField.doFillIntoGrid(composite, nColumns);
        final TableViewer tableViewer = this.fSuperInterfacesDialogField.getTableViewer();
        tableViewer.setColumnProperties(new String[]{"interface"});
        TableTextCellEditor cellEditor = new TableTextCellEditor(tableViewer, 0){

            protected void doSetFocus() {
                if (this.text != null) {
                    this.text.setFocus();
                    this.text.setSelection(this.text.getText().length());
                    this.checkSelection();
                    this.checkDeleteable();
                    this.checkSelectable();
                }
            }
        };
        JavaTypeCompletionProcessor superInterfaceCompletionProcessor = new JavaTypeCompletionProcessor(false, false, true);
        superInterfaceCompletionProcessor.setCompletionContextRequestor(new CompletionContextRequestor(){

            public StubTypeContext getStubTypeContext() {
                return null;
            }
        });
        SubjectControlContentAssistant contentAssistant = ControlContentAssistHelper.createJavaContentAssistant((IContentAssistProcessor)superInterfaceCompletionProcessor);
        Text cellEditorText = cellEditor.getText();
        ContentAssistHandler.createHandlerForText((Text)cellEditorText, (SubjectControlContentAssistant)contentAssistant);
        TextFieldNavigationHandler.install((Text)cellEditorText);
        cellEditor.setContentAssistant(contentAssistant);
        tableViewer.setCellEditors(new CellEditor[]{cellEditor});
        tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000B && event.stateMask == 0) {
                    ISelection selection = tableViewer.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    tableViewer.editElement(structuredSelection.getFirstElement(), 0);
                }
            }
        });
        GridData gd = (GridData)this.fSuperInterfacesDialogField.getListControl(null).getLayoutData();
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
    }

    public ListDialogField getSuperInterfacesDialogField() {
        return this.fSuperInterfacesDialogField;
    }

    private void packageChangeControlPressed(DialogField field) {
        IScriptFolder root = this.choosePackage();
        if (root != null) {
            this.setScriptFolderRoot(root, true);
        }
    }

    public void setScriptFolderRoot(IScriptFolder root, boolean canBeModified) {
        this.currPackageRoot = root;
        String str = root == null ? "" : root.getPath().removeFirstSegments(this.getProjectFragment().getPath().segmentCount()).makeRelative().toString();
        str = str.replace("/", ".");
        this.packageDialogField.setText(str);
        this.packageDialogField.setEnabled(canBeModified);
    }

    public IScriptFolder getCurrPackageRoot() {
        return this.currPackageRoot;
    }

    protected IScriptFolder choosePackage() {
        IProjectFragment froot = this.getProjectFragment();
        Object[] packages = null;
        try {
            if (froot != null && froot.exists()) {
                packages = froot.getChildren();
            }
        }
        catch (ModelException modelException) {}
        if (packages == null) {
            packages = new IModelElement[]{};
        }
        ModelElementLabelProvider labelProvider = new ModelElementLabelProvider(ModelElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setIgnoreCase(false);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_description);
        dialog.setElements(packages);
        dialog.setHelpAvailable(false);
        IScriptFolder pack = this.currPackageRoot;
        if (pack != null) {
            dialog.setInitialSelections(new Object[]{pack});
        }
        if (dialog.open() == 0) {
            return (IScriptFolder)dialog.getFirstResult();
        }
        return null;
    }

    private void packageDialogFieldChanged(DialogField field) {
        if (field == this.packageDialogField) {
            this.packageChanged();
            this.handleFieldChanged(PACKAGE);
        }
    }

    private IStatus validatePackageName(String name) {
        if (VjoNameValidator.startOrEndWithDot(name) != null) {
            return VjoNameValidator.startOrEndWithDot(name);
        }
        if (name != null && name.length() > 0 && VjoSourceModulePage.containInvalidCharInPackageName(name)) {
            Object[] objects = new Object[]{"'" + name + "'"};
            String m = VjetWizardMessages.ClassCreationWizard_invalid_package_name;
            return new StatusInfo(4, MessageFormat.format(m, objects));
        }
        if (VjoNameValidator.consecutiveDotsName(name) != null) {
            return VjoNameValidator.consecutiveDotsName(name);
        }
        return new StatusInfo();
    }

    private static String containInvalidCharOrKeyword(String name) {
        IVjoSemanticRule invalidIdentifierNameWithKeywordRule;
        String message = null;
        IVjoSemanticRule invalidIdentifierNameRule = VjoSemanticRuleRepo.getInstance().INVALID_IDENTIFIER;
        VjoSemanticProblem vjoSemanticProblem = invalidIdentifierNameRule.fire((IVjoSemanticRuleCtx)new InvalidIdentifierNameRuleCtx(name));
        if (vjoSemanticProblem != null && vjoSemanticProblem.getID() != null) {
            message = vjoSemanticProblem.getID().getName();
        }
        if ((vjoSemanticProblem = (invalidIdentifierNameWithKeywordRule = VjoSemanticRuleRepo.getInstance().INVALID_IDENTIFIER_WITH_KEYWORD).fire((IVjoSemanticRuleCtx)new InvalidIdentifierNameWithKeywordRuleCtx(name, false))) != null && vjoSemanticProblem.getID() != null) {
            message = vjoSemanticProblem.getID().getName();
        }
        return message;
    }

    public static String isEmptyName(String name) {
        String message = null;
        IVjoSemanticRule isNameEmptyRule = VjoSemanticRuleRepo.getInstance().TYPE_NAME_SHOULD_NOT_BE_EMPTY;
        VjoSemanticProblem vjoSemanticProblem = isNameEmptyRule.fire((IVjoSemanticRuleCtx)new TypeNameShouldNotBeEmptyRuleCtx(name));
        if (vjoSemanticProblem != null && vjoSemanticProblem.getID() != null) {
            message = vjoSemanticProblem.getID().getName();
        }
        return message;
    }

    private static String isLowerCaseFirstChar(String name) {
        String message = null;
        IVjoSemanticRule isLowerCaseFirstCharRule = VjoSemanticRuleRepo.getInstance().CLASS_BETTER_START_WITH_NONE_CAPITAL_LETTER;
        VjoSemanticProblem vjoSemanticProblem = isLowerCaseFirstCharRule.fire((IVjoSemanticRuleCtx)new ClassBetterStartWithCapitalLetterRuleCtx(name));
        if (vjoSemanticProblem != null && vjoSemanticProblem.getID() != null) {
            message = vjoSemanticProblem.getID().getName();
        }
        return message;
    }

    public static boolean containInvalidCharInPackageName(String name) {
        String[] nameFields;
        String[] stringArray = nameFields = name.split("\\.");
        int n = nameFields.length;
        int n2 = 0;
        while (n2 < n) {
            String nameField = stringArray[n2];
            String message = VjoSourceModulePage.containInvalidCharOrKeyword(nameField);
            if (message != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IStatus packageChanged() {
        this.fCurrPackageCompletionProcessor.setPackageFragmentRoot(this.getProjectFragment());
        StatusInfo status = new StatusInfo();
        String packName = this.packageDialogField.getText();
        if (packName.length() > 0) {
            IStatus val = this.validatePackageName(packName);
            if (val.getSeverity() == 4) {
                status.setError(MessageFormat.format(VjetWizardMessages.NewPackageWizardPage_error_InvalidPackageName, val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(MessageFormat.format(VjetWizardMessages.NewPackageWizardPage_warning_DiscouragedPackageName, val.getMessage()));
            }
        } else {
            status.setWarning(MessageFormat.format(VjetWizardMessages.NewPackageWizardPage_warning_DiscouragedPackageName, ""));
            return status;
        }
        if (this.getProjectFragment() != null) {
            this.currPackageRoot = this.getProjectFragment().getScriptFolder(packName);
            StatusInfo statusFile = this.fileChanged();
            if (statusFile.getSeverity() == 4) {
                return statusFile;
            }
        }
        return status;
    }

    private String[] createPackagesProposals(String input) {
        ArrayList<String> proposals = new ArrayList<String>();
        String prefix = input;
        try {
            IModelElement[] packageFragments = this.getProjectFragment().getChildren();
            int i = 0;
            while (i < packageFragments.length) {
                IScriptFolder pack = (IScriptFolder)packageFragments[i];
                String packName = pack.getElementName();
                if (packName.length() != 0 && packName.startsWith(prefix)) {
                    String proposal = packName;
                    proposals.add(proposal);
                }
                ++i;
            }
        }
        catch (ModelException modelException) {}
        return proposals.toArray(new String[proposals.size()]);
    }

    protected void createPackageControls(Composite parent, int nColumns) {
        this.packageDialogField.doFillIntoGrid(parent, nColumns);
        Text text = this.packageDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this.fCurrPackageCompletionProcessor);
    }

    private StatusInfo fileChanged() {
        StatusInfo status = new StatusInfo();
        String emptyTypeName = VjoSourceModulePage.isEmptyName(this.getFileText());
        if (emptyTypeName != null) {
            status.setError(VjetWizardMessages.VjoSourceModulePage_pathCannotBeEmpty);
        } else {
            String name = this.getFileText();
            if (name != null && name.length() > 0) {
                IStatus startWithLowerCaseWarning;
                String invalidCharOrKeywordMessage = VjoSourceModulePage.containInvalidCharOrKeyword(name);
                if (invalidCharOrKeywordMessage != null) {
                    Object[] objects = new Object[]{name};
                    String m = VjetWizardMessages.ClassCreationWizard_invalid_file_name;
                    return new StatusInfo(4, MessageFormat.format(m, objects));
                }
                if (this.currPackageRoot != null) {
                    IFolder cfr_ignored_0 = (IFolder)this.currPackageRoot.getResource();
                    String errorMessage = this.getErrroMessageOfTypeIsInWorkSpace(this.currPackageRoot, this.getFileName());
                    if (errorMessage != null) {
                        status.setError(errorMessage);
                        return status;
                    }
                }
                if ((startWithLowerCaseWarning = VjoSourceModulePage.getLowerCaseFirstCharWarning(name)) != null) {
                    return (StatusInfo)startWithLowerCaseWarning;
                }
            }
        }
        return status;
    }

    public static IStatus getLowerCaseFirstCharWarning(String name) {
        String startWithLowerCaseMessage = VjoSourceModulePage.isLowerCaseFirstChar(name);
        if (startWithLowerCaseMessage != null) {
            String m = VjetWizardMessages.Convention_type_uppercaseName;
            return new StatusInfo(2, m);
        }
        return null;
    }

    private String getErrroMessageOfTypeIsInWorkSpace(IScriptFolder currPackageRoot, String name) {
        try {
            IModelElement[] allModelElements;
            IModelElement[] iModelElementArray = allModelElements = currPackageRoot.getChildren();
            int n = allModelElements.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement modelElement = iModelElementArray[n2];
                String currentElementName = modelElement.getElementName();
                if (name.equals(currentElementName)) {
                    return Messages.NewSourceModulePage_fileAlreadyExists;
                }
                if (name.equalsIgnoreCase(currentElementName)) {
                    return Messages.NewSourceModulePage_typeAlreadyExists;
                }
                ++n2;
            }
        }
        catch (ModelException modelException) {}
        return null;
    }

    public void init(IStructuredSelection selection) {
        IModelElement element = this.getInitialScriptElement(selection);
        this.initContainerPage(element);
        this.initPackagePage(element);
        this.updateStatus(new IStatus[]{this.containerStatus, this.fileChanged()});
    }

    protected void initPackagePage(IModelElement elem) {
        IScriptFolder initRoot = null;
        if (elem != null) {
            initRoot = (IScriptFolder)elem.getAncestor(4);
            if (initRoot instanceof ExternalScriptFolder) {
                initRoot = null;
            }
            try {
                if (initRoot == null) {
                    IScriptProject project;
                    IProjectFragment fragment = ScriptModelUtil.getProjectFragment((IModelElement)elem);
                    if (fragment != null && fragment.getKind() == 1 && !fragment.isExternal()) {
                        initRoot = fragment.getScriptFolder("");
                    }
                    if (initRoot == null && (project = elem.getScriptProject()) != null) {
                        initRoot = null;
                        if (project.exists()) {
                            IProjectFragment[] roots = project.getProjectFragments();
                            int i = 0;
                            while (i < roots.length) {
                                if (roots[i].getKind() == 1) {
                                    initRoot = roots[i].getScriptFolder("");
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (initRoot == null) {
                            initRoot = project.getProjectFragment(project.getResource()).getScriptFolder("");
                        }
                    }
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log((Throwable)e);
            }
        }
        this.setScriptFolderRoot(initRoot, true);
        this.handleFieldChanged("NewContainerWizardPage.container");
    }

    protected void createFileControls(Composite parent, int nColumns) {
        this.fileDialogField.doFillIntoGrid(parent, nColumns - 1);
        Text text = this.fileDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        DialogField.createEmptySpace((Composite)parent);
        this.createModifierControls(parent, nColumns);
    }

    protected void createModifierControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fAccMdfButtons.getLabelControl(composite), (int)1);
        Composite control = this.fAccMdfButtons.getSelectionButtonsGroup(composite);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns - 2;
        control.setLayoutData((Object)gd);
        if (!("etype".equals(this.getPageType()) || "itype".equals(this.getPageType()) || "mtype".equals(this.getPageType()))) {
            DialogField.createEmptySpace((Composite)composite);
            DialogField.createEmptySpace((Composite)composite);
            control = this.fOtherMdfButtons.getSelectionButtonsGroup(composite);
            gd = new GridData(256);
            gd.horizontalSpan = nColumns - 2;
            control.setLayoutData((Object)gd);
        }
        DialogField.createEmptySpace((Composite)composite);
    }

    public String getModifiers() {
        StringBuffer mdf = new StringBuffer();
        if (this.fAccMdfButtons.isSelected(0)) {
            mdf.append("public");
        } else if (this.fAccMdfButtons.isSelected(1)) {
            mdf.append("default");
        } else if (this.fAccMdfButtons.isSelected(2)) {
            mdf.append("private");
        } else if (this.fAccMdfButtons.isSelected(3)) {
            mdf.append("protected");
        }
        if (this.fOtherMdfButtons.isSelected(0)) {
            mdf.append(",abstract");
        }
        if (this.fOtherMdfButtons.isSelected(1)) {
            mdf.append(",final");
        }
        if (this.fOtherMdfButtons.isSelected(2)) {
            mdf.append(",static");
        }
        return mdf.toString();
    }

    protected IDLTKSearchScope getSearchScope() {
        return null;
    }

    protected IDLTKUILanguageToolkit getUILanguageToolkit() {
        return DLTKUILanguageManager.getLanguageToolkit((String)"org.eclipse.vjet.core.nature");
    }

    protected String getSatisfierDialogTitle() {
        return VjetWizardMessages.ClassCreationWizard_satisfier_selection;
    }

    protected String getOpenTypeDialogMessage() {
        return DLTKUIMessages.OpenTypeAction_dialogMessage;
    }

    protected void chooseSuperInterfaces() {
        Shell parent = DLTKUIPlugin.getActiveWorkbenchShell();
        VjoOpenTypeSelectionDialog dialog = new VjoOpenTypeSelectionDialog(parent, true, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), this.getSearchScope(), 0, this.getUILanguageToolkit());
        dialog.setTitle(this.getSatisfierDialogTitle());
        dialog.setMessage(this.getOpenTypeDialogMessage());
        VjoOpenTypeSelectionDialog.setShownTypeFlag(2);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = null;
            int i = 0;
            while (i < types.length) {
                type = (IType)types[i];
                this.addSuperInterface(Util.toJstType((IType)type));
                ++i;
            }
        }
    }

    public VjoSourceModulePage() {
        super("wizardPage");
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
        String[] stringArray = new String[3];
        stringArray[0] = VjetWizardMessages.NewTypeWizardPage_interfaces_add;
        stringArray[2] = VjetWizardMessages.NewTypeWizardPage_interfaces_remove;
        String[] addButtons = stringArray;
        this.fSuperInterfacesDialogField = new ListDialogField(new IListAdapter(){

            public void customButtonPressed(ListDialogField field, int index) {
                if (field == VjoSourceModulePage.this.fSuperInterfacesDialogField) {
                    VjoSourceModulePage.this.chooseSuperInterfaces();
                    List interfaces = VjoSourceModulePage.this.fSuperInterfacesDialogField.getElements();
                    if (!interfaces.isEmpty()) {
                        Object element = interfaces.get(interfaces.size() - 1);
                        VjoSourceModulePage.this.fSuperInterfacesDialogField.editElement(element);
                    }
                }
            }

            public void doubleClicked(ListDialogField field) {
            }

            public void selectionChanged(ListDialogField field) {
            }
        }, addButtons, (ILabelProvider)new InterfacesListLabelProvider());
        this.fSuperInterfacesDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
            }
        });
        this.fSuperInterfacesDialogField.setTableColumns(new ListDialogField.ColumnsDescription(1, false));
        if ("itype".equalsIgnoreCase(this.getPageType())) {
            this.fSuperInterfacesDialogField.setLabelText(VjetWizardMessages.NewTypeWizardPage_interfaces_ifc_label);
        } else {
            this.fSuperInterfacesDialogField.setLabelText(VjetWizardMessages.NewTypeWizardPage_interfaces_class_label);
        }
        this.fSuperInterfacesDialogField.setRemoveButtonIndex(2);
        PackageFieldAdapter adapter = new PackageFieldAdapter();
        this.packageDialogField = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.packageDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.packageDialogField.setLabelText(VjetWizardMessages.NewTypeWizardPage_package_label);
        this.packageDialogField.setButtonLabel(VjetWizardMessages.NewTypeWizardPage_package_button);
        this.fCurrPackageCompletionProcessor = new VjoPackageCompletionProcessor();
        this.packageStatus = new StatusInfo();
        this.sourceMoudleStatus = new StatusInfo();
        this.fileDialogField = new StringDialogField();
        this.fileDialogField.setLabelText(VjetWizardMessages.VjoSourceModulePage_file);
        this.fileDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                VjoSourceModulePage.this.sourceMoudleStatus = VjoSourceModulePage.this.fileChanged();
                VjoSourceModulePage.this.handleFieldChanged(VjoSourceModulePage.FILE);
            }
        });
        String[] buttonNames1 = new String[]{VjetWizardMessages.WizardPage_modifiers_public, VjetWizardMessages.WizardPage_modifiers_default, VjetWizardMessages.WizardPage_modifiers_private, VjetWizardMessages.WizardPage_modifiers_protected};
        this.fAccMdfButtons = new SelectionButtonDialogFieldGroup(16, buttonNames1, 4);
        this.fAccMdfButtons.setLabelText(VjetWizardMessages.ClassCreationWizard_modifiers);
        this.fAccMdfButtons.setSelection(0, true);
        String[] buttonNames2 = new String[]{VjetWizardMessages.WizardPage_modifiers_abstract, VjetWizardMessages.WizardPage_modifiers_final};
        this.fOtherMdfButtons = new SelectionButtonDialogFieldGroup(32, buttonNames2, 4);
        this.fOtherMdfButtons.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == VjoSourceModulePage.this.fOtherMdfButtons || field == VjoSourceModulePage.this.fAccMdfButtons) {
                    VjoSourceModulePage.this.modifiersChanged();
                    VjoSourceModulePage.this.handleFieldChanged("Modifier");
                }
            }
        });
        if (this instanceof VjoClassCreationPage) {
            this.fOtherMdfButtons.enableSelectionButton(0, true);
        } else {
            this.fOtherMdfButtons.enableSelectionButton(0, false);
        }
        this.fAccMdfButtons.enableSelectionButton(0, true);
        this.fAccMdfButtons.enableSelectionButton(1, true);
        this.fAccMdfButtons.enableSelectionButton(2, true);
        this.fAccMdfButtons.enableSelectionButton(3, true);
        String pageType = this.getPageType();
        if (pageType.length() > 0 && ("ctype".equals(pageType) || "etype".equals(pageType) || "itype".equals(pageType) || "mtype".equals(this.getPageType()))) {
            this.fAccMdfButtons.enableSelectionButton(3, false);
            this.fAccMdfButtons.enableSelectionButton(2, false);
        }
    }

    protected String getPageType() {
        return "";
    }

    protected IStatus modifiersChanged() {
        StatusInfo status = new StatusInfo();
        String modifiers = this.getModifiers();
        if (modifiers.indexOf("abstract") > 0 && modifiers.indexOf("final") > 0) {
            status.setError(VjetWizardMessages.NewTypeWizardPage_error_ModifiersFinalAndAbstract);
        }
        return status;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if ("NewContainerWizardPage.container".equals(fieldName)) {
            IProjectFragment fragment = this.getProjectFragment();
            this.currentScriptFolder = fragment != null ? fragment.getScriptFolder("") : null;
            this.sourceMoudleStatus = this.fileChanged();
        }
        this.updateStatus(new IStatus[]{this.containerStatus, this.fileChanged(), this.modifiersChanged(), this.packageChanged()});
    }

    public ISourceModule createFile(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String fileName = this.getFileName();
        if (this.packageDialogField.getText().trim().length() == 0) {
            this.currPackageRoot = this.getProjectFragment().getScriptFolder("");
        }
        if (!this.currPackageRoot.exists()) {
            IProjectFragment root = this.getProjectFragment();
            String packName = this.packageDialogField.getText().trim();
            packName = packName.replace('.', '/');
            this.currPackageRoot = root.createScriptFolder(packName, true, monitor);
        }
        ISourceModule module = this.currPackageRoot.createSourceModule(fileName, this.getFileContent(), true, monitor);
        return module;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, 3);
        this.createPackageControls(composite, 3);
        this.createFileControls(composite, 3);
        if (!"otype".equals(this.getPageType())) {
            this.createSuperInterfacesControls(composite, 3);
        }
        this.createExtraControls(composite, 3);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        if ("itype".equals(this.getPageType())) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.vjet.eclipse.ui.new_interface_wizard_page_context");
        }
        if ("etype".equals(this.getPageType())) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.vjet.eclipse.ui.new_enum_wizard_page_context");
        }
        if ("mtype".equals(this.getPageType())) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.vjet.eclipse.ui.new_mixin_wizard_page_context");
        }
        if ("otype".equals(this.getPageType())) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.vjet.eclipse.ui.new_otype_wizard_page_context");
        }
    }

    protected void createCommentControl(Composite composite, int columns) {
        Link link = new Link(composite, 0);
        link.setText(VjetWizardMessages.NewTypeWizardPage_addcomment_description);
        link.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IProject project = VjoSourceModulePage.this.getProjectFragment().getResource().getProject();
                if (project != null) {
                    PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)VjoSourceModulePage.this.getShell(), null, (String)"code template id", null, null);
                    dialog.open();
                } else {
                    String title = VjetWizardMessages.NewTypeWizardPage_configure_templates_title;
                    String message = VjetWizardMessages.NewTypeWizardPage_configure_templates_message;
                    MessageDialog.openInformation((Shell)VjoSourceModulePage.this.getShell(), (String)title, (String)message);
                }
            }
        });
        link.setLayoutData((Object)new GridData(4, 2, false, false, columns, 1));
        this.fAddCommentButton = new SelectionButtonDialogField(32);
        this.fAddCommentButton.setLabelText(VjetWizardMessages.NewTypeWizardPage_addcomment_label);
        DialogField.createEmptySpace((Composite)composite);
        this.fAddCommentButton.doFillIntoGrid(composite, columns - 1);
        this.fUseAddCommentButtonValue = false;
    }

    protected void createExtraControls(Composite composite, int columns) {
    }

    protected String getFileText() {
        return this.fileDialogField.getText();
    }

    protected String getFileName() {
        String fileText = this.getFileText();
        String[] extensions = this.getFileExtensions();
        int i = 0;
        while (i < extensions.length) {
            String extension = extensions[i];
            if (extension.length() > 0 && fileText.endsWith("." + extension)) {
                return fileText;
            }
            ++i;
        }
        return String.valueOf(fileText) + "." + extensions[0];
    }

    protected String[] getFileExtensions() {
        String requiredNature = this.getRequiredNature();
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)requiredNature);
        String contentType = toolkit.getLanguageContentType();
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType type = manager.getContentType(contentType);
        if (type != null) {
            String[] extensions = type.getFileSpecs(8);
            return extensions;
        }
        return new String[]{""};
    }

    protected IScriptFolder chooseScriptFolder() {
        Object element;
        ElementListSelectionDialog dialog;
        block5: {
            ModelElementLabelProvider labelProvider = new ModelElementLabelProvider(ModelElementLabelProvider.SHOW_DEFAULT);
            dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setIgnoreCase(false);
            dialog.setTitle(Messages.NewSourceModulePage_selectScriptFolder);
            dialog.setMessage(Messages.NewSourceModulePage_selectScriptFolder);
            dialog.setEmptyListMessage(Messages.NewSourceModulePage_noFoldersAvailable);
            IProjectFragment projectFragment = this.getProjectFragment();
            if (projectFragment != null) {
                try {
                    dialog.setElements((Object[])projectFragment.getChildren());
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block5;
                    e.printStackTrace();
                }
            }
        }
        dialog.setHelpAvailable(false);
        if (this.currentScriptFolder != null) {
            dialog.setInitialSelections(new Object[]{this.currentScriptFolder});
        }
        if (dialog.open() == 0 && (element = dialog.getFirstResult()) instanceof IScriptFolder) {
            return (IScriptFolder)element;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    public void setFileText(String text) {
        this.fileDialogField.setText(text);
    }

    protected void setFocus() {
        this.fileDialogField.setFocus();
    }

    protected abstract String getPageTitle();

    protected abstract String getPageDescription();

    protected String getFileContent() {
        return "";
    }

    public static class InterfaceWrapper {
        public IJstType itype;

        public InterfaceWrapper(IJstType interfaceName) {
            this.itype = interfaceName;
        }

        public IJstType getSourceType() {
            return this.itype;
        }

        public int hashCode() {
            return this.itype.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass()) && ((InterfaceWrapper)obj).itype.getName().equals(this.itype.getName());
        }

        public String toString() {
            return this.itype.getName();
        }
    }

    private static class InterfacesListLabelProvider
    extends LabelProvider {
        private Image fInterfaceImage = JavaPluginImages.get((String)"org.eclipse.jdt.ui.int_obj.gif");

        public String getText(Object element) {
            return ((InterfaceWrapper)element).toString();
        }

        public Image getImage(Object element) {
            return this.fInterfaceImage;
        }
    }

    private class PackageFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private PackageFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            VjoSourceModulePage.this.packageChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            VjoSourceModulePage.this.packageDialogFieldChanged(field);
        }
    }
}

