/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.refactoring.rename;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.dltk.mod.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.mod.internal.ui.refactoring.reorg.RenameInputWizardPage;
import org.eclipse.dltk.mod.internal.ui.util.RowLayouter;
import org.eclipse.dltk.mod.ui.util.ExceptionHandler;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vjet.eclipse.internal.ui.refactoring.rename.RenameTypeWizard;
import org.eclipse.vjet.eclipse.internal.ui.refactoring.rename.RenameVjoTypeProcessor;

class RenameTypeWizardInputPage
extends RenameInputWizardPage {
    private Button fUpdateSimilarElements;
    private int fSelectedStrategy;
    private Link fUpdateSimilarElementsButton;

    public RenameTypeWizardInputPage(String description, String contextHelpId, boolean isLastUserPage, String initialValue) {
        super(description, contextHelpId, isLastUserPage, initialValue);
    }

    protected void addAdditionalOptions(Composite composite, RowLayouter layouter) {
        if (this.getSimilarElementUpdating() == null || !this.getSimilarElementUpdating().canEnableSimilarDeclarationUpdating()) {
            return;
        }
        try {
            this.fSelectedStrategy = this.getRefactoringSettings().getInt("updateSimilarElementsMatchStrategy");
        }
        catch (NumberFormatException numberFormatException) {
            this.fSelectedStrategy = this.getSimilarElementUpdating().getMatchStrategy();
        }
        this.getSimilarElementUpdating().setMatchStrategy(this.fSelectedStrategy);
        Composite c = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        c.setLayout((Layout)layout);
        this.fUpdateSimilarElements = new Button(c, 32);
        this.fUpdateSimilarElements.setText(RefactoringMessages.RenameTypeWizardInputPage_update_similar_elements);
        boolean updateSimilarElements = this.getBooleanSetting("updateSimilarElements", this.getSimilarElementUpdating().getUpdateSimilarDeclarations());
        this.fUpdateSimilarElements.setSelection(updateSimilarElements);
        this.getSimilarElementUpdating().setUpdateSimilarDeclarations(updateSimilarElements);
        this.fUpdateSimilarElements.setLayoutData((Object)new GridData(768));
        this.fUpdateSimilarElements.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RenameTypeWizardInputPage.this.getSimilarElementUpdating().setUpdateSimilarDeclarations(RenameTypeWizardInputPage.this.fUpdateSimilarElements.getSelection());
                RenameTypeWizardInputPage.this.fUpdateSimilarElementsButton.setEnabled(RenameTypeWizardInputPage.this.fUpdateSimilarElements.getSelection());
            }
        });
        this.fUpdateSimilarElementsButton = new Link(c, 0);
        GridData d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 131072;
        this.fUpdateSimilarElementsButton.setText(RefactoringMessages.RenameTypeWizardInputPage_update_similar_elements_configure);
        this.fUpdateSimilarElementsButton.setEnabled(updateSimilarElements);
        this.fUpdateSimilarElementsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Assert.isTrue((boolean)false, (String)"Not support update similar elements");
            }
        });
        this.fUpdateSimilarElementsButton.setLayoutData((Object)d);
        GridData forC = new GridData();
        forC.grabExcessHorizontalSpace = true;
        forC.horizontalAlignment = 4;
        forC.horizontalSpan = 2;
        c.setLayoutData((Object)forC);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        layouter.perform((Control)separator);
    }

    public void dispose() {
        if (this.saveSettings() && this.fUpdateSimilarElements != null && !this.fUpdateSimilarElements.isDisposed() && this.fUpdateSimilarElements.isEnabled()) {
            this.saveBooleanSetting("updateSimilarElements", this.fUpdateSimilarElements);
            this.getRefactoringSettings().put("updateSimilarElementsMatchStrategy", this.fSelectedStrategy);
        }
        super.dispose();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private ISimilarDeclarationUpdating getSimilarElementUpdating() {
        return (ISimilarDeclarationUpdating)this.getRefactoring().getAdapter(ISimilarDeclarationUpdating.class);
    }

    protected boolean performFinish() {
        boolean returner = super.performFinish();
        if (!returner && this.getContainer().getCurrentPage() != null) {
            this.getContainer().getCurrentPage().setPreviousPage((IWizardPage)this);
        }
        return returner;
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage;
        RenameTypeWizard wizard = (RenameTypeWizard)this.getWizard();
        if (wizard.isRenameType()) {
            final RenameVjoTypeProcessor renameTypeProcessor = wizard.getRenameTypeProcessor();
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) throws InterruptedException {
                        try {
                            try {
                                renameTypeProcessor.initializeReferences(pm);
                            }
                            catch (OperationCanceledException operationCanceledException) {
                                throw new InterruptedException();
                            }
                            catch (CoreException e) {
                                ExceptionHandler.handle((CoreException)e, (String)RefactoringMessages.RenameTypeWizard_defaultPageTitle, (String)RefactoringMessages.RenameTypeWizard_unexpected_exception);
                                pm.done();
                            }
                        }
                        finally {
                            pm.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)RefactoringMessages.RenameTypeWizard_defaultPageTitle, (String)RefactoringMessages.RenameTypeWizard_unexpected_exception);
            }
            catch (InterruptedException interruptedException) {
                return this;
            }
            nextPage = renameTypeProcessor.hasSimilarElementsToRename() ? super.getNextPage() : this.computeSuccessorPage();
        } else {
            nextPage = this.computeSuccessorPage();
        }
        nextPage.setPreviousPage((IWizardPage)this);
        return nextPage;
    }
}

