/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.editor.semantic.highlighting.SemanticHighlightingPresenter;
import org.eclipse.dltk.mod.internal.ui.text.IScriptReconcilingListener;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.editor.highlighting.HighlightedPosition;
import org.eclipse.dltk.mod.ui.editor.highlighting.HighlightingStyle;
import org.eclipse.dltk.mod.ui.editor.highlighting.IHighlightedPositionFactory;
import org.eclipse.dltk.mod.ui.editor.highlighting.ISemanticHighlighter;
import org.eclipse.dltk.mod.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.dltk.mod.ui.text.ScriptTextTools;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.ts.GenericVisitor;
import org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting.SemanticToken;
import org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting.VjoSemanticHighlighting;

public class VjoSemanticHighlightingReconciler
implements IScriptReconcilingListener,
ITextInputListener {
    private ScriptEditor fEditor;
    private ISourceViewer fSourceViewer;
    private SemanticHighlightingPresenter fPresenter;
    private SemanticHighlighting[] fSemanticHighlightings;
    private HighlightingStyle[] fHighlightings;
    private Job fJob;
    private final Object fJobLock = new Object();
    private final Object fReconcileLock = new Object();
    private boolean fIsReconciling = false;
    private List fAddedPositions = new ArrayList();
    private List fRemovedPositions = new ArrayList();
    private int fNOfRemovedPositions;
    private SemanticHighlightingPresenter fJobPresenter;
    private SemanticHighlighting[] fJobSemanticHighlightings;
    private HighlightingStyle[] fJobHighlightings;
    private ISemanticHighlighter positionUpdater;
    private PositionCollector fCollector = new PositionCollector();

    public void aboutToBeReconciled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconciled(ISourceModule ast, boolean forced, IProgressMonitor progressMonitor) {
        Object object = this.fReconcileLock;
        synchronized (object) {
            if (this.fIsReconciling) {
                return;
            }
            this.fIsReconciling = true;
        }
        this.fJobPresenter = this.fPresenter;
        this.fJobSemanticHighlightings = this.fSemanticHighlightings;
        this.fJobHighlightings = this.fHighlightings;
        try {
            block23: {
                block22: {
                    if (this.fJobPresenter == null || this.fJobSemanticHighlightings == null || this.fJobHighlightings == null) break block22;
                    this.fJobPresenter.setCanceled(progressMonitor.isCanceled());
                    if (ast != null && !this.fJobPresenter.isCanceled()) break block23;
                }
                this.fJobPresenter = null;
                this.fJobSemanticHighlightings = null;
                this.fJobHighlightings = null;
                Object object2 = this.fReconcileLock;
                synchronized (object2) {
                    this.fIsReconciling = false;
                    return;
                }
            }
            this.startReconcilingPositions();
            if (!this.fJobPresenter.isCanceled()) {
                this.reconcilePositions((IJstNode)((IVjoSourceModule)ast).getJstType());
            }
            TextPresentation textPresentation = null;
            HighlightedPosition[] addedPositions = this.fAddedPositions.toArray(new HighlightedPosition[this.fAddedPositions.size()]);
            HighlightedPosition[] removedPositions = this.fRemovedPositions.toArray(new HighlightedPosition[this.fRemovedPositions.size()]);
            if (!this.fJobPresenter.isCanceled()) {
                textPresentation = this.fJobPresenter.createPresentation(addedPositions, removedPositions);
            }
            if (!this.fJobPresenter.isCanceled()) {
                this.updatePresentation(textPresentation, addedPositions, removedPositions);
            }
            this.stopReconcilingPositions();
        }
        catch (Throwable throwable) {
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            this.fJobHighlightings = null;
            Object object3 = this.fReconcileLock;
            synchronized (object3) {
                this.fIsReconciling = false;
                throw throwable;
            }
        }
        this.fJobPresenter = null;
        this.fJobSemanticHighlightings = null;
        this.fJobHighlightings = null;
        Object object4 = this.fReconcileLock;
        synchronized (object4) {
            this.fIsReconciling = false;
            return;
        }
    }

    private void startReconcilingPositions() {
        this.fJobPresenter.addAllPositions(this.fRemovedPositions);
        this.fNOfRemovedPositions = this.fRemovedPositions.size();
    }

    private void stopReconcilingPositions() {
        this.fRemovedPositions.clear();
        this.fNOfRemovedPositions = 0;
        this.fAddedPositions.clear();
    }

    private void reconcilePositions(IJstNode jstNode) {
        jstNode.accept((IJstNodeVisitor)this.fCollector);
        List oldPositions = this.fRemovedPositions;
        ArrayList newPositions = new ArrayList(this.fNOfRemovedPositions);
        int i = 0;
        int n = oldPositions.size();
        while (i < n) {
            Object current = oldPositions.get(i);
            if (current != null) {
                newPositions.add(current);
            }
            ++i;
        }
        this.fRemovedPositions = newPositions;
    }

    private void updatePresentation(TextPresentation textPresentation, HighlightedPosition[] addedPositions, HighlightedPosition[] removedPositions) {
        Runnable runnable = this.fJobPresenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        ScriptEditor editor = this.fEditor;
        if (editor == null) {
            return;
        }
        IWorkbenchPartSite site = editor.getSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    public void install(ScriptEditor editor, ISourceViewer sourceViewer, SemanticHighlightingPresenter presenter, SemanticHighlighting[] semanticHighlightings, HighlightingStyle[] highlightings) {
        this.fPresenter = presenter;
        this.fSemanticHighlightings = semanticHighlightings;
        this.fHighlightings = highlightings;
        ScriptTextTools textTools = editor.getTextTools();
        if (textTools != null) {
            this.positionUpdater = textTools.getSemanticPositionUpdater();
            this.positionUpdater.initialize((IHighlightedPositionFactory)this.fPresenter, this.fHighlightings);
        }
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        this.fEditor.addReconcileListener((IScriptReconcilingListener)this);
    }

    public void uninstall() {
        if (this.fPresenter != null) {
            this.fPresenter.setCanceled(true);
        }
        if (this.fEditor != null) {
            this.fEditor.removeReconcileListener((IScriptReconcilingListener)this);
            this.fEditor = null;
        } else {
            this.fSourceViewer.removeTextInputListener((ITextInputListener)this);
        }
        this.fSourceViewer = null;
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
        this.fPresenter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        IModelElement element = this.fEditor.getInputModelElement();
        Object object = this.fJobLock;
        synchronized (object) {
            final Job oldJob = this.fJob;
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
            if (element != null) {
                this.fJob = new Job(DLTKEditorMessages.SemanticHighlighting_job){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        if (oldJob != null) {
                            try {
                                oldJob.join();
                            }
                            catch (InterruptedException e) {
                                DLTKUIPlugin.log((Throwable)e);
                                return Status.CANCEL_STATUS;
                            }
                        }
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ISourceModule code = DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(VjoSemanticHighlightingReconciler.this.fEditor.getEditorInput());
                        VjoSemanticHighlightingReconciler.this.reconciled(code, false, monitor);
                        Object object = VjoSemanticHighlightingReconciler.this.fJobLock;
                        synchronized (object) {
                            if (VjoSemanticHighlightingReconciler.this.fJob == this) {
                                VjoSemanticHighlightingReconciler.this.fJob = null;
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                this.fJob.setSystem(true);
                this.fJob.setPriority(50);
                this.fJob.schedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        Object object = this.fJobLock;
        synchronized (object) {
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput != null) {
            this.scheduleJob();
        }
    }

    public void refresh() {
        this.scheduleJob();
    }

    private class PositionCollector
    extends GenericVisitor {
        private SemanticToken fToken = new SemanticToken();

        private PositionCollector() {
        }

        public void visit(JstMethod node) {
            this.fToken.update(node);
            int i = 0;
            int n = VjoSemanticHighlightingReconciler.this.fJobSemanticHighlightings.length;
            while (i < n) {
                JstSource source;
                VjoSemanticHighlighting semanticHighlighting = (VjoSemanticHighlighting)VjoSemanticHighlightingReconciler.this.fJobSemanticHighlightings[i];
                if (VjoSemanticHighlightingReconciler.this.fJobHighlightings[i].isEnabled() && semanticHighlighting.consumes(this.fToken) && (source = node.getName().getSource()) != null) {
                    int offset = source.getStartOffSet();
                    int length = source.getLength();
                    if (offset <= -1 || length <= 0) break;
                    this.addPosition(offset, length, VjoSemanticHighlightingReconciler.this.fJobHighlightings[i]);
                    break;
                }
                ++i;
            }
            this.fToken.clear();
        }

        private void addPosition(int offset, int length, HighlightingStyle highlighting) {
            boolean isExisting = false;
            int i = 0;
            int n = VjoSemanticHighlightingReconciler.this.fRemovedPositions.size();
            while (i < n) {
                HighlightedPosition position = (HighlightedPosition)VjoSemanticHighlightingReconciler.this.fRemovedPositions.get(i);
                if (position != null && position.isEqual(offset, length, highlighting)) {
                    isExisting = true;
                    VjoSemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                    VjoSemanticHighlightingReconciler vjoSemanticHighlightingReconciler = VjoSemanticHighlightingReconciler.this;
                    vjoSemanticHighlightingReconciler.fNOfRemovedPositions = vjoSemanticHighlightingReconciler.fNOfRemovedPositions - 1;
                    break;
                }
                ++i;
            }
            if (!isExisting) {
                HighlightedPosition position = VjoSemanticHighlightingReconciler.this.fJobPresenter.createHighlightedPosition(offset, length, highlighting);
                VjoSemanticHighlightingReconciler.this.fAddedPositions.add(position);
            }
        }
    }
}

