/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.editor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.dltk.mod.core.IBuffer;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IPackageDeclaration;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.ISourceReference;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.PreferencesLookupDelegate;
import org.eclipse.dltk.mod.internal.core.JSSourceField;
import org.eclipse.dltk.mod.internal.core.JSSourceMethod;
import org.eclipse.dltk.mod.internal.core.JSSourceType;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.internal.ui.actions.FoldingActionGroup;
import org.eclipse.dltk.mod.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.mod.internal.ui.editor.ExternalFileEditorInput;
import org.eclipse.dltk.mod.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptOutlinePage;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.mod.internal.ui.text.PreferencesAdapter;
import org.eclipse.dltk.mod.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.mod.ui.text.ScriptTextTools;
import org.eclipse.dltk.mod.ui.text.folding.IFoldingStructureProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IImportDeclaration;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.VjoLanguageToolkit;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoSearchOccurrenceEngine;
import org.eclipse.vjet.eclipse.internal.codeassist.select.VjoSelectionEngine;
import org.eclipse.vjet.eclipse.internal.ui.actions.RemoveOccurrenceAnnotations;
import org.eclipse.vjet.eclipse.internal.ui.actions.ToggleMarkOccurrencesAction;
import org.eclipse.vjet.eclipse.internal.ui.dialogs.UnknownContentTypeDialog;
import org.eclipse.vjet.eclipse.internal.ui.editor.EnableVjoNatureDialog;
import org.eclipse.vjet.eclipse.internal.ui.editor.JavaScriptEditor;
import org.eclipse.vjet.eclipse.internal.ui.editor.TogglePresentationAction;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditorMessages;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoOutlinePage;
import org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting.VjoSemanticHighlightingManager;
import org.eclipse.vjet.eclipse.internal.ui.text.CommentFormattingContext;
import org.eclipse.vjet.eclipse.internal.ui.text.VjoSourceViewerConfiguration;
import org.eclipse.vjet.eclipse.internal.ui.text.folding.VjoFoldingStructureProvider;
import org.eclipse.vjet.eclipse.ui.VjetUIImages;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;
import org.eclipse.vjet.eclipse.ui.VjetUIUtils;
import org.eclipse.vjet.eclipse.ui.actions.VjoAddCommentAction;
import org.eclipse.vjet.eclipse.ui.actions.nature.AddVjoNaturePolicyManager;
import org.eclipse.vjet.eclipse.ui.actions.nature.IAddVjoNaturePolicy;
import org.eclipse.vjet.eclipse.ui.viewsupport.SelectionListenerWithJSTManager;

public class VjoEditor
extends JavaScriptEditor {
    public static final String EDITOR_ID = "org.eclipse.vjet.ui.VjetJsEditor";
    private static final String VJO_CONTENT_TYPE = "org.eclipse.dltk.mod.vjoContentType";
    private static final String VJO_EDITOR_CNTX_MENU_ID = "#VjoEditorContext";
    protected VjoSemanticHighlightingManager fSemanticManager;
    IFoldingStructureProvider m_foldingProvider = null;
    private ActivationListener m_activationListener = new ActivationListener();
    private ISelection m_forcedMarkOccurrencesSelection;
    private boolean m_isArchiveFile;
    private boolean m_markFieldOccurrences;
    private boolean m_markLocalVariableTypeOccurrences;
    private boolean m_markMethodOccurrences;
    private boolean m_markOccurrenceAnnotations;
    private long m_markOccurrenceModificationStamp = -1L;
    private IRegion m_markOccurrenceTargetRegion;
    private Annotation[] m_occurrenceAnnotations = null;
    private OccurrencesFinderJob m_occurrencesFinderJob;
    private OccurrencesFinderJobCanceler m_occurrencesFinderJobCanceler;
    private SelectionListenerWithJST m_postSelectionListenerWithAST;
    private boolean m_stickyOccurrenceAnnotations;
    private ToggleMarkOccurrencesAction m_toggleMarkOccurrencesAction;
    private TogglePresentationAction m_togglePresentation;

    protected ISourceViewer createScriptSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles, IPreferenceStore store) {
        return new JsSourceViewer(parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, store);
    }

    public static IContentType getDefaultContentType() {
        return Platform.getContentTypeManager().getContentType(VJO_CONTENT_TYPE);
    }

    @Override
    public void createActions() {
        super.createActions();
        RemoveOccurrenceAnnotations action = new RemoveOccurrenceAnnotations(this);
        action.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.remove.occurrence.annotations");
        this.setAction("RemoveOccurrenceAnnotations", (IAction)action);
        this.m_togglePresentation = new TogglePresentationAction((ITextEditor)this);
        this.m_togglePresentation.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.toggleMarkOccurrences");
        this.setAction("TogglePresentationAction", (IAction)this.m_togglePresentation);
        this.m_toggleMarkOccurrencesAction = new ToggleMarkOccurrencesAction((ITextEditor)this);
        this.m_toggleMarkOccurrencesAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.toggle.presentation");
        this.setAction("ToggleMarkOccurrencesAction", (IAction)this.m_toggleMarkOccurrencesAction);
        IEditorSite site = this.getEditorSite();
        IActionBars bars = site.getActionBars();
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.m_togglePresentation);
        bars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.edit.text.script.toggleMarkOccurrences", (IAction)this.m_toggleMarkOccurrencesAction);
        VjoAddCommentAction addCommentAction = new VjoAddCommentAction(this);
        addCommentAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.add.javadoc.comment");
        this.setAction("org.eclipse.dltk.mod.ui.actions.AddBlockComment", (IAction)addCommentAction);
        this.markAsStateDependentAction("org.eclipse.dltk.mod.ui.actions.AddBlockComment", true);
        this.markAsSelectionDependentAction("org.eclipse.dltk.mod.ui.actions.AddBlockComment", true);
        bars.setGlobalActionHandler("org.eclipse.vjet.eclipse.ui.AddJavaDocComment", (IAction)addCommentAction);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.installOccurrencesFinder(false);
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.m_activationListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.vjet.eclipse.ui.vjet_editor_context");
    }

    @Override
    public void dispose() {
        super.dispose();
        this.uninstallSemanticHighlighting();
    }

    public void doSelectionChanged(SelectionChangedEvent event) {
        super.doSelectionChanged(event);
        if (event.getSelection() != null) {
            this.m_forcedMarkOccurrencesSelection = event.getSelection();
            if (this.m_forcedMarkOccurrencesSelection instanceof ITextSelection) {
                this.updateOccurrenceAnnotations((ITextSelection)this.m_forcedMarkOccurrencesSelection, this.getInputModelElement());
            } else if (this.m_forcedMarkOccurrencesSelection instanceof ITreeSelection) {
                if (this.getSelectionProvider() == null || this.getSelectionProvider().getSelection() == null) {
                    return;
                }
                ISelection editorSelection = this.getSelectionProvider().getSelection();
                if (editorSelection instanceof ITextSelection) {
                    this.m_forcedMarkOccurrencesSelection = (ITextSelection)editorSelection;
                    this.updateOccurrenceAnnotations((ITextSelection)editorSelection, this.getInputModelElement());
                }
            }
        }
    }

    public IModelElement getInputModelElement() {
        IEditorInput input = this.getEditorInput();
        IModelElement element = super.getInputModelElement();
        if (element != null) {
            return element;
        }
        if (input instanceof ExternalFileEditorInput) {
            return ((ExternalFileEditorInput)input).getModelElement();
        }
        return element;
    }

    @Override
    public IDLTKLanguageToolkit getLanguageToolkit() {
        return VjoLanguageToolkit.getDefault();
    }

    @Override
    public ScriptTextTools getTextTools() {
        return VjetUIPlugin.getDefault().getTextTools();
    }

    public Image getTitleImage() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof ExternalFileEditorInput || input instanceof ExternalStorageEditorInput) {
            return VjetUIImages.getImage("IMAGE_BINARY_EDITOR_TITLE");
        }
        IModelElement element = this.getInputModelElement();
        if (element == null || !CodeassistUtils.isModuleInBuildPath((IModelElement)element)) {
            return VjetUIImages.getImage("IMAGE_OUTOFPATH_EDITOR_TITLE");
        }
        return super.getTitleImage();
    }

    public boolean isDirty() {
        if (this.m_isArchiveFile) {
            return false;
        }
        return super.isDirty();
    }

    public boolean isEditable() {
        boolean bol = super.isEditable();
        if (!bol) {
            return bol;
        }
        IEditorInput input = this.getEditorInput();
        if (input instanceof ExternalFileEditorInput) {
            return false;
        }
        if (input instanceof org.eclipse.dltk.mod.internal.debug.ui.ExternalFileEditorInput) {
            return false;
        }
        return bol;
    }

    public boolean isMarkingOccurrences() {
        return this.m_markOccurrenceAnnotations;
    }

    public void refreshOutlinePage() {
        TreeViewer outlineViewer;
        ScriptOutlinePage outlinePage = this.getOutlinePage();
        if (outlinePage != null && (outlineViewer = outlinePage.getOutlineViewer()) != null) {
            outlineViewer.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOccurrenceAnnotations() {
        this.m_markOccurrenceModificationStamp = -1L;
        this.m_markOccurrenceTargetRegion = null;
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.m_occurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.m_occurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.m_occurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.m_occurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.m_occurrenceAnnotations = null;
        }
    }

    protected ISourceReference computeHighlightRangeSourceReference() {
        return super.computeHighlightRangeSourceReference();
    }

    @Override
    protected FoldingActionGroup createFoldingActionGroup() {
        return new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getViewer(), VjetUIPlugin.getDefault().getPreferenceStore());
    }

    @Override
    protected ScriptOutlinePage doCreateOutlinePage() {
        return new VjoOutlinePage(this, VjetUIPlugin.getDefault().getPreferenceStore());
    }

    protected void doUpdateOccurrenceAnnotations(ITextSelection selection, IModelElement astRoot) {
        if (this.m_occurrencesFinderJob != null) {
            this.m_occurrencesFinderJob.cancel();
        }
        if (!this.m_markOccurrenceAnnotations) {
            return;
        }
        if (astRoot == null || selection == null) {
            return;
        }
        if (this.getSourceViewer() == null) {
            return;
        }
        IDocument document = this.getSourceViewer().getDocument();
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension4) {
            int offset = selection.getOffset();
            long currentModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
            if (this.m_markOccurrenceTargetRegion != null && currentModificationStamp == this.m_markOccurrenceModificationStamp && this.m_markOccurrenceTargetRegion.getOffset() <= offset && offset <= this.m_markOccurrenceTargetRegion.getOffset() + this.m_markOccurrenceTargetRegion.getLength()) {
                return;
            }
            offset = CodeassistUtils.findWordOffset((char[])document.get().toCharArray(), (int)offset);
            this.m_markOccurrenceTargetRegion = ScriptWordFinder.findWord((IDocument)document, (int)offset);
            this.m_markOccurrenceModificationStamp = currentModificationStamp;
        }
        if (!(astRoot instanceof VjoSourceModule) || this.m_markOccurrenceTargetRegion == null) {
            return;
        }
        VjoSourceModule vjoSourceModule = (VjoSourceModule)astRoot;
        VjoSelectionEngine vjoSelectionEngine = VjetUIUtils.getSelectionEngine();
        if (vjoSelectionEngine == null) {
            return;
        }
        IJstNode jstNode = vjoSelectionEngine.convertSelection2JstNode((org.eclipse.dltk.mod.compiler.env.ISourceModule)vjoSourceModule, selection.getOffset(), selection.getOffset() + selection.getLength());
        IJstType scopeTree = vjoSourceModule.getJstType();
        if (scopeTree == null) {
            scopeTree = CodeassistUtils.getJstType((IVjoSourceModule)vjoSourceModule);
        }
        if (jstNode == null) {
            if (!this.m_stickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        if (scopeTree == null) {
            return;
        }
        if (!this.isNeedOccurrencesMarker(vjoSourceModule, selection)) {
            return;
        }
        boolean isEnabled = this.isEnableMarkOccurences(jstNode);
        if (!isEnabled) {
            if (!this.m_stickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        List matches = VjoSearchOccurrenceEngine.findOccurrence((IJstNode)jstNode, (IJstNode)scopeTree);
        if (matches == null || matches.isEmpty()) {
            if (!this.m_stickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        this.m_occurrencesFinderJob = new OccurrencesFinderJob(document, this.getPositions(matches), (ISelection)selection);
        this.m_occurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    protected IFoldingStructureProvider getFoldingStructureProvider() {
        if (this.m_foldingProvider == null) {
            this.m_foldingProvider = new VjoFoldingStructureProvider();
        }
        return this.m_foldingProvider;
    }

    @Override
    protected IPreferenceStore getScriptPreferenceStore() {
        return VjetUIPlugin.getDefault().getPreferenceStore();
    }

    @Override
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        ISourceViewer sourceViewer = this.getSourceViewer();
        boolean newBooleanValue = false;
        Object newValue = event.getNewValue();
        if (newValue != null) {
            newBooleanValue = Boolean.valueOf(newValue.toString());
        }
        if ("editor_folding_default_methods".equals(property)) {
            if (sourceViewer instanceof ProjectionViewer) {
                this.fProjectionModelUpdater.initialize();
            }
            return;
        }
        if ("editor_folding_default_imports".equals(property)) {
            if (sourceViewer instanceof ProjectionViewer) {
                this.fProjectionModelUpdater.initialize();
            }
            return;
        }
        if ("editor_folding_default_javadoc".equals(property)) {
            if (sourceViewer instanceof ProjectionViewer) {
                this.fProjectionModelUpdater.initialize();
            }
            return;
        }
        if ("editor_folding_default_headers".equals(property)) {
            if (sourceViewer instanceof ProjectionViewer) {
                this.fProjectionModelUpdater.initialize();
            }
            return;
        }
        if ("editor_folding_default_innertypes".equals(property)) {
            if (sourceViewer instanceof ProjectionViewer) {
                this.fProjectionModelUpdater.initialize();
            }
            return;
        }
        if ("markOccurrences".equals(property)) {
            if (newBooleanValue != this.m_markOccurrenceAnnotations) {
                this.m_markOccurrenceAnnotations = newBooleanValue;
                if (!this.m_markOccurrenceAnnotations) {
                    this.uninstallOccurrencesFinder();
                } else {
                    this.installOccurrencesFinder(true);
                }
            }
            return;
        }
        if ("markMethodOccurrences".equals(property)) {
            this.m_markMethodOccurrences = newBooleanValue;
            return;
        }
        if ("markFieldOccurrences".equals(property)) {
            this.m_markFieldOccurrences = newBooleanValue;
            return;
        }
        if ("markLocalVariableOccurrences".equals(property)) {
            this.m_markLocalVariableTypeOccurrences = newBooleanValue;
            return;
        }
        if ("stickyOccurrences".equals(property)) {
            this.m_stickyOccurrenceAnnotations = newBooleanValue;
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    @Override
    protected void initializeEditor() {
        IPreferenceStore store = this.createCombinedPreferenceStore(null);
        this.setPreferenceStore(store);
        this.m_markOccurrenceAnnotations = store.getBoolean("markOccurrences");
        this.m_stickyOccurrenceAnnotations = store.getBoolean("stickyOccurrences");
        this.m_markMethodOccurrences = store.getBoolean("markMethodOccurrences");
        this.m_markFieldOccurrences = store.getBoolean("markFieldOccurrences");
        this.m_markLocalVariableTypeOccurrences = store.getBoolean("markLocalVariableOccurrences");
        this.setEditorContextMenuId(VJO_EDITOR_CNTX_MENU_ID);
    }

    protected void installOccurrencesFinder(boolean forceUpdate) {
        this.m_markOccurrenceAnnotations = true;
        this.m_postSelectionListenerWithAST = new SelectionListenerWithJST();
        SelectionListenerWithJSTManager.getDefault().addListener((ITextEditor)this, this.m_postSelectionListenerWithAST);
        if (forceUpdate && this.getSelectionProvider() != null) {
            this.m_forcedMarkOccurrencesSelection = this.getSelectionProvider().getSelection();
            this.updateOccurrenceAnnotations((ITextSelection)this.m_forcedMarkOccurrencesSelection, this.getInputModelElement());
        }
        if (this.m_occurrencesFinderJobCanceler == null) {
            this.m_occurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.m_occurrencesFinderJobCanceler.install();
        }
    }

    protected void installSemanticHighlighting() {
        ScriptTextTools textTools = this.getTextTools();
        if (this.fSemanticManager == null && textTools != null) {
            this.fSemanticManager = new VjoSemanticHighlightingManager();
            this.fSemanticManager.install(this, (ScriptSourceViewer)this.getSourceViewer(), textTools.getColorManager(), this.getPreferenceStore());
        }
    }

    private void enableVjoNature() {
        Preferences pluginPreferences = VjetUIPlugin.getDefault().getPluginPreferences();
        boolean notShowDialog = pluginPreferences.getBoolean(VjoEditorMessages.VjoEditor_10);
        int result = pluginPreferences.getInt(VjoEditorMessages.VjoEditor_11);
        try {
            IProject project;
            boolean hasNature;
            String scheme;
            IEditorInput input = this.getEditorInput();
            if (input instanceof ExternalFileEditorInput) {
                return;
            }
            if (input instanceof org.eclipse.dltk.mod.internal.debug.ui.ExternalFileEditorInput) {
                return;
            }
            if (input instanceof FileEditorInput && (scheme = ((FileEditorInput)input).getFile().getLocationURI().getScheme()).equals("typespace")) {
                IProject project2 = this.getInputModelElement().getScriptProject().getProject();
                IAddVjoNaturePolicy policy = AddVjoNaturePolicyManager.getInstance().getPolicy(project2);
                policy.addVjoNature(project2);
            }
            if (!(hasNature = (project = this.getInputModelElement().getScriptProject().getProject()).hasNature("org.eclipse.vjet.core.nature")) && !notShowDialog) {
                String message = MessageFormat.format(VjoEditorMessages.VjoEditor_13, this.getInputModelElement().getElementName(), project.getName());
                EnableVjoNatureDialog md = new EnableVjoNatureDialog(Display.getCurrent().getActiveShell(), VjoEditorMessages.VjoEditor_12, this.getTitleImage(), message, 2, new String[]{VjoEditorMessages.VjoEditor_15, VjoEditorMessages.VjoEditor_16}, 0);
                result = md.open();
                if (md.isSelection()) {
                    pluginPreferences.setValue(VjoEditorMessages.VjoEditor_10, true);
                    pluginPreferences.setValue(VjoEditorMessages.VjoEditor_11, result);
                }
            }
            IModelElement inputModelElement = this.getInputModelElement();
            if (this.getSourceViewerConfiguration() instanceof VjoSourceViewerConfiguration && inputModelElement instanceof VjoSourceModule) {
                VjoSourceViewerConfiguration vsvc = (VjoSourceViewerConfiguration)this.getSourceViewerConfiguration();
                vsvc.setModule((ISourceModule)((VjoSourceModule)inputModelElement));
            }
            if (!hasNature && result == 0) {
                IAddVjoNaturePolicy policy = AddVjoNaturePolicyManager.getInstance().getPolicy(project);
                policy.addVjoNature(project);
            }
        }
        catch (CoreException coreException) {}
    }

    protected void internalDoSetInput(IEditorInput input) throws CoreException {
        super.internalDoSetInput(input);
        this.enableVjoNature();
        IModelElement original = this.getInputModelElement();
        if (original instanceof IVjoSourceModule && input instanceof ExternalStorageEditorInput) {
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer buffer = manager.getTextFileBuffer(((ExternalStorageEditorInput)input).getStorage().getFullPath(), LocationKind.NORMALIZE);
            IDocument doc = buffer.getDocument();
            IVjoSourceModule extSource = (IVjoSourceModule)original;
            IBuffer buf = extSource.getBuffer();
            String content = buf != null ? buf.getContents() : new String(extSource.getContentsAsCharArray());
            doc.set(content);
            this.m_isArchiveFile = true;
        } else if (!CodeassistUtils.isVjoSourceModule((IModelElement)original) && input instanceof FileEditorInput) {
            this.checkFileSuffix((FileEditorInput)input);
        }
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        String key = String.valueOf(this.getEditorSite().getId()) + ".internal.delegateSaveAs";
        store.setValue(key, true);
        super.performSaveAs(progressMonitor);
    }

    protected void setSelection(ISourceReference reference, boolean moveCursor) {
        block25: {
            ISelection selection;
            IModelElement parentOfParent;
            IModelElement parent;
            if (this.getSelectionProvider() == null) {
                return;
            }
            if ((reference instanceof JSSourceMethod || reference instanceof JSSourceField) && (parent = ((IModelElement)reference).getParent()) instanceof JSSourceType && (parentOfParent = parent.getParent()) instanceof VjoSourceModule) {
                IJstProperty jstProperty;
                IJstMethod jstMethod;
                IJstType jstType = ((VjoSourceModule)parentOfParent).getJstType();
                if (jstType == null) {
                    return;
                }
                if (reference instanceof JSSourceMethod && (jstMethod = jstType.getMethod(((JSSourceMethod)reference).getElementName())) instanceof JstProxyMethod) {
                    return;
                }
                if (reference instanceof JSSourceField && (jstProperty = jstType.getProperty(((JSSourceField)reference).getElementName())) instanceof JstProxyProperty) {
                    return;
                }
            }
            if ((selection = this.getSelectionProvider().getSelection()) instanceof TextSelection) {
                TextSelection textSelection = (TextSelection)selection;
                if (moveCursor && (textSelection.getOffset() != 0 || textSelection.getLength() != 0)) {
                    this.markInNavigationHistory();
                }
            }
            if (reference != null) {
                StyledText textWidget = null;
                ISourceViewer sourceViewer = this.getSourceViewer();
                if (sourceViewer != null) {
                    textWidget = sourceViewer.getTextWidget();
                }
                if (textWidget == null) {
                    return;
                }
                try {
                    String name;
                    ISourceRange range = null;
                    range = reference.getSourceRange();
                    if (range == null) {
                        return;
                    }
                    int offset = range.getOffset();
                    int length = range.getLength();
                    if (offset < 0 || length < 0) {
                        return;
                    }
                    this.setHighlightRange(offset, length, moveCursor);
                    if (!moveCursor) {
                        return;
                    }
                    offset = -1;
                    length = -1;
                    if (reference instanceof IMember) {
                        range = ((IMember)reference).getNameRange();
                        if (range != null) {
                            offset = range.getOffset();
                            length = range.getLength();
                        }
                    } else if ((reference instanceof IImportDeclaration || reference instanceof IPackageDeclaration) && (name = ((IModelElement)reference).getElementName()) != null && name.length() > 0) {
                        offset = range.getOffset();
                        length = range.getLength();
                    }
                    if (offset <= -1 || length <= 0) break block25;
                    try {
                        textWidget.setRedraw(false);
                        sourceViewer.revealRange(offset, length);
                        sourceViewer.setSelectedRange(offset, length);
                    }
                    finally {
                        textWidget.setRedraw(true);
                    }
                    this.markInNavigationHistory();
                }
                catch (ModelException modelException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (moveCursor) {
                this.resetHighlightRange();
                this.markInNavigationHistory();
            }
        }
    }

    protected void synchronizeOutlinePage(ISourceReference element, boolean checkIfOutlinePageActive) {
        super.synchronizeOutlinePage(element, checkIfOutlinePageActive);
    }

    protected void uninstallOccurrencesFinder() {
        this.m_markOccurrenceAnnotations = false;
        if (this.m_occurrencesFinderJob != null) {
            this.m_occurrencesFinderJob.cancel();
            this.m_occurrencesFinderJob = null;
        }
        if (this.m_occurrencesFinderJobCanceler != null) {
            this.m_occurrencesFinderJobCanceler.uninstall();
            this.m_occurrencesFinderJobCanceler = null;
        }
        if (this.m_postSelectionListenerWithAST != null) {
            SelectionListenerWithJSTManager.getDefault().removeListener((ITextEditor)this, this.m_postSelectionListenerWithAST);
            this.m_postSelectionListenerWithAST = null;
        }
        this.removeOccurrenceAnnotations();
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, IModelElement astRoot) {
        try {
            this.doUpdateOccurrenceAnnotations(selection, astRoot);
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    private void checkFileSuffix(FileEditorInput input) {
        IFile file = input.getFile();
        if (file != null && !VjoLanguageToolkit.isVjetContentType((IFile)file)) {
            this.logUnexpectedDocumentKind((IEditorInput)input);
        }
    }

    private IPreferenceStore createCombinedPreferenceStore(IEditorInput input) {
        ArrayList<Object> stores = new ArrayList<Object>(3);
        IScriptProject project = EditorUtility.getScriptProject((IEditorInput)input);
        if (project != null) {
            stores.add(new ScriptEditor.EclipsePreferencesAdapter((IScopeContext)new ProjectScope(project.getProject()), "org.eclipse.vjet.eclipse.ui"));
        }
        stores.add(VjetUIPlugin.getDefault().getPreferenceStore());
        stores.add(new PreferencesAdapter(VjetUIPlugin.getDefault().getPluginPreferences()));
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    private Position[] getPositions(List<VjoMatch> matches) {
        Position[] positions = new Position[matches.size()];
        int i = 0;
        for (VjoMatch currentMatch : matches) {
            positions[i++] = new Position(currentMatch.getOffset(), currentMatch.getLength());
        }
        return positions;
    }

    private boolean isEnableMarkOccurences(IJstNode jstNode) {
        boolean isEnabled = true;
        if (jstNode instanceof IJstMethod && !this.m_markMethodOccurrences) {
            isEnabled = false;
        } else if ((jstNode instanceof JstVars || jstNode instanceof JstArg) && !this.m_markLocalVariableTypeOccurrences) {
            isEnabled = false;
        } else if (jstNode instanceof IJstProperty && !this.m_markFieldOccurrences) {
            isEnabled = false;
        }
        return isEnabled;
    }

    private boolean isNeedOccurrencesMarker(VjoSourceModule sourceModule, ITextSelection textSelection) {
        String identifierName;
        BaseJstNode jstNode = JstUtil.getLeafNode((IJstType)sourceModule.getJstType(), (int)textSelection.getOffset(), (int)textSelection.getOffset());
        return !(jstNode instanceof JstIdentifier) || !"this".equals(identifierName = ((JstIdentifier)jstNode).getName()) && !"outer".equals(identifierName) && !"parent".equals(identifierName) && !"vj$".equals(identifierName);
    }

    private void logError(Exception e) {
        VjetPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.vjet.eclipse.core", 4, VjoEditorMessages.VjoEditor_21, (Throwable)e));
        System.err.println(e);
    }

    private void logUnexpectedDocumentKind(IEditorInput input) {
        if (VjetUIPlugin.getDefault().getPreferenceStore().getBoolean("showUnknownContentTypeMsg")) {
            UIJob job = new UIJob(VjoEditorMessages.StructuredTextEditor_0){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    UnknownContentTypeDialog dialog = new UnknownContentTypeDialog(VjoEditor.this.getSite().getShell(), VjetUIPlugin.getDefault().getPreferenceStore(), "showUnknownContentTypeMsg");
                    dialog.open();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        String name = null;
        name = input != null ? input.getName() : "input was null";
        VjetUIPlugin.log(2, "VJET editor being used on incorrect file type: " + name);
    }

    private void uninstallSemanticHighlighting() {
        if (this.fSemanticManager != null) {
            this.fSemanticManager.uninstall();
            this.fSemanticManager = null;
        }
    }

    private class ActivationListener
    implements IWindowListener {
        private ActivationListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == VjoEditor.this.getEditorSite().getWorkbenchWindow() && VjoEditor.this.m_markOccurrenceAnnotations && VjoEditor.this.isActivePart()) {
                VjoEditor.this.m_forcedMarkOccurrencesSelection = VjoEditor.this.getSelectionProvider().getSelection();
                CodeassistUtils.isVjoSourceModule((IModelElement)VjoEditor.this.getInputModelElement());
            }
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            if (window == VjoEditor.this.getEditorSite().getWorkbenchWindow() && VjoEditor.this.m_markOccurrenceAnnotations && VjoEditor.this.isActivePart()) {
                VjoEditor.this.removeOccurrenceAnnotations();
            }
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    class JsSourceViewer
    extends ScriptEditor.AdaptedSourceViewer {
        public JsSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean overviewRulerVisible, int styles, IPreferenceStore store) {
            super((ScriptEditor)VjoEditor.this, parent, verticalRuler, overviewRuler, overviewRulerVisible, styles, store);
        }

        public IFormattingContext createFormattingContext() {
            CommentFormattingContext context = new CommentFormattingContext();
            IModelElement inputJavaElement = VjoEditor.this.getInputModelElement();
            IScriptProject javaProject = inputJavaElement != null ? inputJavaElement.getScriptProject() : null;
            HashMap preferences = javaProject == null ? new HashMap(VjetPlugin.getOptions()) : this.getFomatterSettings(javaProject);
            context.setProperty("formatting.context.preferences", preferences);
            return context;
        }

        private Map getFomatterSettings(IScriptProject project) {
            Map defaultOptions = VjetPlugin.getOptions();
            PreferencesLookupDelegate context = new PreferencesLookupDelegate(project.getProject());
            String[] propertyNames = new String[defaultOptions.size()];
            propertyNames = defaultOptions.keySet().toArray(propertyNames);
            Hashtable<String, String> projectOptions = new Hashtable<String, String>(propertyNames.length);
            int i = 0;
            while (i < propertyNames.length) {
                String propertyName = propertyNames[i];
                String value = context.getString("org.eclipse.vjet.eclipse.core", propertyName);
                if (value != null && defaultOptions.containsKey(propertyName)) {
                    projectOptions.put(propertyName, value.trim());
                }
                ++i;
            }
            return new HashMap(projectOptions);
        }
    }

    class OccurrencesFinderJob
    extends Job {
        private boolean fCanceled;
        private IDocument fDocument;
        private Position[] fPositions;
        private ISelectionValidator fPostSelectionValidator;
        private IProgressMonitor fProgressMonitor;
        private ISelection fSelection;

        public OccurrencesFinderJob(IDocument document, Position[] positions, ISelection selection) {
            super(VjoEditorMessages.VjoEditor_markOccurrences_job_name);
            this.fCanceled = false;
            this.fDocument = document;
            this.fSelection = selection;
            this.fPositions = positions;
            if (VjoEditor.this.getSelectionProvider() instanceof ISelectionValidator) {
                this.fPostSelectionValidator = (ISelectionValidator)VjoEditor.this.getSelectionProvider();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            this.fProgressMonitor = progressMonitor;
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ISourceViewer textViewer = VjoEditor.this.getViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = VjoEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)VjoEditor.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fPositions.length;
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
            int i = 0;
            while (i < length) {
                block16: {
                    String message;
                    if (this.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Position position = this.fPositions[i];
                    try {
                        message = document.get(position.getOffset(), position.length);
                    }
                    catch (BadLocationException badLocationException) {
                        break block16;
                    }
                    annotationMap.put(new Annotation("org.eclipse.jdt.ui.occurrences", false, message), position);
                }
                ++i;
            }
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Object object = VjoEditor.this.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(VjoEditor.this.m_occurrenceAnnotations, annotationMap);
                } else {
                    VjoEditor.this.removeOccurrenceAnnotations();
                    for (Map.Entry mapEntry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                    }
                }
                VjoEditor.this.m_occurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled() {
            return this.fCanceled || this.fProgressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && VjoEditor.this.m_forcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (VjoEditor.this.m_occurrencesFinderJob != null) {
                VjoEditor.this.m_occurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }

        public void install() {
            ISourceViewer sourceViewer = VjoEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            ISourceViewer sourceViewer = VjoEditor.this.getSourceViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = VjoEditor.this.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)VjoEditor.this.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }
    }

    public class SelectionListenerWithJST {
        public void selectionChanged(IEditorPart part, ITextSelection selection, IModelElement astRoot) {
            VjoEditor.this.updateOccurrenceAnnotations(selection, astRoot);
        }
    }
}

