/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IAccessRule;
import org.eclipse.dltk.mod.core.IBuildpathAttribute;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.internal.launching.RuntimeBuildpathEntry;
import org.eclipse.dltk.mod.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.mod.launching.IRuntimeBuildpathEntryResolver;
import org.eclipse.dltk.mod.launching.LibraryLocation;
import org.eclipse.dltk.mod.launching.ScriptRuntime;

public class VjoSdkBuildpathEntryResolver
implements IRuntimeBuildpathEntryResolver {
    private static IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    public IRuntimeBuildpathEntry[] resolveRuntimeBuildpathEntry(IRuntimeBuildpathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        configuration.getAttribute("nature", null);
        IScriptProject project = AbstractScriptLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)configuration);
        EnvironmentManager.getEnvironment((IModelElement)project);
        return this.resolveLibraryLocations(null, entry.getBuildpathProperty());
    }

    private String getNatureFromProject(IScriptProject project) {
        return DLTKLanguageManager.getLanguageToolkit((IModelElement)project).getNatureId();
    }

    private String getEnvironmentFromProject(IScriptProject project) {
        return EnvironmentManager.getEnvironment((IModelElement)project).getId();
    }

    public IRuntimeBuildpathEntry[] resolveRuntimeBuildpathEntry(IRuntimeBuildpathEntry entry, IScriptProject project) throws CoreException {
        IInterpreterInstall interpreterEnvironment = null;
        if (entry.getType() != 4 || entry.getPath().segmentCount() <= 1) {
            interpreterEnvironment = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
        }
        if (interpreterEnvironment == null) {
            return new IRuntimeBuildpathEntry[0];
        }
        return this.resolveLibraryLocations(interpreterEnvironment, entry.getBuildpathProperty());
    }

    protected IRuntimeBuildpathEntry[] resolveLibraryLocations(IInterpreterInstall interpreter, int kind) {
        LibraryLocation[] libs = interpreter.getLibraryLocations();
        LibraryLocation[] defaultLibs = interpreter.getInterpreterInstallType().getDefaultLibraryLocations(interpreter.getInstallLocation(), interpreter.getEnvironmentVariables(), null);
        if (libs == null) {
            libs = defaultLibs;
        } else if (!VjoSdkBuildpathEntryResolver.isSamePaths(libs, defaultLibs)) {
            kind = 2;
        }
        ArrayList<IRuntimeBuildpathEntry> resolvedEntries = new ArrayList<IRuntimeBuildpathEntry>(libs.length);
        IEnvironment environment = interpreter.getEnvironment();
        int i = 0;
        while (i < libs.length) {
            IPath systemLibraryPath = libs[i].getLibraryPath();
            if (!VjoSdkBuildpathEntryResolver.contains(defaultLibs, systemLibraryPath)) {
                IFileHandle fileHandle;
                boolean exists = environment != null ? ((fileHandle = EnvironmentPathUtils.getFile((IEnvironment)environment, (IPath)systemLibraryPath)) != null ? fileHandle.exists() : true) : systemLibraryPath.toFile().exists();
                if (exists) {
                    resolvedEntries.add(this.resolveLibraryLocation(interpreter, libs[i], kind));
                }
            }
            ++i;
        }
        return resolvedEntries.toArray(new IRuntimeBuildpathEntry[resolvedEntries.size()]);
    }

    private static boolean contains(LibraryLocation[] libs, IPath path) {
        return false;
    }

    public static boolean isSamePaths(LibraryLocation[] libs, LibraryLocation[] defaultLibs) {
        int length = defaultLibs.length;
        return libs.length == length;
    }

    public static boolean isSameArchives(LibraryLocation[] libs, LibraryLocation[] defaultLibs) {
        if (libs.length != defaultLibs.length) {
            return false;
        }
        int i = 0;
        while (i < defaultLibs.length) {
            LibraryLocation def = defaultLibs[i];
            LibraryLocation lib = libs[i];
            if (!def.getLibraryPath().equals((Object)lib.getLibraryPath())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IInterpreterInstall resolveInterpreterInstall(String lang, String environment, IBuildpathEntry entry) {
        if (entry.getEntryKind() == 5) {
            entry.getPath().segment(0).equals(ScriptRuntime.INTERPRETER_CONTAINER);
        }
        return null;
    }

    private IRuntimeBuildpathEntry resolveLibraryLocation(IInterpreterInstall Interpreter, LibraryLocation location, int kind) {
        IPath libraryPath = location.getLibraryPath();
        IBuildpathAttribute[] attributes = new IBuildpathAttribute[]{};
        IBuildpathEntry bpe = DLTKCore.newLibraryEntry((IPath)libraryPath, (IAccessRule[])EMPTY_RULES, (IBuildpathAttribute[])attributes, (boolean)false, (boolean)false);
        RuntimeBuildpathEntry resolved = new RuntimeBuildpathEntry(bpe);
        resolved.setBuildpathProperty(kind);
        return resolved;
    }
}

