/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.mod.console.ScriptConsoleServer;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.launching.AbstractInterpreterRunner;
import org.eclipse.dltk.mod.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.InterpreterConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.vjet.eclipse.internal.launching.IConfigurableRunner;
import org.eclipse.vjet.eclipse.internal.launching.IJavaScriptInterpreterRunnerConfig;
import org.osgi.framework.Bundle;

public class JavaScriptInterpreterRunner
extends AbstractInterpreterRunner
implements IConfigurableRunner {
    public static final IJavaScriptInterpreterRunnerConfig DEFAULT_CONFIG = new IJavaScriptInterpreterRunnerConfig(){

        @Override
        public void adjustRunnerConfiguration(VMRunnerConfiguration vconfig, InterpreterConfig iconfig, ILaunch launch, IJavaProject project) {
        }

        @Override
        public String[] computeClassPath(InterpreterConfig config, ILaunch launch, IJavaProject project) throws Exception {
            return JavaScriptInterpreterRunner.getClassPath(project);
        }

        @Override
        public String[] getProgramArguments(InterpreterConfig config, ILaunch launch, IJavaProject project) {
            return new String[0];
        }

        @Override
        public String getRunnerClassName(InterpreterConfig config, ILaunch launch, IJavaProject project) {
            return "RhinoRunner";
        }
    };
    private IJavaScriptInterpreterRunnerConfig config = DEFAULT_CONFIG;

    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        JavaScriptInterpreterRunner.doRunImpl(config, launch, this.config);
    }

    public static void doRunImpl(InterpreterConfig config, ILaunch launch, IJavaScriptInterpreterRunnerConfig iconfig) throws CoreException {
        IVMRunner vmRunner;
        IScriptProject proj;
        IJavaProject myJavaProject;
        IVMInstall vmInstall;
        String sessionId;
        String port;
        String host = (String)config.getProperty("host");
        if (host == null) {
            host = "";
        }
        if ((port = (String)config.getProperty("port")) == null) {
            port = "";
        }
        if ((sessionId = (String)config.getProperty("sessionId")) == null) {
            sessionId = "";
        }
        IVMInstall iVMInstall = vmInstall = (myJavaProject = JavaCore.create((IProject)(proj = AbstractScriptLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)launch.getLaunchConfiguration())).getProject())).exists() ? JavaRuntime.getVMInstall((IJavaProject)myJavaProject) : JavaRuntime.getDefaultVMInstall();
        if (vmInstall != null && (vmRunner = vmInstall.getVMRunner("debug")) != null) {
            try {
                try {
                    String[] newClassPath = JavaScriptInterpreterRunner.getClassPath(myJavaProject);
                    VMRunnerConfiguration vmConfig = new VMRunnerConfiguration(iconfig.getRunnerClassName(config, launch, myJavaProject), newClassPath);
                    IPath scriptFilePath = config.getScriptFilePath();
                    if (scriptFilePath == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.vjet.eclipse.launching", "Script File name is not specified..."));
                    }
                    String[] strings = new String[]{scriptFilePath.toPortableString(), host, port, sessionId};
                    String[] newStrings = iconfig.getProgramArguments(config, launch, myJavaProject);
                    String[] rs = new String[strings.length + newStrings.length];
                    int a = 0;
                    while (a < strings.length) {
                        rs[a] = strings[a];
                        ++a;
                    }
                    a = 0;
                    while (a < newStrings.length) {
                        rs[a + strings.length] = newStrings[a];
                        ++a;
                    }
                    vmConfig.setProgramArguments(strings);
                    Launch launchr = new Launch(launch.getLaunchConfiguration(), "debug", null);
                    iconfig.adjustRunnerConfiguration(vmConfig, config, launch, myJavaProject);
                    vmRunner.run(vmConfig, (ILaunch)launchr, null);
                    IDebugTarget[] debugTargets = launchr.getDebugTargets();
                    int a2 = 0;
                    while (a2 < debugTargets.length) {
                        launch.addDebugTarget(debugTargets[a2]);
                        ++a2;
                    }
                    IProcess[] processes = launchr.getProcesses();
                    int a3 = 0;
                    while (a3 < processes.length) {
                        launch.addProcess(processes[a3]);
                        ++a3;
                    }
                    return;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        throw new CoreException((IStatus)new Status(4, "", ""));
    }

    public static String[] getClassPath(IJavaProject myJavaProject) throws IOException, URISyntaxException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.dltk.mod.javascript.rhino");
        Bundle bundle1 = Platform.getBundle((String)"org.eclipse.dltk.mod.javascript.rhino.dbgp");
        URL resolve = FileLocator.toFileURL((URL)bundle1.getResource("RhinoRunner.class"));
        String externalForm = resolve.toExternalForm();
        File fl = new File(JavaScriptInterpreterRunner.toURI(externalForm)).getParentFile();
        URL fileURL = FileLocator.toFileURL((URL)bundle.getResource("org/mozilla/classfile/ByteCode.class"));
        String externalForm2 = fileURL.toExternalForm();
        File fl1 = new File(JavaScriptInterpreterRunner.toURI(externalForm2)).getParentFile().getParentFile().getParentFile().getParentFile();
        String[] classPath = null;
        try {
            classPath = JavaScriptInterpreterRunner.computeBaseClassPath(myJavaProject);
        }
        catch (CoreException coreException) {}
        String[] newClassPath = new String[classPath.length + 2];
        System.arraycopy(classPath, 0, newClassPath, 0, classPath.length);
        newClassPath[classPath.length] = fl.getAbsolutePath();
        newClassPath[classPath.length + 1] = fl1.getAbsolutePath();
        return newClassPath;
    }

    private static URI toURI(String externalForm) throws MalformedURLException {
        URL url = new URL(JavaScriptInterpreterRunner.replaceSpaces(externalForm));
        try {
            return new URI(url.toString());
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    private static String replaceSpaces(String text) {
        return text.replaceAll(" ", "%20");
    }

    protected static String[] computeBaseClassPath(IJavaProject myJavaProject) throws CoreException {
        if (!myJavaProject.exists()) {
            return new String[0];
        }
        return JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)myJavaProject);
    }

    protected String constructProgramString(InterpreterConfig config) throws CoreException {
        return "";
    }

    public JavaScriptInterpreterRunner(IInterpreterInstall install) {
        super(install);
    }

    protected String[] alterCommandLine(String[] cmdLine, String id) {
        ScriptConsoleServer server = ScriptConsoleServer.getInstance();
        String port = Integer.toString(server.getPort());
        String[] newCmdLine = new String[cmdLine.length + 4];
        newCmdLine[0] = cmdLine[0];
        newCmdLine[1] = DLTKCore.getDefault().getStateLocation().append("tcl_proxy").toOSString();
        newCmdLine[2] = "localhost";
        newCmdLine[3] = port;
        newCmdLine[4] = id;
        int i = 1;
        while (i < cmdLine.length) {
            newCmdLine[i + 4] = cmdLine[i];
            ++i;
        }
        return newCmdLine;
    }

    protected String getProcessType() {
        return "javascriptInterpreter";
    }

    @Override
    public void setRunnerConfig(IJavaScriptInterpreterRunnerConfig config) {
        this.config = config;
    }
}

