/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javatojs.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.vjet.af.common.error.ErrorArgsInterface;
import org.eclipse.vjet.af.common.error.ErrorList;
import org.eclipse.vjet.af.common.error.ErrorObject;
import org.eclipse.vjet.core.codegen.bootstrap.CodeGenStatus;
import org.eclipse.vjet.core.codegen.bootstrap.IToolMonitor;
import org.eclipse.vjet.core.codegen.bootstrap.StatusCode;
import org.eclipse.vjet.dsf.javatojs.control.BuildController;
import org.eclipse.vjet.dsf.javatojs.control.DapJsrGenListener;
import org.eclipse.vjet.dsf.javatojs.control.ITranslationInitializer;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateLogger;
import org.eclipse.vjet.dsf.javatojs.translate.config.CodeGenConfig;
import org.eclipse.vjet.dsf.jsgen.shared.generate.CodeStyle;
import org.eclipse.vjet.dsf.jsgen.shared.generate.IJsrGenListener;
import org.eclipse.vjet.dsf.jsgen.shared.generate.JsrGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorCtx;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.VjoGenerator;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.ts.util.ISdkEnvironment;
import org.eclipse.vjet.eclipse.core.ts.JstLibResolver;
import org.eclipse.vjet.eclipse.javatojs.core.VJetSdkEnvironment;
import org.eclipse.vjet.vjo.lib.IResourceResolver;
import org.eclipse.vjet.vjo.lib.LibManager;
import org.eclipse.vjet.vjo.lib.ResourceHelper;

public class PluginCodeGenHelper {
    private TranslateCtx m_tranlateCtx = TranslateCtx.ctx();
    private CodeGenConfig m_config;
    private BuildController m_controller;
    private IToolMonitor m_monitor;
    private static final String MESSAGE = "message";
    private static final String LINE = "line";
    private long m_total = 0L;
    private long m_start = 0L;
    private boolean m_logTime = false;
    private boolean m_logCode = false;

    public PluginCodeGenHelper() {
        this(new CodeGenConfig());
    }

    public PluginCodeGenHelper(CodeGenConfig config) {
        this(config, null);
    }

    public PluginCodeGenHelper(CodeGenConfig config, IToolMonitor monitor) {
        this.m_config = config;
        this.m_monitor = monitor;
    }

    public List<JstType> toJst(URL filePath) {
        ResourceHelper jstLibResolver = JstLibResolver.getInstance().setSdkEnvironment((ISdkEnvironment)new VJetSdkEnvironment(new String[0], "DefaultSdk"));
        LibManager.getInstance().setResourceResolver((IResourceResolver)jstLibResolver);
        BuildController controller = this.getBuildController();
        controller.reset();
        if (filePath.toExternalForm().endsWith(".java")) {
            ArrayList<URL> files = new ArrayList<URL>(1);
            files.add(filePath);
            controller.buildFiles(files);
        } else {
            controller.setIncludeChildPkgs(this.m_config.shouldIncludeChildPkgs());
            controller.buildPackage(filePath);
        }
        List types = controller.getTranslatedJstTypes();
        this.logTime("Translate");
        return types;
    }

    public List<TranslateError> getAllErrors() {
        if (this.m_controller == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_controller.getAllErrors();
    }

    private BuildController getBuildController() {
        if (this.m_controller != null) {
            return this.m_controller;
        }
        ITranslationInitializer configInitializer = null;
        try {
            configInitializer = (ITranslationInitializer)this.m_config.getConfigInitializer().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create instance of " + this.m_config.getConfigInitializer().getName());
        }
        this.m_controller = new BuildController(configInitializer);
        this.m_controller.enableTrace(this.m_config.isTraceEnabled());
        this.m_controller.enableParallel(this.m_config.isParallelEnabled());
        this.m_controller.setGenJsr(false);
        this.m_controller.setGenVjo(false);
        this.m_controller.setVerbose(this.m_config.isVerbose());
        if (this.m_config.getMode() == CodeGenConfig.TranslationMode.TARGETED) {
            this.m_controller.setUseOnDemand(false);
        } else if (this.m_config.getMode() == CodeGenConfig.TranslationMode.ONDEMAND) {
            this.m_controller.setUseOnDemand(true);
        } else {
            throw new RuntimeException("Unknown translation mode " + this.m_config.getMode());
        }
        return this.m_controller;
    }

    public String toVjo(JstType type, CodeStyle style) {
        String buffer = this.genVjo(type, style);
        this.logCode("\n============================== Vjo ===============================\n" + buffer + "\n------------------------------------------------------------------");
        return buffer.toString();
    }

    public String toJsr(JstType type, CodeStyle style, boolean fromJava) {
        StringWriter buffer = this.genJsr(type, style, fromJava);
        this.logCode("\n============================== Jsr ===============================\n" + buffer + "\n------------------------------------------------------------------");
        return buffer.toString();
    }

    public void setLogWriter() {
        this.m_tranlateCtx.setLogger(new TranslateLogger(this.m_tranlateCtx.getConfig().getErrorPolicy()));
    }

    public void setConfig(CodeGenConfig config) {
        this.m_config = config;
    }

    public CodeGenConfig getConfig() {
        return this.m_config;
    }

    private String genVjo(JstType type, CodeStyle style) {
        VjoGenerator writer = new VjoGenerator(new GeneratorCtx(style));
        writer.writeVjo((IJstType)type);
        this.logTime("Gen Vjo");
        return writer.getGeneratedText();
    }

    private StringWriter genJsr(JstType type, CodeStyle style, boolean fromJava) {
        StringWriter buffer = new StringWriter();
        JsrGenerator generator = new JsrGenerator(new PrintWriter(buffer), style);
        generator.addListener((IJsrGenListener)new DapJsrGenListener());
        generator.writeJsr((IJstType)type, fromJava);
        this.logTime("Gen Jsr");
        return buffer;
    }

    static void addStatus(ErrorList errors, List<CodeGenStatus> statusCollection) {
        ListIterator iter = errors.listIterator();
        while (iter.hasNext()) {
            ErrorObject eo = (ErrorObject)iter.next();
            CodeGenStatus status = eo.isWarning() ? new CodeGenStatus(StatusCode.Warning) : (eo.isError() ? new CodeGenStatus(StatusCode.Error) : (eo.isFatal() ? new CodeGenStatus(StatusCode.FatalError) : new CodeGenStatus(StatusCode.Warning)));
            ErrorArgsInterface params = eo.getParameters();
            status.setMessage(params.getValueByName(MESSAGE));
            status.setLineNumber(Integer.valueOf(params.getValueByName(LINE)).intValue());
            statusCollection.add(status);
        }
    }

    private void logCode(Object msg) {
        if (this.m_logCode) {
            System.out.println(msg.toString());
        }
    }

    private void logTime(String label) {
        if (this.m_logTime) {
            long cur = System.currentTimeMillis();
            long elapse = cur - this.m_start;
            this.m_start = cur;
            this.m_total += elapse;
            System.out.println("--> " + label + " = " + elapse + " (acummulated: " + this.m_total + ")");
        }
    }

    public static class AstUtil {
        private static final String OPTION_SOURCE_LEVEL = "org.eclipse.jdt.core.compiler.source";
        private static final String OPTION_COMPILER_COMPLIANCE = "org.eclipse.jdt.core.compiler.compliance";
        private static final String JAVA_LEVEL = "1.5";

        public static ASTParser newASTParser() {
            ASTParser astParser = ASTParser.newParser((int)3);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put(OPTION_SOURCE_LEVEL, JAVA_LEVEL);
            compilerOptions.put(OPTION_COMPILER_COMPLIANCE, JAVA_LEVEL);
            astParser.setCompilerOptions(compilerOptions);
            astParser.setKind(8);
            return astParser;
        }
    }
}

