/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.formatter.comments;

import org.eclipse.vjet.eclipse.internal.formatter.comments.CommentLine;
import org.eclipse.vjet.eclipse.internal.formatter.comments.CommentRange;
import org.eclipse.vjet.eclipse.internal.formatter.comments.CommentRegion;

public class SingleCommentLine
extends CommentLine {
    public static final String SINGLE_COMMENT_PREFIX = "// ";
    protected static final String VJO_COMMENT_FORMAT_START_PREFIX_LEFT = "<";
    protected static final String VJO_COMMENT_FORMAT_START_PREFIX_RIGHT = ">";
    private static final String NLS_TAG_PREFIX = "//$NON-NLS-";
    private boolean fLocaleSequence = false;

    protected SingleCommentLine(CommentRegion region) {
        super(region);
    }

    @Override
    protected void adapt(CommentLine previous) {
    }

    @Override
    protected void formatLowerBorder(CommentRange range, String indentation, int length) {
        int offset = range.getOffset() + range.getLength();
        CommentRegion parent = this.getParent();
        parent.logEdit(parent.getDelimiter(), offset, parent.getLength() - offset);
    }

    @Override
    protected void formatUpperBorder(CommentRange range, String indentation, int length) {
        CommentRegion parent = this.getParent();
        parent.logEdit(this.getContentPrefix(), 0, range.getOffset());
    }

    @Override
    protected String getContentPrefix() {
        return SINGLE_COMMENT_PREFIX;
    }

    @Override
    protected String getEndingPrefix() {
        return SINGLE_COMMENT_PREFIX;
    }

    @Override
    protected String getStartingPrefix() {
        return SINGLE_COMMENT_PREFIX;
    }

    @Override
    protected void scanLine(int line) {
        String prefix;
        CommentRange range = this.getFirst();
        String content = this.getParent().getText(range.getOffset(), range.getLength());
        int offset = content.indexOf(prefix = this.getContentPrefix().trim());
        if (offset >= 0) {
            if (content.startsWith(NLS_TAG_PREFIX)) {
                this.fLocaleSequence = true;
            }
            range.trimBegin(offset + prefix.length());
        }
    }

    @Override
    protected void tokenizeLine(int line) {
        if (!this.fLocaleSequence) {
            super.tokenizeLine(line);
        }
    }
}

