/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.codeassist.select;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.mod.codeassist.IAssistParser;
import org.eclipse.dltk.mod.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementVisitor;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.internal.codeassist.select.JstNodeDLTKElementResolver;
import org.eclipse.vjet.eclipse.internal.codeassist.select.ModelLeafElementVisitor;
import org.eclipse.vjet.eclipse.internal.codeassist.select.SelectionParser;
import org.eclipse.vjet.eclipse.internal.codeassist.select.translator.IJstNodeTranslator;
import org.eclipse.vjet.eclipse.internal.codeassist.select.translator.JstToDLTKNodeTranslator;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoSelectionEngine
extends ScriptSelectionEngine {
    private SelectionParser m_parser = new SelectionParser();

    public IModelElement[] convert(IVjoSourceModule module, IJstNode jstNode) {
        IModelElement[] elems = JstNodeDLTKElementResolver.convert(module, jstNode);
        return elems;
    }

    public IJstNode convertSelection2JstNode(ISourceModule module, int startOffset, int endOffset) {
        BaseJstNode selection;
        IJstNode jstBinding;
        IVjoSourceModule sourceModule = (IVjoSourceModule)module;
        IJstType jstType = sourceModule.getJstType();
        if (jstType == null) {
            IResource resource = sourceModule.getResource();
            if (resource == null || !resource.exists() || !(resource instanceof IFile)) {
                jstType = CodeassistUtils.findNativeJstType(sourceModule.getElementName());
            } else {
                String typeName = CodeassistUtils.getClassName((IFile)sourceModule.getResource());
                jstType = TypeSpaceMgr.findType((String)sourceModule.getScriptProject().getElementName(), (String)typeName);
            }
        }
        if ((jstBinding = JstNodeDLTKElementResolver.lookupBinding((IJstNode)(selection = JstUtil.getLeafNode((IJstType)jstType, (int)startOffset, (int)(endOffset = (startOffset = this.repairOffset(sourceModule, startOffset))), (boolean)true)))) == null) {
            return selection;
        }
        return jstBinding;
    }

    public IAssistParser getParser() {
        return this.m_parser;
    }

    public IModelElement[] select(ISourceModule module, int startOffset, int endOffset) {
        IModelElement elem;
        IJstNode jstNode = this.convertSelection2JstNode(module, startOffset, endOffset);
        if (jstNode == null) {
            return new IModelElement[0];
        }
        JstSource nameSource = null;
        if (jstNode instanceof JstProperty) {
            nameSource = ((JstProperty)jstNode).getName().getSource();
        } else if (jstNode instanceof JstVars) {
            JstVars vars = (JstVars)jstNode;
            JstIdentifier localVar = (JstIdentifier)((AssignExpr)vars.getAssignments().get(0)).getLHS();
            nameSource = localVar.getSource();
        } else if (jstNode instanceof JstConstructor) {
            nameSource = ((JstConstructor)jstNode).getOwnerType().getConstructor().getName().getSource();
            if (nameSource == null) {
                nameSource = ((JstConstructor)jstNode).getOwnerType().getSource();
            }
        } else if (jstNode instanceof IJstMethod) {
            nameSource = ((IJstMethod)jstNode).getName().getSource();
        }
        if (nameSource != null) {
            endOffset = nameSource.getEndOffSet();
            startOffset = nameSource.getStartOffSet();
        } else if (jstNode.getSource() != null) {
            startOffset = jstNode.getSource().getStartOffSet();
            endOffset = jstNode.getSource().getEndOffSet();
        }
        IJstNodeTranslator nodeTranslator = JstToDLTKNodeTranslator.getNodeTranslator((IJstNode)jstNode.getRootType());
        IModelElement[] dltktypes = nodeTranslator.convert((IJstNode)jstNode.getRootType());
        if (dltktypes != null && dltktypes.length > 0 && (elem = this.visitAndFindModelElement(dltktypes[0], startOffset, endOffset)) != null) {
            return new IModelElement[]{elem};
        }
        IVjoSourceModule vjoModule = null;
        if (module instanceof IVjoSourceModule) {
            vjoModule = (IVjoSourceModule)module;
        }
        return this.convert(vjoModule, jstNode);
    }

    private IModelElement visitAndFindModelElement(IModelElement module, int curStartOffset, int curEndOffset) {
        try {
            ModelLeafElementVisitor visitor = new ModelLeafElementVisitor(curEndOffset, curStartOffset);
            module.accept((IModelElementVisitor)visitor);
            return visitor.elem;
        }
        catch (ModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    private int repairOffset(IVjoSourceModule module, int offset) {
        if (offset == 0) {
            return offset;
        }
        try {
            char[] sourceChar = module.getSourceAsCharArray();
            if (sourceChar == null || offset >= sourceChar.length) {
                return offset;
            }
            char selectedChar = sourceChar[offset];
            if (Character.isWhitespace(selectedChar)) {
                --offset;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return offset;
    }
}

