/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.typeconstruct;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vjet.dsf.jstojava.resolver.IOTypeResolver;
import org.eclipse.vjet.eclipse.core.typeconstruct.OTypeResolverExtension;

public class OTypeResolverExtensionRegistry {
    public static final String EXTENSION_POINT_ID = "org.eclipse.vjet.eclipse.core.otypedef";
    private static final String TAG_RESOLVER = "resolver";
    private Map<String, OTypeResolverExtension> resolversMap = new HashMap<String, OTypeResolverExtension>();
    private boolean isInitialized = false;

    public Collection<OTypeResolverExtension> getResolverExtensions() {
        IExtension[] otypeDefResolverExtensions;
        if (this.isInitialized) {
            return this.resolversMap.values();
        }
        IExtensionPoint otypeDefResolverExtPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (otypeDefResolverExtPoint == null) {
            return this.resolversMap.values();
        }
        IExtension[] iExtensionArray = otypeDefResolverExtensions = otypeDefResolverExtPoint.getExtensions();
        int n = otypeDefResolverExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension otypeDefResolverExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = otypeDefResolverExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                String elementName;
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element != null && (elementName = element.getName()).equals(TAG_RESOLVER)) {
                    this.readOTypeDefResolverExtension(element);
                }
                ++n4;
            }
            ++n2;
        }
        return this.resolversMap.values();
    }

    private void readOTypeDefResolverExtension(IConfigurationElement element) {
        OTypeResolverExtension extension = new OTypeResolverExtension(element);
        this.resolversMap.put(extension.getKey(), extension);
    }

    public OTypeResolverExtension getResolverExtension(String key) {
        this.getResolverExtensions();
        return this.resolversMap.get(key);
    }

    public IOTypeResolver getResolver(String key) throws CoreException {
        OTypeResolverExtension extension = this.getResolverExtension(key);
        if (extension != null) {
            return extension.createResolver();
        }
        return null;
    }
}

