/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.vjet.eclipse.core.search.IVjoElementSearcher;
import org.eclipse.vjet.eclipse.core.search.SearchQueryParameters;
import org.eclipse.vjet.eclipse.core.search.VjoFieldSearcher;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoMethodSearcher;
import org.eclipse.vjet.eclipse.core.search.VjoPackageReferenceSearcher;
import org.eclipse.vjet.eclipse.core.search.VjoTypeDeclarationSearcher;
import org.eclipse.vjet.eclipse.core.search.VjoTypeReferencesSearcher;
import org.eclipse.vjet.eclipse.core.search.VjoTypeSearcher;

public class VjoSearchEngine {
    private static Map<Class<? extends SearchPattern>, IVjoElementSearcher> map = VjoSearchEngine.create();

    static {
        VjoSearchEngine.add(new VjoMethodSearcher());
        VjoSearchEngine.add(new VjoFieldSearcher());
        VjoSearchEngine.add(new VjoTypeDeclarationSearcher());
        VjoSearchEngine.add(new VjoTypeReferencesSearcher());
        VjoSearchEngine.add(new VjoTypeSearcher());
        VjoSearchEngine.add(new VjoPackageReferenceSearcher());
    }

    private static HashMap<Class<? extends SearchPattern>, IVjoElementSearcher> create() {
        return new HashMap<Class<? extends SearchPattern>, IVjoElementSearcher>();
    }

    public static void add(IVjoElementSearcher handler) {
        map.put(handler.getSearchPatternClass(), handler);
    }

    public List<VjoMatch> search(SearchQueryParameters parameters) {
        if (parameters.getPattern() == null) {
            return Collections.EMPTY_LIST;
        }
        IVjoElementSearcher searcher = map.get(parameters.getPattern().getClass());
        ArrayList<VjoMatch> result = new ArrayList<VjoMatch>();
        if (searcher != null) {
            if (parameters.isElementSpecification()) {
                searcher.searchByModel(parameters, result);
            } else {
                searcher.searchByPattern(parameters, result);
            }
            HashSet<VjoMatch> matchSet = new HashSet<VjoMatch>();
            matchSet.addAll(result);
            result.clear();
            result.addAll(matchSet);
        }
        return result;
    }
}

