/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.internal.core.search.HierarchyScope;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.search.IVjoElementSearcher;
import org.eclipse.vjet.eclipse.core.search.IVjoOccurrenceSearcher;
import org.eclipse.vjet.eclipse.core.search.SearchQueryParameters;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

abstract class AbstractVjoElementSearcher
implements IVjoElementSearcher,
IVjoOccurrenceSearcher {
    protected TypeSpaceMgr mgr = TypeSpaceMgr.getInstance();
    protected IProject[] m_projects;
    protected HierarchyScope m_hierarchyScope;

    AbstractVjoElementSearcher() {
    }

    protected void initScope(IDLTKSearchScope scope) {
        if (scope instanceof HierarchyScope) {
            this.m_hierarchyScope = (HierarchyScope)scope;
        } else {
            this.m_projects = this.getProjects(scope);
            this.m_hierarchyScope = null;
        }
    }

    protected boolean isInScope(IType type) {
        boolean inScope = false;
        if (type == null) {
            return inScope;
        }
        if (CodeassistUtils.isNativeObject((IMember)type)) {
            return true;
        }
        if (this.m_projects != null) {
            IProject typeProject = type.getParent().getScriptProject().getProject();
            IProject[] iProjectArray = this.m_projects;
            int n = this.m_projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.equals((Object)typeProject)) {
                    inScope = true;
                    break;
                }
                ++n2;
            }
        } else {
            inScope = this.m_hierarchyScope.encloses((IModelElement)type);
        }
        return inScope;
    }

    @Override
    public void searchByModel(SearchQueryParameters params, List<VjoMatch> result) {
        this.initScope(params.getScope());
        int maskedLimitTo = params.getLimitTo() & 0xFFFFFFCF;
        if (maskedLimitTo == 0) {
            this.searchDeclarations(params, result);
        } else if (maskedLimitTo == 1) {
            this.searchReferences(params, result);
        } else if (maskedLimitTo == 2) {
            this.searchDeclarations(params, result);
            this.searchReferences(params, result);
        }
    }

    protected abstract void searchDeclarations(SearchQueryParameters var1, List<VjoMatch> var2);

    protected abstract void searchReferences(SearchQueryParameters var1, List<VjoMatch> var2);

    @Override
    public void searchByPattern(SearchQueryParameters parameters, List<VjoMatch> result) {
    }

    public IProject[] getProjects(IDLTKSearchScope scope) {
        IPath[] paths = scope.enclosingProjectsAndZips();
        HashSet<IResource> temp = new HashSet<IResource>();
        int i = 0;
        while (i < paths.length) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(paths[i]);
            if (resource != null && resource.getType() == 4) {
                temp.add(resource);
            }
            ++i;
        }
        return temp.toArray(new IProject[temp.size()]);
    }

    @Override
    public List<VjoMatch> findOccurrence(IJstNode jstNode, IJstNode scope) {
        return Collections.emptyList();
    }
}

