/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.codeassist.IAssistParser;
import org.eclipse.dltk.mod.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.CompletionContext;
import org.eclipse.dltk.mod.core.CompletionProposal;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.eclipse.codeassist.keywords.DictionaryKeywordCompletionEngine;
import org.eclipse.vjet.eclipse.codeassist.keywords.IVjoCompletionData;
import org.eclipse.vjet.eclipse.codeassist.keywords.JSTCompletionDictionary;
import org.eclipse.vjet.eclipse.codeassist.keywords.VjoKeywordCompletionResult;
import org.eclipse.vjet.eclipse.codeassist.keywords.VjoKeywordFactory;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.parser.VjoParserToJstAndIType;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoCompletionEngine
extends ScriptCompletionEngine {
    private static final List<String> UNRESOLVED_COMPLETIONS = new ArrayList<String>();
    public static final List<String> UNEXIST_TYPES = new ArrayList<String>();

    static {
        UNRESOLVED_COMPLETIONS.add("type");
        UNRESOLVED_COMPLETIONS.add("atype");
        UNRESOLVED_COMPLETIONS.add("makeFinal");
        UNEXIST_TYPES.add("Global");
    }

    public void complete(ISourceModule module, int position, int maxLen) {
        JstCompletion completion = null;
        VjoSourceModule vjoModule = (VjoSourceModule)module;
        this.actualCompletionPosition = position;
        this.requestor.beginReporting();
        VjoParserToJstAndIType parser = new VjoParserToJstAndIType();
        IJstType type = null;
        VjoSourceModule vmodule = (VjoSourceModule)module;
        try {
            type = parser.parse(vjoModule.getGroupName(), vmodule.getTypeName().typeName(), module.getSourceContents(), position);
            TypeSpaceMgr.parser().resolve(type);
            completion = this.getCompletion(type, position, position);
        }
        catch (Exception e) {
            VjetPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.vjet.eclipse.core", 4, "Error during code completion", (Throwable)e));
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        this.doKeywordProposal(module, position, completion);
        if (completion != null) {
            List<CompletionProposal> proposals = JSTCompletionDictionary.getCompletions(module, position, completion);
            CompletionContext context = new CompletionContext();
            this.requestor.acceptContext(context);
            for (CompletionProposal completionProposal : proposals) {
                if (this.isEmptyRange(completionProposal)) {
                    completionProposal.setReplaceRange(this.getReplaceStart(completion), this.endPosition - this.offset);
                }
                this.requestor.accept(completionProposal);
            }
        }
        this.requestor.endReporting();
    }

    private int getReplaceStart(JstCompletion completion) {
        String token = completion.getCompositeToken();
        if (token != null && token.startsWith(VjoKeywordFactory.KWD_VJ$.getName())) {
            int index = token.lastIndexOf(".");
            return this.startPosition + index + 1;
        }
        return this.startPosition - this.offset;
    }

    private boolean isEmptyRange(CompletionProposal completionProposal) {
        return completionProposal.getReplaceEnd() == 0 && completionProposal.getReplaceStart() == 0;
    }

    private void doKeywordProposal(ISourceModule sourceModule, int position, JstCompletion completion) {
        DictionaryKeywordCompletionEngine engine = new DictionaryKeywordCompletionEngine(sourceModule, position, completion);
        VjoKeywordCompletionResult result = engine.getCompletionResult();
        if (result != null) {
            List<IVjoCompletionData> keywords = result.getKeywords();
            String token = completion.getToken();
            this.setSourceRange(position - token.length(), position);
            this.createProposals(keywords);
        }
    }

    private void createProposals(List<IVjoCompletionData> keywords) {
        Iterator<IVjoCompletionData> iterator = keywords.iterator();
        CompletionContext context = new CompletionContext();
        this.requestor.acceptContext(context);
        while (iterator.hasNext()) {
            IVjoCompletionData keyword = iterator.next();
            if (this.getUnresolvedCompletions().contains(keyword.getName())) {
                iterator.remove();
                continue;
            }
            if (this.requestor.isIgnored(keyword.getType())) continue;
            CompletionProposal proposal = this.createProposal(keyword.getType(), this.actualCompletionPosition);
            char[] completion = keyword.toString().toCharArray();
            proposal.setCompletion(completion);
            proposal.setRelevance(keyword.getRelevance());
            proposal.setName(keyword.getName().toCharArray());
            proposal.setFlags(keyword.getFlags());
            if (keyword.isProposal()) {
                proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            }
            this.requestor.accept(proposal);
        }
    }

    protected int getEndOfEmptyToken() {
        return 0;
    }

    public IAssistParser getParser() {
        return null;
    }

    protected String processFieldName(IField field, String token) {
        return field.getElementName();
    }

    protected String processMethodName(IMethod method, String token) {
        return method.getElementName();
    }

    protected String processTypeName(IType type, String token) {
        return type.getFullyQualifiedName().replace('/', '.');
    }

    private JstCompletion getCompletion(IJstType type, int startOffset, int endOffset) {
        List fields = type.getChildren();
        for (IJstNode field : fields) {
            JstCompletion completion;
            JstSource source;
            if (!(field instanceof JstCompletion) || !JstUtil.includes((JstSource)(source = (completion = (JstCompletion)field).getSource()), (int)startOffset, (int)endOffset)) continue;
            return completion;
        }
        return null;
    }

    private List<String> getUnresolvedCompletions() {
        return UNRESOLVED_COMPLETIONS;
    }

    public void testPosition(IJstType type) {
        System.out.println("Begin report ... ");
        type.getSource().getStartOffSet();
        type.getSource().getEndOffSet();
        this.printChildNode((IJstNode)type, 0);
    }

    private void printChildNode(IJstNode node, int i) {
        List nodes = node.getChildren();
        int j = 0;
        while (j < i) {
            System.out.print("\t");
            ++j;
        }
        if (node != null && node instanceof IJstNode) {
            IJstNode jnode = node;
            String s = jnode.getClass().getName();
            if (jnode.getSource() != null) {
                s = String.valueOf(s) + " at " + jnode.getSource().getStartOffSet() + ":" + jnode.getSource().getEndOffSet() + ":" + jnode.getSource().getLength() + ">" + node.getSource().getRow();
                System.out.println(String.valueOf(i) + "\t: \t" + s);
            }
        }
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            this.printChildNode((IJstNode)it.next(), i + 1);
        }
    }
}

