/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.util.Enumeration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.mod.codeassist.ICompletionEngine;
import org.eclipse.dltk.mod.codeassist.ISelectionEngine;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.BufferChangedEvent;
import org.eclipse.dltk.mod.core.CompletionRequestor;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IBuffer;
import org.eclipse.dltk.mod.core.IBufferChangedListener;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelStatus;
import org.eclipse.dltk.mod.core.IOpenable;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.BufferManager;
import org.eclipse.dltk.mod.internal.core.Messages;
import org.eclipse.dltk.mod.internal.core.Model;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.dltk.mod.internal.core.Openable;
import org.eclipse.dltk.mod.internal.core.ProjectFragment;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.eclipse.internal.core.VjoModelElement;

public abstract class VjoOpenable
extends VjoModelElement
implements IOpenable,
IBufferChangedListener {
    VjoOpenable(VjoModelElement parent, BaseJstNode jstNode) {
        super(parent, (IJstNode)jstNode);
    }

    public void bufferChanged(BufferChangedEvent event) {
        if (event.getBuffer().isClosed()) {
            ModelManager.getModelManager().getElementsOutOfSynchWithBuffers().remove((Object)this);
            this.getBufferManager().removeBuffer(event.getBuffer());
        } else {
            ModelManager.getModelManager().getElementsOutOfSynchWithBuffers().add(this);
        }
    }

    protected abstract boolean buildStructure(IProgressMonitor var1, IResource var2) throws ModelException;

    public boolean canBeRemovedFromCache() {
        try {
            return !this.hasUnsavedChanges();
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public boolean canBufferBeRemovedFromCache(IBuffer buffer) {
        return !buffer.hasUnsavedChanges();
    }

    protected void closeBuffer() {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer buffer = this.getBufferManager().getBuffer((IOpenable)this);
        if (buffer != null) {
            buffer.close();
            buffer.removeBufferChangedListener((IBufferChangedListener)this);
        }
    }

    protected void closing(Object info) {
        this.closeBuffer();
    }

    @Override
    public boolean exists() {
        ModelManager manager = ModelManager.getModelManager();
        if (manager.getInfo((IModelElement)this) != null) {
            return true;
        }
        if (!this.parentExists()) {
            return false;
        }
        return super.exists();
    }

    protected void generateInfos(IProgressMonitor monitor) throws ModelException {
        if (ModelManager.VERBOSE) {
            String element;
            switch (this.getElementType()) {
                case 2: {
                    element = "project";
                    break;
                }
                case 3: {
                    element = "fragment";
                    break;
                }
                case 4: {
                    element = "folder";
                    break;
                }
                case 6: {
                    element = "binary module";
                    break;
                }
                case 5: {
                    element = "source module";
                    break;
                }
                default: {
                    element = "element";
                }
            }
            System.out.println(Thread.currentThread() + " OPENING " + element + " " + this.toStringWithAncestors());
        }
        this.openParent(monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.buildStructure(monitor, this.getResource());
        ModelManager.getModelManager().getElementsOutOfSynchWithBuffers().remove((Object)this);
        if (ModelManager.VERBOSE) {
            System.out.println(ModelManager.getModelManager().cache.toStringFillingRation("-> "));
        }
    }

    private String toStringWithAncestors() {
        StringBuffer buffer = new StringBuffer();
        return buffer.toString();
    }

    public IBuffer getBuffer() throws ModelException {
        if (this.hasBuffer()) {
            IBuffer buffer = this.getBufferManager().getBuffer((IOpenable)this);
            if (buffer == null) {
                buffer = this.openBuffer(null);
            }
            return buffer;
        }
        return null;
    }

    public IBuffer getBufferNotOpen() throws ModelException {
        if (this.hasBuffer()) {
            return this.getBufferManager().getBuffer((IOpenable)this);
        }
        return null;
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    public IResource getCorrespondingResource() throws ModelException {
        return this.getUnderlyingResource();
    }

    @Override
    public IOpenable getOpenable() {
        return this;
    }

    public IResource getUnderlyingResource() throws ModelException {
        IResource parentResource = this.m_parent.getUnderlyingResource();
        if (parentResource == null) {
            return null;
        }
        int type = parentResource.getType();
        if (type == 2 || type == 4) {
            IContainer folder = (IContainer)parentResource;
            IResource resource = folder.findMember(this.getElementName());
            if (resource == null) {
                throw this.newNotPresentException();
            }
            return resource;
        }
        return parentResource;
    }

    protected boolean hasBuffer() {
        return false;
    }

    public boolean hasUnsavedChanges() throws ModelException {
        IBuffer buf;
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        if (this.hasBuffer() && (buf = this.getBufferNotOpen()) != null && buf.hasUnsavedChanges()) {
            return true;
        }
        int elementType = this.getElementType();
        if (elementType == 4 || elementType == 3 || elementType == 2 || elementType == 1) {
            Enumeration openBuffers = this.getBufferManager().getOpenBuffers();
            while (openBuffers.hasMoreElements()) {
                IOpenable owner;
                IBuffer buffer = (IBuffer)openBuffers.nextElement();
                if (!buffer.hasUnsavedChanges() || !this.isAncestorOf((IModelElement)(owner = buffer.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAncestorOf(IModelElement e) {
        IModelElement parentElement = e.getParent();
        while (parentElement != null && !parentElement.equals((Object)this)) {
            parentElement = parentElement.getParent();
        }
        return parentElement != null;
    }

    public boolean isConsistent() {
        return true;
    }

    public boolean isOpen() {
        return ModelManager.getModelManager().getInfo((IModelElement)this) != null;
    }

    protected boolean isSourceElement() {
        return false;
    }

    public void makeConsistent(IProgressMonitor monitor) throws ModelException {
    }

    public void open(IProgressMonitor pm) throws ModelException {
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws ModelException {
        return null;
    }

    protected void openParent(IProgressMonitor pm) throws ModelException {
        VjoOpenable openableParent = (VjoOpenable)this.getOpenableParent();
        if (openableParent != null && !openableParent.isOpen()) {
            openableParent.generateInfos(pm);
        }
    }

    protected boolean parentExists() {
        IModelElement parentElement = this.getParent();
        if (parentElement == null) {
            return true;
        }
        return parentElement.exists();
    }

    protected boolean resourceExists() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        return Model.getTarget((IContainer)workspace.getRoot(), (IPath)this.getPath().makeRelative(), (boolean)true) != null;
    }

    public void save(IProgressMonitor pm, boolean force) throws ModelException {
        if (this.isReadOnly()) {
            throw new ModelException((IModelStatus)new ModelStatus(976, (IModelElement)this));
        }
        IBuffer buf = this.getBuffer();
        if (buf != null) {
            buf.save(pm, force);
            this.makeConsistent(pm);
        }
    }

    public ProjectFragment getProjectFragment() {
        return (ProjectFragment)this.getAncestor(3);
    }

    protected void codeComplete(ISourceModule cu, int position, CompletionRequestor requestor, WorkingCopyOwner owner) throws ModelException {
        if (requestor == null) {
            throw new IllegalArgumentException(Messages.Openable_completionRequesterCannotBeNull);
        }
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return;
        }
        if (position < -1 || position > buffer.getLength()) {
            if (DLTKCore.DEBUG) {
                throw new ModelException((IModelStatus)new ModelStatus(980));
            }
            return;
        }
        ScriptProject project = (ScriptProject)this.getScriptProject();
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)this);
        if (toolkit == null && (toolkit = DLTKLanguageManager.findToolkit((IResource)this.getResource())) == null) {
            return;
        }
        ICompletionEngine engine = DLTKLanguageManager.getCompletionEngine((String)toolkit.getNatureId());
        if (engine == null) {
            return;
        }
        engine.setRequestor(requestor);
        engine.setOptions(project.getOptions(true));
        engine.setProject((IScriptProject)project);
        engine.complete(cu, position, 0);
    }

    protected IModelElement[] codeSelect(ISourceModule cu, int offset, int length, WorkingCopyOwner owner) throws ModelException {
        IDLTKLanguageToolkit toolkit;
        ScriptProject project = (ScriptProject)this.getScriptProject();
        IBuffer buffer = this.getBuffer();
        int end = -1;
        if (buffer != null) {
            end = buffer.getLength();
        }
        if ((toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)this)) == null && (toolkit = DLTKLanguageManager.findToolkit((IResource)this.getResource())) == null) {
            return new IModelElement[0];
        }
        if (offset < 0 || length < 0 || end != -1 && offset + length > end) {
            throw new ModelException((IModelStatus)new ModelStatus(980));
        }
        ISelectionEngine engine = DLTKLanguageManager.getSelectionEngine((String)toolkit.getNatureId());
        if (engine == null) {
            return new IModelElement[0];
        }
        engine.setOptions(project.getOptions(true));
        IModelElement[] elements = engine.select(cu, offset, offset + length - 1);
        return elements;
    }

    protected void openWhenClosed(IProgressMonitor monitor) throws ModelException {
        try {
            Openable openable = (Openable)this.getOpenable();
            openable.closeBuffer();
        }
        catch (Exception exception) {
            DLTKCore.error((String)exception.toString(), (Throwable)exception);
        }
    }
}

