/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoEclipseCompletionProposal;

public class VjoEclipseCompletionProposalAdapter<IMAGE, CONTEXT_INFO>
implements IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> {
    protected String fDisplayString;
    protected String fReplacementString;
    protected int fReplacementOffset;
    protected int fReplacementLength;
    protected int fCursorPosition;
    protected String fAdditionalProposalInfo;
    protected IMAGE fImage;
    protected CONTEXT_INFO fContextInformation;
    protected static final char[] TRIGGER_METHOD = new char[]{',', '.', ';'};
    protected static final char[] TRIGGER_METHOD_WITH_ARGS = new char[]{',', ';'};
    protected static final char[] TRIGGER_COMMON = new char[0];
    protected Object fData;

    public VjoEclipseCompletionProposalAdapter(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
    }

    public VjoEclipseCompletionProposalAdapter(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IMAGE image, String displayString, CONTEXT_INFO contextInformation, String additionalProposalInfo) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, null);
    }

    public VjoEclipseCompletionProposalAdapter(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IMAGE image, String displayString, CONTEXT_INFO contextInformation, String additionalProposalInfo, Object data) {
        assert (replacementString != null);
        assert (replacementOffset >= 0);
        assert (replacementLength >= 0);
        assert (cursorPosition >= 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fDisplayString = displayString;
        this.fImage = image;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.fData = data;
    }

    @Override
    public CONTEXT_INFO getContextInformation() {
        return this.fContextInformation;
    }

    @Override
    public IMAGE getImage() {
        return this.fImage;
    }

    @Override
    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    @Override
    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    protected void appendComment() {
        IJstMethod method;
        String typeComment = "";
        if (this.fData instanceof IJstProperty) {
            IJstProperty property = (IJstProperty)this.fData;
            IJstType type = property.getType();
            if (type != null) {
                typeComment = type.getSimpleName();
            }
        } else if (this.fData instanceof IJstMethod && CodeCompletionUtils.hasReturnValue(method = (IJstMethod)this.fData)) {
            typeComment = CodeCompletionUtils.getReturnType(method);
        }
        if (!StringUtils.isBlankOrEmpty(typeComment)) {
            typeComment = "//<" + typeComment;
            this.fReplacementString = String.valueOf(this.fReplacementString) + typeComment;
            this.fCursorPosition += typeComment.length();
        }
    }

    protected boolean isPrefix(String prefix, String string) {
        if (prefix == null || string == null || prefix.length() > string.length()) {
            return false;
        }
        String start = string.substring(0, prefix.length());
        return start.equalsIgnoreCase(prefix) || CharOperation.camelCaseMatch((char[])prefix.toCharArray(), (char[])string.toCharArray());
    }

    @Override
    public String getReplacementString() {
        return this.fReplacementString;
    }

    @Override
    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    @Override
    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    @Override
    public int getCursorPosition() {
        return this.fCursorPosition;
    }

    @Override
    public int getContextInformationPosition() {
        return this.fReplacementOffset + this.fCursorPosition;
    }

    @Override
    public char[] getTriggerCharacters() {
        if (this.fData == null) {
            return TRIGGER_COMMON;
        }
        if (this.fData instanceof IJstProperty) {
            return TRIGGER_METHOD;
        }
        if (this.fData instanceof IJstMethod) {
            IJstMethod method = (IJstMethod)this.fData;
            List args = method.getArgs();
            if (args == null || args.isEmpty()) {
                return TRIGGER_METHOD;
            }
            return TRIGGER_METHOD_WITH_ARGS;
        }
        return TRIGGER_COMMON;
    }
}

