/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.proposaldata;

import java.util.Iterator;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;

public abstract class AbstractVjoProposalPresenter {
    protected String getKeywordReplaceString(String name, String typeName, boolean inCommentArea, String indent) {
        String str = "";
        str = inCommentArea ? CodeCompletionUtils.getCommentKeywordReplaceString(name, typeName, true, indent) : CodeCompletionUtils.getKeywordReplaceString(name, typeName, true, indent);
        return this.replaceSeperatorToken(str);
    }

    protected String getCommentTypeReplaceString(IJstType type, VjoCcCtx vjoCcCtx2) {
        String name = type.getSimpleName();
        name = type.getName();
        List paras = type.getParamNames();
        if (!paras.isEmpty()) {
            Iterator it = paras.iterator();
            StringBuffer buffer = new StringBuffer();
            buffer.append("<");
            while (it.hasNext()) {
                buffer.append(String.valueOf((String)it.next()) + ", ");
            }
            name = String.valueOf(name) + buffer.substring(0, buffer.length() - 2) + ">";
        }
        return name;
    }

    protected String getFunctionString(int identifier, String functionName, boolean isInterface, String indent) {
        if (isInterface) {
            return this.replaceSeperatorToken(CodeCompletionUtils.getInterfaceFunctionString(identifier, functionName));
        }
        return this.replaceSeperatorToken(CodeCompletionUtils.getFunctionString(identifier, functionName, indent));
    }

    protected String getMainFunctionString(String indent) {
        return this.replaceSeperatorToken(CodeCompletionUtils.getMainFunctionString(indent));
    }

    protected String getConstructorString(String modifier, String indent) {
        return this.replaceSeperatorToken(CodeCompletionUtils.getConstructorString(modifier, indent));
    }

    protected String getMethodProposalReplaceStr(boolean isGlobal, IJstMethod method, VjoCcCtx vjoCcCtx) {
        return this.getMethodProposalReplaceStr(isGlobal, method, method.getName().getName(), vjoCcCtx);
    }

    protected String getMethodProposalReplaceStr(boolean isGlobal, IJstMethod method, String name, VjoCcCtx vjoCcCtx) {
        return this.replaceSeperatorToken(CodeCompletionUtils.getMethodProposalReplaceStr(isGlobal, method, name, vjoCcCtx));
    }

    protected String getOuterMethodProposalReplaceStr(IJstMethod method) {
        return this.replaceSeperatorToken(CodeCompletionUtils.getOuterMethodProposalReplaceStr(method));
    }

    protected String getPropertyProposalReplaceStr(boolean isGlobal, IJstProperty property, VjoCcCtx vjoCcCtx) {
        return CodeCompletionUtils.getPropertyProposalReplaceStr(isGlobal, property, vjoCcCtx);
    }

    protected String getOuterPropertyProposalReplaceStr(IJstProperty property) {
        return CodeCompletionUtils.getOuterPropertyProposalReplaceStr(property);
    }

    protected String getOuterInnerTypeAsPropertyProposalReplaceStr(IJstType type) {
        return CodeCompletionUtils.getOuterPropertyProposalReplaceStr(type);
    }

    protected String getInnerTypeAsPropertyProposalReplaceStr(boolean isGlobal, IJstType jstType, VjoCcCtx vjoCcCtx) {
        return CodeCompletionUtils.getInnerTypeAsPropertyProposalReplaceStr(isGlobal, jstType, vjoCcCtx);
    }

    protected String getReplaceStringForOverrideProposal(IJstMethod method, String indent) {
        return this.replaceSeperatorToken(CodeCompletionUtils.getReplaceStringForOverrideProposal(method, indent));
    }

    protected String getLineSeperator() {
        return "\n";
    }

    protected String getSimpleTypeName(IJstType type) {
        IJstNode node = type.getParentNode();
        String str = type.getSimpleName();
        while (node != null && node instanceof IJstType) {
            IJstType ttype = (IJstType)node;
            str = String.valueOf(ttype.getSimpleName()) + "." + str;
            node = ttype.getParentNode();
        }
        return str;
    }

    private String replaceSeperatorToken(String str) {
        return str.replaceAll("<<Line_Seperator>>", this.getLineSeperator());
    }

    protected String getTypeReplaceString(IJstType type, VjoCcCtx vjoCcCtx) {
        String token;
        String replaceString = this.getSimpleTypeName(type);
        boolean isInSyntaxScope = vjoCcCtx.isInSyntaxScope();
        replaceString = isInSyntaxScope || vjoCcCtx.isInInactiveArea() ? type.getName() : (vjoCcCtx.isInCommentArea() ? ((token = vjoCcCtx.getActingToken()).contains(".") ? type.getName() : type.getSimpleName()) : (CodeCompletionUtils.isNativeType(type) ? type.getName() : type.getName()));
        return replaceString;
    }

    protected String replaceCursorPositionToken(String str) {
        return str.replaceAll("<<CURSOR_POSITION>>", "");
    }

    protected int getCursorPosition(String str) {
        int index = str.indexOf("<<CURSOR_POSITION>>");
        if (index == -1) {
            return str.length();
        }
        return index;
    }
}

