/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.engine;

import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstParseController;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jstojava.controller.JstParseController;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.IJstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCommentCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnMemberAccess;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstFieldOrMethodCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstKeywordCompletion;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcEngine;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcProposalData;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcAdvisorManager;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;

public class VjoCcEngine
implements IVjoCcEngine {
    private IJstParseController m_jstParseController;
    private VjoCcCtx m_ctx;

    public VjoCcEngine(IJstParseController jstParseController) {
        this.m_jstParseController = jstParseController;
    }

    @Override
    public List<IVjoCcProposalData> complete(IJstType type, int position) {
        return Collections.emptyList();
    }

    @Override
    public List<IVjoCcProposalData> complete(String groupName, String typeName, String content, int position) {
        if (this.m_jstParseController == null) {
            return Collections.emptyList();
        }
        this.m_ctx = this.genCcContext(groupName, typeName, content, position);
        if (this.m_ctx == null) {
            return Collections.emptyList();
        }
        VjoCcAdvisorManager advisorManager = new VjoCcAdvisorManager();
        advisorManager.advise(this.m_ctx);
        return this.m_ctx.getProposals();
    }

    private String preProcessContent(String content, int position) {
        if (position >= content.length()) {
            return content;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(content.substring(0, position));
        content = content.substring(position);
        int index = Math.min(content.indexOf("\n"), content.indexOf("\r"));
        if (index != -1) {
            buffer.append(content.substring(0, index)).append(";").append(content.substring(index));
        }
        return buffer.toString();
    }

    @Override
    public VjoCcCtx getContext() {
        return this.m_ctx;
    }

    public VjoCcCtx genCcContext(String groupName, String typeName, String content, int position) {
        List blocks;
        JstCompletion jstCompletion1;
        IJstType jstType1;
        IJstType scriptUnit;
        TranslateCtx translateCtx = new TranslateCtx();
        translateCtx.setCompletionPos(position);
        IJstType jstType = scriptUnit = this.parseJstContent(groupName, typeName, content, position, translateCtx);
        if (scriptUnit == null) {
            return null;
        }
        JstCompletion jstCompletion = this.getJstCompletion(translateCtx, position);
        if (jstCompletion instanceof JstCompletionOnMemberAccess && (jstType1 = this.parseJstContent(groupName, typeName, content = this.preProcessContent(content, position), position, translateCtx)) != null && (jstCompletion1 = this.getJstCompletion(translateCtx, position)) != null && !(jstCompletion1 instanceof JstCompletionOnMemberAccess)) {
            jstType = jstType1;
            scriptUnit = jstType1;
            jstCompletion = jstCompletion1;
        }
        if (this.m_jstParseController instanceof JstParseController) {
            ((JstParseController)this.m_jstParseController).resolve(groupName, scriptUnit);
        }
        TypeName typeNameT = new TypeName(groupName, this.getTypeName(groupName, typeName));
        if (!scriptUnit.equals(jstType) && jstCompletion instanceof JstCompletion) {
            JstCompletion c = jstCompletion;
            if (c.getRealParent() instanceof IJstType) {
                c.setRealParent((IJstNode)scriptUnit);
            }
            c.setParent(scriptUnit);
            jstType = scriptUnit;
            typeName = scriptUnit.getName();
            typeNameT = new TypeName(groupName, typeName);
        }
        if ((blocks = scriptUnit.getJstBlockList()) != null && !blocks.isEmpty()) {
            for (JstBlock block : blocks) {
                this.m_jstParseController.resolve(jstType, (IJstNode)block);
            }
        }
        VjoCcCtx ctx = new VjoCcCtx(this.m_jstParseController.getJstTypeSpaceMgr(), typeNameT);
        if (jstCompletion == null) {
            ctx.setActingType(jstType);
        } else {
            ctx.setCompletion((IJstCompletion)jstCompletion);
        }
        ctx.setOffset(position);
        ctx.setScriptUnit(scriptUnit);
        ctx.setContent(content);
        return ctx;
    }

    public VjoCcCtx genCcContext2(String groupName, String typeName, String content, int position) {
        List blocks;
        JstCompletion jstCompletion1;
        IJstType jstType1;
        TranslateCtx translateCtx = new TranslateCtx();
        translateCtx.setCompletionPos(position);
        IJstType jstType = this.parseJstContent(groupName, typeName, content, position, translateCtx);
        if (jstType == null) {
            return null;
        }
        JstCompletion jstCompletion = this.getJstCompletion(translateCtx, position);
        if (jstCompletion instanceof JstCompletionOnMemberAccess && (jstType1 = this.parseJstContent(groupName, typeName, content = this.preProcessContent(content, position), position, translateCtx)) != null && (jstCompletion1 = this.getJstCompletion(translateCtx, position)) != null && !(jstCompletion1 instanceof JstCompletionOnMemberAccess)) {
            jstType = jstType1;
            jstCompletion = jstCompletion1;
        }
        if (this.m_jstParseController instanceof JstParseController) {
            ((JstParseController)this.m_jstParseController).resolve(groupName, jstType);
        }
        TypeName typeNameT = new TypeName(groupName, this.getTypeName(groupName, typeName));
        if (jstCompletion instanceof JstCompletion) {
            JstCompletion c = jstCompletion;
            if (c.getRealParent() instanceof IJstType) {
                c.setRealParent(c.getRealParent());
            }
            c.setParent(jstType);
            typeName = jstType.getName();
            typeNameT = new TypeName(groupName, typeName);
        }
        if ((blocks = jstType.getJstBlockList()) != null && !blocks.isEmpty()) {
            for (JstBlock block : blocks) {
                this.m_jstParseController.resolve(jstType, (IJstNode)block);
            }
        }
        VjoCcCtx ctx = new VjoCcCtx(this.m_jstParseController.getJstTypeSpaceMgr(), typeNameT);
        if (jstCompletion == null) {
            ctx.setActingType(jstType);
        } else {
            ctx.setCompletion((IJstCompletion)jstCompletion);
        }
        ctx.setOffset(position);
        ctx.setScriptUnit(jstType);
        ctx.setContent(content);
        return ctx;
    }

    private String getTypeName(String groupName, String typeName) {
        String sourceFolder = "\\" + groupName + "\\" + "src" + "\\";
        if (typeName.startsWith(sourceFolder)) {
            typeName = typeName.substring(sourceFolder.length());
        }
        if (typeName.endsWith(".js")) {
            typeName = typeName.substring(0, typeName.length() - 3);
        }
        return typeName.replace("\\", ".");
    }

    private IJstType parseJstContent(String groupName, String typeName, String content, int position, TranslateCtx ctx) {
        VjoParser vjoParser = new VjoParser();
        return vjoParser.parse(groupName, typeName, content, ctx);
    }

    private JstCompletion getJstCompletion(TranslateCtx ctx, int position) {
        block3: {
            int size;
            List jstErrors;
            block2: {
                jstErrors = ctx.getJstErrors();
                List jstBlockCompletions = ctx.getBlockCompletions();
                size = jstErrors.size();
                if (size != 0 || jstBlockCompletions.size() <= 0) break block2;
                for (JstCompletion c : jstBlockCompletions) {
                    JstSource source = c.getSource();
                    if (source == null) continue;
                    return c;
                }
                break block3;
            }
            if (size <= 0) break block3;
            for (JstCompletion c : jstErrors) {
                JstSource source;
                if (c instanceof JstKeywordCompletion && c.getScopeStack().size() > 0 || (source = c.getSource()) == null) continue;
                return c;
            }
        }
        return null;
    }

    @Override
    public List<IVjoCcProposalData> completeComment(String groupName, String typeName, String content, int position, String commentString, int commentOffset) {
        this.m_ctx = this.genCcContext(groupName, typeName, content, position);
        if (!(this.m_ctx.getCompletion() instanceof JstCommentCompletion)) {
            JstCommentCompletion commentCompletion = new JstCommentCompletion((BaseJstNode)((JstType)this.m_ctx.getActingType()), commentString, commentOffset);
            if (this.m_ctx.getCompletion() instanceof JstFieldOrMethodCompletion) {
                commentCompletion.pushScope(ScopeIds.METHOD);
            } else if (this.m_ctx.getCompletion() == null || this.m_ctx.getCompletion() instanceof JstKeywordCompletion) {
                commentCompletion.pushScope(ScopeIds.TYPE);
            } else {
                commentCompletion.pushScope(ScopeIds.VAR);
            }
            this.m_ctx.setCompletion((IJstCompletion)commentCompletion);
        }
        VjoCcAdvisorManager advisorManager = new VjoCcAdvisorManager();
        advisorManager.advise(this.m_ctx);
        return this.m_ctx.getProposals();
    }
}

