/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.advisor;

import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.AbstractVjoCcAdvisor;

public class VjoCcStaticPropMethodProposalAdvisor
extends AbstractVjoCcAdvisor
implements IVjoCcAdvisor {
    public static final String ID = VjoCcStaticPropMethodProposalAdvisor.class.getName();

    @Override
    public void advise(VjoCcCtx ctx) {
        IJstType calledType;
        String token = ctx.getActingToken();
        IJstType callingType = ctx.getJstType();
        IJstType tempCalledType = calledType = ctx.getCalledType();
        int[] levels = this.getCallLevel(callingType, calledType);
        List methods = JstTypeHelper.getSignatureMethods((IJstType)calledType, (boolean)true, (boolean)true);
        for (IJstMethod method : methods) {
            boolean exactMatch;
            if (tempCalledType != method.getOwnerType()) {
                tempCalledType = method.getOwnerType();
                if (tempCalledType == null) {
                    tempCalledType = calledType;
                }
                levels = this.getCallLevel(callingType, tempCalledType);
            }
            boolean basicMatch = exactMatch = this.exactMatch(method.getName().getName(), token);
            if (!exactMatch) {
                basicMatch = this.basicMatch(method.getName().getName(), token);
            }
            if (!this.levelCheck(method.getModifiers(), levels) || !exactMatch && !basicMatch) continue;
            this.appendData(ctx, (IJstNode)method, exactMatch && basicMatch);
        }
        if (calledType == null) {
            return;
        }
        List properties = calledType.getAllPossibleProperties(true, !(calledType instanceof IJstRefType));
        for (IJstProperty property : properties) {
            boolean exactMatch;
            if (tempCalledType != property.getOwnerType()) {
                tempCalledType = property.getOwnerType();
                levels = this.getCallLevel(callingType, tempCalledType);
            }
            boolean basicMatch = exactMatch = this.exactMatch(property.getName().getName(), token);
            if (!exactMatch) {
                basicMatch = this.basicMatch(property.getName().getName(), token);
            }
            if (!this.levelCheck(property.getModifiers(), levels) || !exactMatch && !basicMatch || !this.specialRule(ctx, tempCalledType, property)) continue;
            this.appendData(ctx, (IJstNode)property, exactMatch && basicMatch);
        }
    }

    @Override
    protected int[] getCallLevel(IJstType callingType, IJstType calledType) {
        return CodeCompletionUtils.getGeneralFieldCallLevel(callingType, calledType);
    }

    protected boolean specialRule(VjoCcCtx ctx, IJstType jstType, IJstProperty jstProperty) {
        Object info = ctx.getInfo("TYPE_SHOW_FULLNAME");
        boolean hideIt = false;
        if (info != null && info instanceof Boolean) {
            hideIt = true;
        }
        return !hideIt || !"vjo".equals(jstType.getSimpleName()) || !"NEEDS_IMPL".equals(jstProperty.getName().getName());
    }
}

