/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.advisor;

import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstVjoBaseProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstVjoProperty;
import org.eclipse.vjet.dsf.ts.ITypeSpace;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.AbstractVjoCcAdvisor;

public class VjoAttributedProposalAdvisor
extends AbstractVjoCcAdvisor
implements IVjoCcAdvisor {
    public static final String ID = VjoAttributedProposalAdvisor.class.getName();

    @Override
    public void advise(VjoCcCtx ctx) {
        String token = ctx.getActingPackageToken();
        String attributorTypeName = this.getAttributorTypeName(token);
        if (attributorTypeName != null) {
            if (attributorTypeName.length() == 0) {
                this.proposeGlobalVars(ctx, this.isStaticAccess(token));
            } else {
                this.proposePropertiesAndMethodsUnderAttributor(ctx, token, attributorTypeName);
            }
        }
    }

    private void proposeGlobalVars(VjoCcCtx ctx, boolean staticAccess) {
        List vars = ctx.getJstTypeSpaceMgr().getQueryExecutor().getAllGlobalVars(ctx.getGroupName());
        for (IJstNode node : vars) {
            IJstGlobalVar jsvar;
            if (node instanceof IJstMethod) {
                this.appendData(ctx, node, staticAccess);
            }
            if (node instanceof IJstProperty) {
                this.appendData(ctx, node, staticAccess);
            }
            if (!(node instanceof IJstGlobalVar) || (jsvar = (IJstGlobalVar)node).getScopeForGlobal() != null) continue;
            if (jsvar.isFunc()) {
                this.appendData(ctx, (IJstNode)jsvar.getFunction(), staticAccess);
                continue;
            }
            this.appendData(ctx, (IJstNode)jsvar.getProperty(), staticAccess);
        }
    }

    private void proposePropertiesAndMethodsUnderAttributor(VjoCcCtx ctx, String token, String attributorTypeName) {
        ITypeSpace typeSpace = ctx.getJstTypeSpaceMgr().getTypeSpace();
        IJstType actingType = ctx.getActingType();
        if (actingType == null) {
            return;
        }
        List availableDependencies = typeSpace.getAllDependencies(new TypeName(ctx.getGroupName(), actingType.getName()));
        String attributeName = this.getAttributeName(token);
        boolean staticAccess = this.isStaticAccess(token);
        boolean found = false;
        for (IJstType available : availableDependencies) {
            if (!available.getName().equals(attributorTypeName) && !available.getSimpleName().equals(attributorTypeName)) continue;
            this.proposePropertiesAndMethodsOfType(ctx, staticAccess, available, attributeName);
            found = true;
        }
        if (!found) {
            IJstType globalType = ctx.getJstTypeSpaceMgr().getQueryExecutor().findType(new TypeName("JsNativeLib", attributorTypeName));
            if (globalType == null) {
                globalType = ctx.getJstTypeSpaceMgr().getQueryExecutor().findType(new TypeName("JsBrowserLib", attributorTypeName));
            }
            if (globalType == null) {
                globalType = ctx.getJstTypeSpaceMgr().getQueryExecutor().findGlobalType(null, attributorTypeName);
            }
            if (globalType != null) {
                this.proposePropertiesAndMethodsOfType(ctx, staticAccess, globalType, attributeName);
            }
        }
    }

    private void proposePropertiesAndMethodsOfType(VjoCcCtx ctx, boolean staticAccess, IJstType available, String attributeName) {
        for (IJstProperty pty : available.getAllPossibleProperties(staticAccess, false)) {
            if (pty instanceof JstVjoProperty || pty instanceof JstVjoBaseProperty || !pty.getName().getName().startsWith(attributeName)) continue;
            this.appendData(ctx, (IJstNode)pty);
        }
        for (IJstProperty pty : available.getAllPossibleProperties(!staticAccess, false)) {
            if (pty instanceof JstVjoProperty || pty instanceof JstVjoBaseProperty || !pty.getName().getName().startsWith(attributeName)) continue;
            this.appendData(ctx, (IJstNode)pty);
        }
        for (IJstMethod mtd : available.getMethods(staticAccess, false)) {
            if (!mtd.getName().getName().startsWith(attributeName)) continue;
            if (!mtd.isDispatcher()) {
                this.appendData(ctx, (IJstNode)mtd);
                continue;
            }
            for (IJstMethod overload : mtd.getOverloaded()) {
                this.appendData(ctx, (IJstNode)overload);
            }
        }
        for (IJstMethod mtd : available.getMethods(!staticAccess, false)) {
            if (!mtd.getName().getName().startsWith(attributeName)) continue;
            if (!mtd.isDispatcher()) {
                this.appendData(ctx, (IJstNode)mtd);
                continue;
            }
            for (IJstMethod overload : mtd.getOverloaded()) {
                this.appendData(ctx, (IJstNode)overload);
            }
        }
    }

    private String getAttributorTypeName(String token) {
        if (token == null) {
            return null;
        }
        int colonIndex = token.indexOf(58);
        if (colonIndex >= 0) {
            return token.substring(0, colonIndex);
        }
        return token;
    }

    private String getAttributeName(String token) {
        if (token == null) {
            return null;
        }
        int colonIndex = token.lastIndexOf(58);
        if (colonIndex >= 0) {
            if (colonIndex + 1 == token.length()) {
                return "";
            }
            return token.substring(colonIndex + 1);
        }
        return token;
    }

    private boolean isStaticAccess(String token) {
        if (token == null) {
            return false;
        }
        return token.indexOf("::") >= 0;
    }
}

