/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcHandler;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoAttributedProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCCVjoUtilityAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcAliasProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcCTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcConstructorGenProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcDerivedPropMethodAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcEnumElementAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcFunctionArgumentAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcFunctionGenProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcGlobalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcGlobalExtensionAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcInterfaceProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcKeywordAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcKeywordInCommentProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcKeywordInMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcMTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcNeedsItemProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcObjLiteralAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcOuterPropMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcOverrideProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcOwnerTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcPackageProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcParameterHintAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcParameterProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcPropMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcStaticPropMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcThisProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcTypeNameAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcTypeNameAliasProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcVariableProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.handler.VjoCcCommentHandler;
import org.eclipse.vjet.vjo.tool.codecompletion.handler.VjoCcHandler;

public class VjoCcAdvisorManager {
    private static final boolean DEBUG = false;
    private static Map<String, IVjoCcAdvisor> s_advisorMap = new HashMap<String, IVjoCcAdvisor>();
    private IVjoCcHandler m_handler;
    private IVjoCcHandler m_commentHandler;

    static {
        VjoCcAdvisorManager.registryAdvisor(new VjoCcPackageProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcTypeProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcTypeNameAliasProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoAttributedProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcOwnerTypeProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcAliasProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcOverrideProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcConstructorGenProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcFunctionGenProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcNeedsItemProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcCTypeProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcInterfaceProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcMTypeProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcKeywordAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcKeywordInMethodProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcKeywordInCommentProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCCVjoUtilityAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcThisProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcVariableProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcOuterPropMethodProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcPropMethodProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcDerivedPropMethodAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcParameterHintAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcParameterProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcStaticPropMethodProposalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcEnumElementAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcGlobalAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcGlobalExtensionAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcTypeNameAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcObjLiteralAdvisor());
        VjoCcAdvisorManager.registryAdvisor(new VjoCcFunctionArgumentAdvisor());
    }

    public VjoCcAdvisorManager() {
        this.m_handler = new VjoCcHandler();
        this.m_commentHandler = new VjoCcCommentHandler();
    }

    public VjoCcAdvisorManager(IVjoCcHandler handler) {
        this.m_handler = handler != null ? handler : new VjoCcHandler();
    }

    public VjoCcAdvisorManager(IVjoCcHandler handler, IVjoCcHandler commentHandler) {
        this(handler);
        this.m_commentHandler = commentHandler != null ? commentHandler : new VjoCcCommentHandler();
    }

    public void advise(VjoCcCtx ctx) {
        String[] advisorIds = this.getAdvisorIds(ctx);
        ctx.setAdvisors(advisorIds);
        if (advisorIds.length == 0) {
            return;
        }
        String[] stringArray = advisorIds;
        int n = advisorIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IVjoCcAdvisor advisor = VjoCcAdvisorManager.getAdvisor(id);
            if (advisor != null) {
                advisor.advise(ctx);
            }
            ++n2;
        }
    }

    public String[] getAdvisorIds(VjoCcCtx ctx) {
        if (ctx.isInCommentArea()) {
            return this.m_commentHandler.handle(ctx);
        }
        return this.m_handler.handle(ctx);
    }

    protected List<IVjoCcAdvisor> getAllAdvisors() {
        Iterator<IVjoCcAdvisor> it = s_advisorMap.values().iterator();
        ArrayList<IVjoCcAdvisor> result = new ArrayList<IVjoCcAdvisor>();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static void registryAdvisor(IVjoCcAdvisor advisor) {
        String id = advisor.getId();
        if (id != null && !s_advisorMap.containsKey(id)) {
            s_advisorMap.put(id, advisor);
        }
    }

    public static IVjoCcAdvisor getAdvisor(String id) {
        if (s_advisorMap.containsKey(id)) {
            return s_advisorMap.get(id);
        }
        return null;
    }

    protected boolean accept(VjoCcCtx ctx, IVjoCcAdvisor advisor) {
        return true;
    }
}

