/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.util;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.vjet.dsf.common.exceptions.BaseRuntimeException;

public final class JdkUtil {
    private static final Map<Class, Object> s_loadedClasses = Collections.synchronizedMap(new WeakHashMap(50000));

    public static Class forceInit(Class klass) {
        if (!s_loadedClasses.containsKey(klass)) {
            try {
                ClassLoader loader = klass.getClassLoader();
                if (loader != null) {
                    Class.forName(klass.getName(), true, loader);
                }
                s_loadedClasses.put(klass, null);
            }
            catch (ClassNotFoundException e) {
                throw new BaseRuntimeException(e.getMessage(), e);
            }
        }
        return klass;
    }
}

