/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;

public class JavaSourceLocator {
    private static JavaSourceLocator s_instance = new JavaSourceLocator();
    private URLClassLoader m_loader;
    private String m_sourcePath = null;
    private static boolean s_isUnix = ":".equals(File.pathSeparator);
    private static final String WINDOW_URL_PROTO = "file:/";
    private static final String UNIX_URL_PROTO = "file://";

    private JavaSourceLocator() {
        this.reset();
    }

    public static JavaSourceLocator getInstance() {
        if (JavaSourceLocator.s_instance.m_sourcePath != null && !JavaSourceLocator.s_instance.m_sourcePath.equals(System.getProperty("java.source.path"))) {
            s_instance.reset();
        }
        return s_instance;
    }

    public void reset() {
        try {
            this.m_sourcePath = System.getProperty("java.source.path");
            this.m_sourcePath = this.determineSourcePath(this.m_sourcePath);
            if (this.m_sourcePath != null && this.m_sourcePath.length() != 0) {
                this.m_loader = new URLClassLoader(JavaSourceLocator.getSourcePathUrls(this.m_sourcePath, false));
            } else {
                String classPath = System.getProperty("java.class.path");
                ClassLoader clzLoader = this.getClass().getClassLoader();
                if (clzLoader instanceof URLClassLoader) {
                    URL[] urls;
                    StringBuilder sb = new StringBuilder();
                    URL[] uRLArray = urls = ((URLClassLoader)clzLoader).getURLs();
                    int n = urls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        URL url = uRLArray[n2];
                        String path = url.getPath();
                        if (path.endsWith("/bin/")) {
                            sb.append(File.pathSeparator);
                            sb.append(path.substring(0, path.length() - 1));
                        }
                        ++n2;
                    }
                    classPath = String.valueOf(classPath) + sb.toString();
                }
                this.m_loader = new URLClassLoader(JavaSourceLocator.getSourcePathUrls(classPath, true));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public URLClassLoader getClassLoader() {
        return this.m_loader;
    }

    private String determineSourcePath(String sourcePath) {
        int n;
        int n2;
        String[] stringArray;
        String projectRoot = System.getProperty("java.source.projectRoot");
        String projectList = System.getProperty("java.source.projectList");
        String jarRoot = System.getProperty("java.source.jarRoot");
        String jarList = System.getProperty("java.source.jarList");
        StringBuilder sb = new StringBuilder();
        if (sourcePath != null && sourcePath.length() != 0) {
            sb.append(sourcePath);
            sb.append(File.pathSeparator);
        }
        if (projectRoot != null && !projectRoot.equals("") && projectList != null && projectList.equals("")) {
            String[] projList;
            stringArray = projList = projectList.split(",");
            n2 = projList.length;
            n = 0;
            while (n < n2) {
                String project = stringArray[n];
                sb.append(String.valueOf(projectRoot) + File.separatorChar + project);
                sb.append(File.pathSeparator);
                ++n;
            }
        }
        if (jarRoot != null && jarRoot.length() != 0 && jarList != null && jarList.length() != 0) {
            String[] libList;
            stringArray = libList = jarList.split(",");
            n2 = libList.length;
            n = 0;
            while (n < n2) {
                String lib = stringArray[n];
                sb.append(String.valueOf(jarRoot) + lib);
                sb.append(File.pathSeparator);
                ++n;
            }
        }
        if (sb.toString().equalsIgnoreCase("")) {
            return null;
        }
        return sb.toString();
    }

    public URL getSourceUrl(Class clz) {
        return this.getSourceUrl(clz.getName());
    }

    public URL getSourceUrl(String clzName) {
        return this.getSourceUrl(clzName, ".java");
    }

    public URL getSourceUrl(String sourceName, String suffix) {
        String baseUri = sourceName.replace(".", "/");
        String fileName = String.valueOf(baseUri) + suffix;
        return this.m_loader.findResource(fileName);
    }

    public String getSource(Class clz) {
        return this.getSource(this.getSourceUrl(clz));
    }

    public String getSource(String clzName) {
        return this.getSource(this.getSourceUrl(clzName));
    }

    public String getSource(String clzName, String suffix) {
        return this.getSource(this.getSourceUrl(clzName, suffix));
    }

    public String getSource(URL url) {
        if (url == null) {
            return null;
        }
        try {
            byte[] buffer = new byte[1024];
            StringWriter sw = new StringWriter();
            InputStream is = url.openStream();
            int i = 0;
            while ((i = is.read(buffer)) > 0) {
                sw.write(new String(buffer, 0, i));
            }
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static URL[] getSourcePathUrls(String path, boolean isClzPath) throws MalformedURLException {
        String fileUrlProto = s_isUnix ? UNIX_URL_PROTO : WINDOW_URL_PROTO;
        path = path.replace("\\", "/");
        path = path.replace("//", "/");
        ArrayList<URL> urlList = new ArrayList<URL>();
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        HashSet<String> uris = new HashSet<String>();
        while (st.hasMoreElements()) {
            String value = st.nextToken();
            if (!s_isUnix && value.startsWith("/")) {
                value = value.substring(1);
            }
            if (uris.contains(value)) continue;
            uris.add(value);
            if (value.endsWith(".jar") || value.endsWith(".zip")) {
                if (isClzPath) continue;
                urlList.add(new URL("jar:" + fileUrlProto + value + "!/"));
                continue;
            }
            if (!isClzPath || value.endsWith("/src")) {
                if (!value.endsWith("/")) {
                    value = String.valueOf(value) + "/";
                }
                urlList.add(new URL(String.valueOf(fileUrlProto) + value));
                continue;
            }
            if (!isClzPath || !value.endsWith("/bin")) continue;
            String srcFile = String.valueOf(value.substring(0, value.length() - 4)) + "/src/";
            try {
                if (!new File(srcFile).exists()) continue;
                URL srcUrl = new URL(String.valueOf(fileUrlProto) + srcFile);
                urlList.add(srcUrl);
            }
            catch (Exception exception) {}
        }
        URL[] urls = new URL[urlList.size()];
        return urlList.toArray(urls);
    }
}

