/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.json;

import java.text.ParseException;
import java.util.Iterator;
import org.eclipse.vjet.dsf.json.JsonArray;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.json.XmlTokener;

public class XmlConvertor {
    public static final Character AMP = new Character('&');
    public static final Character APOS = new Character('\'');
    public static final Character BANG = new Character('!');
    public static final Character EQ = new Character('=');
    public static final Character GT = new Character('>');
    public static final Character LT = new Character('<');
    public static final Character QUEST = new Character('?');
    public static final Character QUOT = new Character('\"');
    public static final Character SLASH = new Character('/');

    public static String escape(String string) {
        if (string.indexOf("&") == -1 && string.indexOf("<") == -1 && string.indexOf(">") == -1 && string.indexOf("\"") == -1) {
            return string;
        }
        int size = string.length();
        StringBuffer sb = new StringBuffer(size + 20);
        int i = 0;
        while (i < size) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static boolean parse(XmlTokener x, JsonObject context, String name) throws ParseException {
        String s;
        Object t = x.nextToken();
        if (t == BANG) {
            char c = x.next();
            if (c == '-') {
                if (x.next() == '-') {
                    x.skipPast("-->");
                    return false;
                }
                x.back();
            } else if (c == '[') {
                x.skipPast("]]>");
                return false;
            }
            int i = 1;
            do {
                if ((t = x.nextMeta()) == null) {
                    throw x.syntaxError("Missing '>' after '<!'.");
                }
                if (t == LT) {
                    ++i;
                    continue;
                }
                if (t != GT) continue;
                --i;
            } while (i > 0);
            return false;
        }
        if (t == QUEST) {
            x.skipPast("?>");
            return false;
        }
        if (t == SLASH) {
            if (name == null || !x.nextToken().equals(name)) {
                throw x.syntaxError("Mismatched close tag");
            }
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (t instanceof Character) {
            throw x.syntaxError("Misshaped tag");
        }
        String n = (String)t;
        t = null;
        JsonObject o = new JsonObject();
        while (true) {
            if (t == null) {
                t = x.nextToken();
            }
            if (!(t instanceof String)) break;
            s = (String)t;
            t = x.nextToken();
            if (t == EQ) {
                t = x.nextToken();
                if (!(t instanceof String)) {
                    throw x.syntaxError("Missing value");
                }
                o.accumulate(s, t);
                t = null;
                continue;
            }
            o.accumulate(s, Boolean.TRUE);
        }
        if (t == SLASH) {
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped tag");
            }
            if (o.length() == 0) {
                context.accumulate(n, Boolean.TRUE);
            } else {
                context.accumulate(n, o);
            }
            return false;
        }
        if (t == GT) {
            while (true) {
                if ((t = x.nextContent()) == null) {
                    if (name != null) {
                        throw x.syntaxError("Unclosed tag " + name);
                    }
                    return false;
                }
                if (t instanceof String) {
                    s = (String)t;
                    if (s.length() <= 0) continue;
                    o.accumulate("content", s);
                    continue;
                }
                if (t == LT && XmlConvertor.parse(x, o, n)) break;
            }
            if (o.length() == 0) {
                context.accumulate(n, Boolean.TRUE);
            } else if (o.length() == 1 && o.opt("content") != null) {
                context.accumulate(n, o.opt("content"));
            } else {
                context.accumulate(n, o);
            }
            return false;
        }
        throw x.syntaxError("Misshaped tag");
    }

    public static JsonObject toJSONObject(String string) throws ParseException {
        JsonObject o = new JsonObject();
        XmlTokener x = new XmlTokener(string);
        while (x.more()) {
            x.skipPast("<");
            XmlConvertor.parse(x, o, null);
        }
        return o;
    }

    public static String toString(Object o) {
        return XmlConvertor.toString(o, null);
    }

    public static String toString(Object o, String tagName) {
        StringBuffer a = null;
        StringBuffer b = new StringBuffer();
        if (o instanceof JsonObject) {
            if (tagName != null) {
                a = new StringBuffer();
                a.append('<');
                a.append(tagName);
            }
            JsonObject jo = (JsonObject)o;
            Iterator<String> keys = jo.keys();
            while (keys.hasNext()) {
                String k = keys.next().toString();
                Object v = jo.get(k);
                String s = v instanceof String ? (String)v : null;
                if (tagName == null || v instanceof JsonObject || s != null && k != "content" && (s.length() > 60 || s.indexOf(34) >= 0 && s.indexOf(39) >= 0)) {
                    b.append(XmlConvertor.toString(v, k));
                    continue;
                }
                if (k.equals("content")) {
                    b.append(XmlConvertor.escape(v.toString()));
                    continue;
                }
                if (v instanceof JsonArray) {
                    JsonArray ja = (JsonArray)v;
                    int len = ja.length();
                    int i = 0;
                    while (i < len) {
                        b.append(XmlConvertor.toString(ja.get(i), k));
                        ++i;
                    }
                    continue;
                }
                a.append(' ');
                a.append(k);
                a.append('=');
                a.append(XmlConvertor.toString(v));
            }
            if (tagName != null) {
                if (b.length() == 0) {
                    a.append("/>");
                } else {
                    a.append('>');
                    a.append(b);
                    a.append("</");
                    a.append(tagName);
                    a.append('>');
                }
                return a.toString();
            }
            return b.toString();
        }
        if (o instanceof JsonArray) {
            JsonArray ja = (JsonArray)o;
            int len = ja.length();
            int i = 0;
            while (i < len) {
                b.append(XmlConvertor.toString(ja.opt(i), tagName == null ? "array" : tagName));
                ++i;
            }
            return b.toString();
        }
        String s = o == null ? "null" : XmlConvertor.escape(o.toString());
        return tagName == null ? "\"" + s + "\"" : "<" + tagName + ">" + s + "</" + tagName + ">";
    }
}

