/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.json;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.json.JsonTokener;

public class JsonArray {
    private ArrayList<Object> m_myArrayList;

    public JsonArray() {
        this.m_myArrayList = new ArrayList();
    }

    public JsonArray(JsonTokener x) throws ParseException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray must start with '['");
        }
        if (x.nextClean() == ']') {
            return;
        }
        x.back();
        block4: while (true) {
            if (x.nextClean() == ',') {
                x.back();
                this.m_myArrayList.add(null);
            } else {
                x.back();
                this.m_myArrayList.add(x.nextValue());
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == ']') {
                        return;
                    }
                    x.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or ']'");
    }

    public JsonArray(String string) throws ParseException {
        this(new JsonTokener(string));
    }

    public JsonArray(Collection<Object> collection) {
        this.m_myArrayList = new ArrayList<Object>(collection);
    }

    public Object get(int index) throws NoSuchElementException {
        Object o = this.opt(index);
        if (o == null) {
            throw new NoSuchElementException("JSONArray[" + index + "] not found.");
        }
        return o;
    }

    ArrayList<Object> getArrayList() {
        return this.m_myArrayList;
    }

    public boolean getBoolean(int index) throws ClassCastException, NoSuchElementException {
        Object o = this.get(index);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new ClassCastException("JSONArray[" + index + "] not a Boolean.");
    }

    public double getDouble(int index) throws NoSuchElementException, NumberFormatException {
        Object o = this.get(index);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return new Double((String)o);
        }
        throw new NumberFormatException("JSONObject[" + index + "] is not a number.");
    }

    public int getInt(int index) throws NoSuchElementException, NumberFormatException {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(index);
    }

    public JsonArray getJSONArray(int index) throws NoSuchElementException {
        Object o = this.get(index);
        if (o instanceof JsonArray) {
            return (JsonArray)o;
        }
        throw new NoSuchElementException("JSONArray[" + index + "] is not a JSONArray.");
    }

    public JsonObject getJSONObject(int index) throws NoSuchElementException {
        Object o = this.get(index);
        if (o instanceof JsonObject) {
            return (JsonObject)o;
        }
        throw new NoSuchElementException("JSONArray[" + index + "] is not a JSONObject.");
    }

    public String getString(int index) throws NoSuchElementException {
        return this.get(index).toString();
    }

    public boolean isNull(int index) {
        Object o = this.opt(index);
        return o == null || o.equals(null);
    }

    public String join(String separator) {
        StringBuilder sb = new StringBuilder(this.getSerializedSize());
        return this.appendJoin(separator, sb).toString();
    }

    private StringBuilder appendJoin(String separator, StringBuilder sb) {
        int len = this.length();
        int i = 0;
        while (i < len) {
            if (i > 0) {
                sb.append(separator);
            }
            JsonObject.appendValue(this.m_myArrayList.get(i), sb);
            ++i;
        }
        return sb;
    }

    public int length() {
        return this.m_myArrayList.size();
    }

    public Object opt(int index) {
        return index < 0 || index >= this.length() ? null : this.m_myArrayList.get(index);
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        Object o = this.opt(index);
        if (o != null) {
            if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
                return false;
            }
            if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
                return true;
            }
        }
        return defaultValue;
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double defaultValue) {
        Object o = this.opt(index);
        if (o != null) {
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            try {
                return new Double((String)o);
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int defaultValue) {
        Object o = this.opt(index);
        if (o != null) {
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            try {
                return Integer.parseInt((String)o);
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public JsonArray optJSONArray(int index) {
        Object o = this.opt(index);
        return o instanceof JsonArray ? (JsonArray)o : null;
    }

    public JsonObject optJSONObject(int index) {
        Object o = this.opt(index);
        return o instanceof JsonObject ? (JsonObject)o : null;
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String defaultValue) {
        Object o = this.opt(index);
        return o != null ? o.toString() : defaultValue;
    }

    public JsonArray put(boolean value) {
        this.put(value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JsonArray put(double value) {
        this.put(new Double(value));
        return this;
    }

    public JsonArray put(int value) {
        this.put(new Integer(value));
        return this;
    }

    public JsonArray put(Object value) {
        this.m_myArrayList.add(value);
        return this;
    }

    public JsonArray put(int index, boolean value) {
        this.put(index, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JsonArray put(int index, double value) {
        this.put(index, new Double(value));
        return this;
    }

    public JsonArray put(int index, int value) {
        this.put(index, new Integer(value));
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public JsonArray put(int index, Object value) throws NoSuchElementException, NullPointerException {
        block3: {
            if (index < 0) {
                throw new NoSuchElementException("JSONArray[" + index + "] not found.");
            }
            if (value == null) {
                throw new NullPointerException();
            }
            if (index >= this.length()) ** GOTO lbl11
            this.m_myArrayList.set(index, value);
            break block3;
lbl-1000:
            // 1 sources

            {
                this.put(null);
lbl11:
                // 2 sources

                ** while (index != this.length())
            }
lbl12:
            // 1 sources

            this.put(value);
        }
        return this;
    }

    public JsonObject toJSONObject(JsonArray names) {
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        JsonObject jo = new JsonObject();
        int i = 0;
        while (i < names.length()) {
            jo.put(names.getString(i), this.opt(i));
            ++i;
        }
        return jo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getSerializedSize());
        return this.append(sb).toString();
    }

    StringBuilder append(StringBuilder sb) {
        sb.append('[');
        this.appendJoin(",", sb);
        sb.append(']');
        return sb;
    }

    int getSerializedSize() {
        int arraySize = this.length();
        int value = 2 + arraySize;
        for (Object obj : this.m_myArrayList) {
            value += JsonObject.getValueSize(obj);
        }
        return (int)(1.2 * (double)value);
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) {
        int len = this.length();
        if (len == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        if (len == 1) {
            sb.append(JsonObject.valueToString(this.m_myArrayList.get(0), indentFactor, indent));
        } else {
            int newindent = indent + indentFactor;
            sb.append('\n');
            int i = 0;
            while (i < len) {
                if (i > 0) {
                    sb.append(",\n");
                }
                int j = 0;
                while (j < newindent) {
                    sb.append(' ');
                    ++j;
                }
                sb.append(JsonObject.valueToString(this.m_myArrayList.get(i), indentFactor, newindent));
                ++i;
            }
            sb.append('\n');
            i = 0;
            while (i < indent) {
                sb.append(' ');
                ++i;
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

