/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.common.xml.XmlStreamException;

public class XmlStreamWriter
implements IXmlStreamWriter {
    protected static final char[] AMP_ESCAPE_CHARS = new char[]{'&', 'a', 'm', 'p', ';'};
    protected static final char[] LT_ESCAPE_CHARS = new char[]{'&', 'l', 't', ';'};
    protected static final char[] GT_ESCAPE_CHARS = new char[]{'&', 'g', 't', ';'};
    protected static final char[] QUOT_ESCAPE_CHARS = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    protected static final char[] SINGLE_SPACE_CHARS = new char[]{' '};
    protected static final char[] DOUBLE_QUOTE_CHARS = new char[]{'\"'};
    protected static final char[] EQUALS_SIGN_DOUBLE_QUOTE_CHARS = new char[]{'=', '\"'};
    protected static final char[] CDATA_END_CHARS = new char[]{']', ']', '>'};
    protected static final char[] CDATA_START_CHARS = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    protected static final char[] COMMENT_END_CHARS = new char[]{'-', '-', '>'};
    protected static final char[] COMMENT_START_CHARS = new char[]{'<', '!', '-', '-'};
    protected static final char[] SINGLE_LT_CHARS = new char[]{'<'};
    protected static final char[] SINGLE_GT_CHARS = new char[]{'>'};
    protected static final char[] LT_SLASH_CHARS = new char[]{'<', '/'};
    protected static final char[] SLASH_CHARS = new char[]{'/'};
    protected final ArrayList<String> m_tagStack = new ArrayList(20);
    protected final Writer m_writer;
    protected final IIndenter m_indenter;
    protected boolean m_inStartTag = false;

    public XmlStreamWriter(Writer writer) {
        this(writer, new IIndenter.Pretty());
    }

    public XmlStreamWriter(Writer writer, IIndenter indenter) {
        this.m_writer = writer;
        this.m_indenter = indenter;
    }

    @Override
    public void writeAttribute(char[] key, String value) throws XmlStreamException {
        try {
            this.m_writer.write(SINGLE_SPACE_CHARS);
            this.m_writer.write(key);
            this.m_writer.write(EQUALS_SIGN_DOUBLE_QUOTE_CHARS);
            this.writeEscapedVal(value, true);
            this.m_writer.write(DOUBLE_QUOTE_CHARS);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeAttribute(String key, String value) throws XmlStreamException {
        try {
            this.m_writer.write(SINGLE_SPACE_CHARS);
            this.m_writer.write(key);
            this.m_writer.write(EQUALS_SIGN_DOUBLE_QUOTE_CHARS);
            this.writeEscapedVal(value, true);
            this.m_writer.write(DOUBLE_QUOTE_CHARS);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    private void writeEscapedVal(String value, boolean escapeQuotes) throws IOException {
        this.handleChars(value, value.length(), escapeQuotes);
    }

    private void handleChars(String chars, int count, boolean escapeQuotes) throws IOException {
        int okCharCount = 0;
        int offset = 0;
        int i = 0;
        while (i < count) {
            char c = chars.charAt(i);
            char[] escapeChars = null;
            switch (c) {
                case '&': {
                    escapeChars = AMP_ESCAPE_CHARS;
                    break;
                }
                case '<': {
                    escapeChars = LT_ESCAPE_CHARS;
                    break;
                }
                case '>': {
                    escapeChars = GT_ESCAPE_CHARS;
                    break;
                }
                case '\"': {
                    if (escapeQuotes) {
                        escapeChars = QUOT_ESCAPE_CHARS;
                        break;
                    }
                }
                default: {
                    ++okCharCount;
                }
            }
            if (escapeChars != null) {
                this.m_writer.write(chars, offset, okCharCount);
                this.m_writer.write(escapeChars);
                offset = offset + okCharCount + 1;
                okCharCount = 0;
            }
            ++i;
        }
        this.m_writer.write(chars, offset, okCharCount);
    }

    @Override
    public void writeCData(String data) throws XmlStreamException {
        try {
            this.closeStartTagIfNecessary();
            this.m_writer.write(CDATA_START_CHARS);
            this.m_writer.write(data);
            this.m_writer.write(CDATA_END_CHARS);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeRaw(String data) throws XmlStreamException {
        try {
            this.closeStartTagIfNecessary();
            this.m_writer.write(data);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeCharacters(final char[] text, final int start, final int len) throws XmlStreamException {
        CharSequence sequence = new CharSequence(){

            @Override
            public char charAt(int index) {
                return text[start + index];
            }

            @Override
            public int length() {
                return len;
            }

            @Override
            public CharSequence subSequence(int begin, int end) {
                throw new RuntimeException("not implemented");
            }
        };
        this.writeEscapedForElementBlock(sequence);
    }

    @Override
    public void writeCharacters(String text) throws XmlStreamException {
        this.closeStartTagIfNecessary();
        try {
            this.writeEscapedVal(text, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeEscapedForElementBlock(CharSequence sequence) {
        try {
            this.closeStartTagIfNecessary();
            int sequenceLength = sequence.length();
            int i = 0;
            while (i < sequenceLength) {
                char c = sequence.charAt(i);
                switch (c) {
                    case '&': {
                        this.m_writer.write(AMP_ESCAPE_CHARS);
                        break;
                    }
                    case '<': {
                        this.m_writer.write(LT_ESCAPE_CHARS);
                        break;
                    }
                    case '>': {
                        this.m_writer.write(GT_ESCAPE_CHARS);
                        break;
                    }
                    default: {
                        this.m_writer.write(c);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeComment(String data) throws XmlStreamException {
        try {
            this.closeStartTagIfNecessary();
            this.m_writer.write(COMMENT_START_CHARS);
            this.m_writer.write(data);
            this.m_writer.write(COMMENT_END_CHARS);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeDtd(String dtd) {
        this.writeRaw(dtd);
        if (!dtd.endsWith("\n")) {
            this.writeRaw("\r\n");
        }
    }

    @Override
    public void writeEmptyElement(String tagName) throws XmlStreamException {
        throw new RuntimeException("not implemented!");
    }

    @Override
    public void writeEndDocument() throws XmlStreamException {
        while (this.m_tagStack.size() > 0) {
            this.writeEndElement();
        }
        try {
            this.m_writer.flush();
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeStartDocument() throws XmlStreamException {
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XmlStreamException {
    }

    @Override
    public void writeStartDocument(String version) throws XmlStreamException {
    }

    @Override
    public void writeEndElement() throws XmlStreamException {
        String tagName = this.m_tagStack.remove(this.m_tagStack.size() - 1);
        try {
            if (this.m_inStartTag) {
                this.m_writer.write(SLASH_CHARS);
                this.writeClosingStartTag();
            } else {
                this.m_indenter.indent(this.m_writer, this.m_tagStack.size());
                this.m_writer.write(LT_SLASH_CHARS);
                this.m_writer.write(tagName);
                this.m_writer.write(SINGLE_GT_CHARS);
            }
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeStartElement(char[] tagNameAsChars) throws XmlStreamException {
        try {
            this.closeStartTagIfNecessary();
            this.m_indenter.indent(this.m_writer, this.m_tagStack.size());
            this.m_writer.write(SINGLE_LT_CHARS);
            this.m_writer.write(tagNameAsChars);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
        String tagName = new String(tagNameAsChars);
        this.m_tagStack.add(tagName);
        this.m_inStartTag = true;
    }

    @Override
    public void writeStartElement(String tagName) throws XmlStreamException {
        try {
            this.closeStartTagIfNecessary();
            this.m_indenter.indent(this.m_writer, this.m_tagStack.size());
            this.m_writer.write(SINGLE_LT_CHARS);
            this.m_writer.write(tagName);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
        this.m_tagStack.add(tagName);
        this.m_inStartTag = true;
    }

    protected void closeStartTagIfNecessary() throws XmlStreamException {
        if (this.m_inStartTag) {
            this.writeClosingStartTag();
        }
    }

    private void writeClosingStartTag() {
        try {
            this.m_writer.write(SINGLE_GT_CHARS);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
        this.m_inStartTag = false;
    }

    @Override
    public void flush() throws XmlStreamException {
        try {
            this.m_writer.flush();
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    protected String getCurrentTagName() {
        return this.m_tagStack.get(this.m_tagStack.size() - 1);
    }

    @Override
    public void writeRawCharacters(char[] text, int start, int len) {
        try {
            this.closeStartTagIfNecessary();
            this.m_writer.write(text, start, len);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    public String toString() {
        return this.m_writer.toString();
    }
}

