/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.xml;

import java.io.IOException;
import java.io.Writer;

public class CharArrayWriterF
extends Writer {
    private char[] m_buf;
    private int m_count;

    public CharArrayWriterF(char[] buf) {
        this.setBackingChars(buf);
    }

    public char[] getBackingChars() {
        return this.m_buf;
    }

    public void setBackingChars(char[] buf) {
        if (buf == null || buf.length == 0) {
            throw new RuntimeException("Backing char[] must not be null or of size 0");
        }
        this.m_buf = buf;
    }

    @Override
    public void write(int c) {
        int newcount = this.m_count + 1;
        this.grow(newcount);
        this.m_buf[this.m_count] = (char)c;
        this.m_count = newcount;
    }

    @Override
    public void write(char[] c, int off, int len) {
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.m_count + len;
        this.grow(newcount);
        System.arraycopy(c, off, this.m_buf, this.m_count, len);
        this.m_count = newcount;
    }

    @Override
    public void write(String str, int off, int len) {
        int newcount = this.m_count + len;
        this.grow(newcount);
        str.getChars(off, off + len, this.m_buf, this.m_count);
        this.m_count = newcount;
    }

    public void writeTo(Writer out) throws IOException {
        out.write(this.m_buf, 0, this.m_count);
    }

    @Override
    public CharArrayWriterF append(CharSequence csq) {
        String s = csq == null ? "null" : csq.toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public CharArrayWriterF append(CharSequence csq, int start, int end) {
        String s = (csq == null ? "null" : csq).subSequence(start, end).toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public CharArrayWriterF append(char c) {
        this.write(c);
        return this;
    }

    public void reset() {
        this.m_count = 0;
    }

    public char[] toCharArray() {
        char[] newbuf = new char[this.m_count];
        System.arraycopy(this.m_buf, 0, newbuf, 0, this.m_count);
        return newbuf;
    }

    public int size() {
        return this.m_count;
    }

    public String toString() {
        return new String(this.m_buf, 0, this.m_count);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private void grow(int newcount) {
        if (newcount > this.m_buf.length) {
            char[] newbuf = new char[Math.max(this.m_buf.length << 1, newcount)];
            System.arraycopy(this.m_buf, 0, newbuf, 0, this.m_count);
            this.m_buf = newbuf;
        }
    }
}

