/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.tracer;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.vjet.dsf.common.xml.XmlEncoder;

public class TraceUtil {
    public static String getClassName(Object caller) {
        String name = caller.getClass().getName();
        int start = name.lastIndexOf(46);
        if (start != -1) {
            name = name.substring(start + 1);
        }
        return name;
    }

    public static String getMethodName(Object caller, Throwable t) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(stream));
        Class<?> cls = caller.getClass();
        String clsName = cls.getName();
        String stackTrace = stream.toString();
        int index = stackTrace.indexOf(clsName);
        while (index < 1) {
            if ((cls = cls.getSuperclass()) == null) {
                return "NotFound";
            }
            clsName = cls.getName();
            index = stackTrace.indexOf(clsName);
        }
        int start = stackTrace.indexOf(clsName) + clsName.length() + 1;
        int end = stackTrace.indexOf("(", start);
        return XmlEncoder.encode(stackTrace.substring(start, end));
    }

    public static String getType(Object obj) {
        if (obj == null) {
            return "Null";
        }
        String typeName = obj.getClass().getSimpleName();
        if (typeName.length() == 0) {
            typeName = obj.getClass().getName();
            int start = typeName.lastIndexOf(".");
            int end = typeName.lastIndexOf("$");
            typeName = String.valueOf(typeName.substring(start + 1, end)) + "_Inner";
        }
        return typeName;
    }
}

