/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.config.FilterKey;
import org.eclipse.vjet.dsf.common.trace.config.ListenerKey;

public final class TracerConfig {
    private String m_scope;
    private List<FilterKey> m_filters = new ArrayList<FilterKey>(1);
    private List<ListenerKey> m_listeners = new ArrayList<ListenerKey>(1);

    public TracerConfig(String scope) {
        if (scope == null) {
            DsfExceptionHelper.chuck("scope is null");
        }
        this.m_scope = scope;
    }

    public String getScope() {
        return this.m_scope;
    }

    public synchronized void addFilter(FilterKey filterKey) {
        if (filterKey == null || this.m_filters.contains(filterKey)) {
            return;
        }
        this.m_filters.add(filterKey);
    }

    public synchronized boolean removeFilter(FilterKey filterKey) {
        return this.m_filters.remove(filterKey);
    }

    public synchronized void removeAllFilters() {
        this.m_filters.clear();
    }

    public synchronized List<FilterKey> getFilters() {
        return Collections.unmodifiableList(this.m_filters);
    }

    public synchronized void addListener(ListenerKey listener) {
        if (listener == null || this.m_listeners.contains(listener)) {
            return;
        }
        this.m_listeners.add(listener);
    }

    public synchronized boolean removeListener(ListenerKey listener) {
        return this.m_listeners.remove(listener);
    }

    public synchronized void removeAllListeners() {
        this.m_listeners.clear();
    }

    public synchronized List<ListenerKey> getListeners() {
        return Collections.unmodifiableList(this.m_listeners);
    }
}

