/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.config;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.listener.ITraceEventListener;
import org.eclipse.vjet.dsf.common.trace.listener.ListenerId;

public final class ListenerKey {
    public static final String DELIMITER = ":";
    private Class<? extends ITraceEventListener> m_type;
    private ListenerId m_id;

    public ListenerKey(Class<? extends ITraceEventListener> type, String id) {
        this(type, new ListenerId(id));
    }

    public ListenerKey(Class<? extends ITraceEventListener> type, ListenerId id) {
        if (type == null) {
            DsfExceptionHelper.chuck("type is null");
        }
        if (type == ITraceEventListener.class) {
            DsfExceptionHelper.chuck("type is an interface");
        }
        if (id == null) {
            DsfExceptionHelper.chuck("id is null");
        }
        this.m_type = type;
        this.m_id = id;
    }

    public Class<? extends ITraceEventListener> getType() {
        return this.m_type;
    }

    public ListenerId getId() {
        return this.m_id;
    }

    public static ListenerKey parse(String value) {
        Class<?> listenerType;
        if (value == null || value.length() == 0) {
            return null;
        }
        int index = value.indexOf(DELIMITER);
        if (index < 0) {
            return null;
        }
        String typeName = value.substring(0, index).trim();
        String id = value.substring(index + 1).trim();
        if (typeName.length() == 0 || id.length() == 0) {
            return null;
        }
        try {
            listenerType = Class.forName(typeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        if (listenerType == ITraceEventListener.class) {
            return null;
        }
        return new ListenerKey(listenerType, id);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ListenerKey.class) {
            return false;
        }
        ListenerKey that = (ListenerKey)obj;
        return this.m_type == that.m_type && this.m_id.getName().equals(that.m_id.getName());
    }

    public int hashCode() {
        return this.m_type.hashCode() + this.m_id.getName().hashCode();
    }

    public String toString() {
        Z z = new Z();
        z.format("type", this.m_type);
        z.format("id", this.m_id.getName());
        return z.toString();
    }
}

