/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.config;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.introspect.ITraceObjectIntrospector;

public final class IntrospectorKey {
    public static final String DELIMITER = ":";
    private Class<? extends ITraceObjectIntrospector> m_type;
    private Class m_targetType;

    public IntrospectorKey(Class<? extends ITraceObjectIntrospector> type, Class targetType) {
        if (type == null) {
            DsfExceptionHelper.chuck("type is null");
        }
        if (type == ITraceObjectIntrospector.class) {
            DsfExceptionHelper.chuck("type is an interface");
        }
        if (targetType == null) {
            DsfExceptionHelper.chuck("targetType is null");
        }
        this.m_type = type;
        this.m_targetType = targetType;
    }

    public Class<? extends ITraceObjectIntrospector> getType() {
        return this.m_type;
    }

    public Class getTargetType() {
        return this.m_targetType;
    }

    public static IntrospectorKey parse(String value) {
        Class<?> targetType;
        Class<?> inspectorType;
        if (value == null || value.length() == 0) {
            return null;
        }
        int index = value.indexOf(DELIMITER);
        if (index < 0) {
            return null;
        }
        String typeName = value.substring(0, index).trim();
        String targetName = value.substring(index + 1).trim();
        if (typeName.length() == 0 || targetName.length() == 0) {
            return null;
        }
        try {
            inspectorType = Class.forName(typeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        if (inspectorType == ITraceObjectIntrospector.class) {
            return null;
        }
        try {
            targetType = Class.forName(targetName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        return new IntrospectorKey(inspectorType, targetType);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != IntrospectorKey.class) {
            return false;
        }
        IntrospectorKey that = (IntrospectorKey)obj;
        return this.m_type == that.m_type && this.m_targetType == that.m_targetType;
    }

    public int hashCode() {
        return this.m_type.hashCode() + this.m_targetType.hashCode();
    }

    public String toString() {
        Z z = new Z();
        z.format("type", this.m_type);
        z.format("targetType", this.m_targetType);
        return z.toString();
    }
}

