/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.config;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.handler.HandlerId;
import org.eclipse.vjet.dsf.common.trace.handler.ITraceEventHandler;

public final class HandlerKey {
    public static final String DELIMITER = ":";
    private Class<? extends ITraceEventHandler> m_type;
    private HandlerId m_id;

    public HandlerKey(Class<? extends ITraceEventHandler> type, String id) {
        this(type, new HandlerId(id));
    }

    public HandlerKey(Class<? extends ITraceEventHandler> type, HandlerId id) {
        if (type == null) {
            DsfExceptionHelper.chuck("type is null");
        }
        if (type.isInterface()) {
            DsfExceptionHelper.chuck("type is an interface");
        }
        if (id == null) {
            DsfExceptionHelper.chuck("id is null");
        }
        this.m_type = type;
        this.m_id = id;
    }

    public Class<? extends ITraceEventHandler> getType() {
        return this.m_type;
    }

    public HandlerId getId() {
        return this.m_id;
    }

    public static HandlerKey parse(String value) {
        Class<?> handlerType;
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        int index = value.indexOf(DELIMITER);
        if (index < 0) {
            return null;
        }
        String typeName = value.substring(0, index).trim();
        String id = value.substring(index + 1).trim();
        if (typeName.length() == 0 || id.length() == 0) {
            return null;
        }
        try {
            handlerType = Class.forName(typeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        if (handlerType == ITraceEventHandler.class) {
            return null;
        }
        return new HandlerKey(handlerType, id);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != HandlerKey.class) {
            return false;
        }
        HandlerKey that = (HandlerKey)obj;
        return this.m_type == that.m_type && this.m_id.getName().equals(that.m_id.getName());
    }

    public int hashCode() {
        return this.m_type.hashCode() + this.m_id.getName().hashCode();
    }

    public String toString() {
        Z z = new Z();
        z.format("type", this.m_type);
        z.format("id", this.m_id.getName());
        return z.toString();
    }
}

