/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.initialization;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;

public class ShutdownRuntimeException
extends RuntimeException {
    final Collection m_exceptions;

    public ShutdownRuntimeException(Collection exceptions) {
        super("Shutdown sequence has failed");
        this.m_exceptions = exceptions;
    }

    Collection getExceptions() {
        return this.m_exceptions;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.println(this);
            String stackTrace = this.getStackTraceX();
            ps.print(stackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            pw.println(this);
            String stackTrace = this.getStackTraceX();
            pw.print(stackTrace);
        }
    }

    private String getStackTraceX() {
        StringBuilder buf = new StringBuilder();
        buf.append("The following shutdown exceptions occured:\n");
        int i = 1;
        for (RuntimeException re : this.m_exceptions) {
            StringWriter buf2 = new StringWriter();
            PrintWriter pout = new PrintWriter(buf2);
            re.printStackTrace(pout);
            pout.flush();
            String message = buf2.toString();
            buf.append("Exception # " + i + ":\r\n");
            buf.append(message);
            ++i;
        }
        String stackTrace = buf.toString();
        return stackTrace;
    }
}

