/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.initialization;

import org.eclipse.vjet.dsf.common.initialization.BaseInitializationManager;
import org.eclipse.vjet.dsf.common.initialization.Initializable;
import org.eclipse.vjet.dsf.common.initialization.InitializationException;
import org.eclipse.vjet.dsf.common.initialization.InitializationHelper;
import org.eclipse.vjet.dsf.common.initialization.InitializationManagerInterface;
import org.eclipse.vjet.dsf.common.initialization.ModuleInterface;

public abstract class BaseModule
implements ModuleInterface {
    private final InitializationManagerInterface m_initializationManager;
    private final InitializationHelper m_initHelper;
    private boolean m_isLazyInitable = true;

    public BaseModule(InitializationManagerInterface initializationManager) {
        if (initializationManager == null) {
            throw new NullPointerException();
        }
        this.m_initializationManager = initializationManager;
        this.m_initHelper = null;
    }

    public BaseModule(ModuleInterface[] dependentModules) {
        String componentName = String.valueOf(this.getClass().getName()) + ".InitManager";
        InitializationManager initMgr = new InitializationManager(dependentModules, componentName);
        this.m_initializationManager = initMgr;
        this.m_initHelper = initMgr.getInitializationHelper2();
    }

    @Override
    public InitializationManagerInterface getInitializationManager() {
        return this.m_initializationManager;
    }

    private void checkForOwnInitManager() {
        if (this.m_initHelper == null) {
            throw new InitializationException("To use this method, BaseModule must be constructed without passing InitializationManagerInterface");
        }
    }

    protected final void addInitializable(Initializable initializable) {
        this.checkForOwnInitManager();
        this.m_initHelper.add(initializable);
    }

    protected final void setLazyInitable(boolean value) {
        this.checkForOwnInitManager();
        this.m_isLazyInitable = value;
    }

    private class InitializationManager
    extends BaseInitializationManager {
        private final String m_componentName;

        InitializationManager(ModuleInterface[] dependentModules, String componentName) {
            super(dependentModules);
            this.m_componentName = componentName;
        }

        public InitializationHelper getInitializationHelper2() {
            return this.getInitializationHelper();
        }

        @Override
        public String getComponentName() {
            return this.m_componentName;
        }

        @Override
        public boolean isLazyInitable() {
            return BaseModule.this.m_isLazyInitable;
        }
    }
}

